/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore;

import java.util.function.Consumer;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;

public class TileChannel<T>
implements Consumer<TileCoord> {
    public final TileStore<T> source;
    public final TileStore<T> target;
    public final boolean deleteEmptyTiles;

    public TileChannel(TileStore<T> source, TileStore<T> target) {
        this(source, target, false);
    }

    public TileChannel(TileStore<T> source, TileStore<T> target, boolean deleteEmptyTiles) {
        this.source = source;
        this.target = target;
        this.deleteEmptyTiles = deleteEmptyTiles;
    }

    @Override
    public void accept(TileCoord tileCoord) {
        try {
            T tile = this.source.read(tileCoord);
            if (tile != null) {
                this.target.write(tileCoord, tile);
            } else if (this.deleteEmptyTiles) {
                this.target.delete(tileCoord);
            }
        }
        catch (TileStoreException ex) {
            throw new RuntimeException("An error occurred while creating the tiles", ex);
        }
    }
}

