/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import com.google.common.graph.MutableGraph;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.baremaps.postgres.refresh.DatabaseMetadataRetriever;
import org.apache.baremaps.postgres.refresh.DependencyGraphBuilder;
import org.apache.baremaps.postgres.refresh.MaterializedViewRefresher;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshMaterializedViews
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshMaterializedViews.class);
    private Object database;

    public RefreshMaterializedViews() {
    }

    public RefreshMaterializedViews(Object database) {
        this.database = database;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        DataSource dataSource = context.getDataSource(this.database);
        try (Connection connection = dataSource.getConnection();){
            LOGGER.info("Connected to PostgreSQL database.");
            String schema = connection.getSchema();
            List objects = DatabaseMetadataRetriever.getObjects((Connection)connection, (String)schema);
            List dependencies = DatabaseMetadataRetriever.getDependencies((Connection)connection, (String)schema, (List)objects);
            MutableGraph graph = DependencyGraphBuilder.buildGraph((List)objects, (List)dependencies);
            List sorted = DependencyGraphBuilder.topologicalSort((MutableGraph)graph);
            MaterializedViewRefresher.refreshMaterializedViews((Connection)connection, (List)sorted);
            LOGGER.info("Done refreshing materialized views.");
        }
        catch (SQLException ex) {
            LOGGER.error("Database error", (Throwable)ex);
        }
    }
}

