/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.postgres.openstreetmap.NodeRepository;
import org.apache.baremaps.postgres.openstreetmap.RelationRepository;
import org.apache.baremaps.postgres.openstreetmap.Repository;
import org.apache.baremaps.postgres.openstreetmap.RepositoryException;
import org.apache.baremaps.postgres.openstreetmap.WayRepository;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportDaylightTranslations
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ImportDaylightTranslations.class);
    private Path file;
    private Object database;

    public ImportDaylightTranslations() {
    }

    public ImportDaylightTranslations(Path file, Object database) {
        this.file = file;
        this.database = database;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        DataSource datasource = context.getDataSource(this.database);
        NodeRepository nodeRepository = new NodeRepository(datasource);
        WayRepository wayRepository = new WayRepository(datasource);
        RelationRepository relationRepository = new RelationRepository(datasource);
        nodeRepository.create();
        wayRepository.create();
        relationRepository.create();
        try (Stream<String> lines = Files.lines(this.file);){
            Map<Group, List<Line>> entries = lines.map(Line::parse).collect(Collectors.groupingBy(Line::group));
            block15: for (Map.Entry<Group, List<Line>> entry : entries.entrySet()) {
                Group key = entry.getKey();
                List<Line> value = entry.getValue();
                switch (entry.getKey().type()) {
                    case "node": {
                        this.save(key, value, (Repository)nodeRepository);
                        continue block15;
                    }
                    case "way": {
                        this.save(key, value, (Repository)wayRepository);
                        continue block15;
                    }
                    case "relation": {
                        this.save(key, value, (Repository)relationRepository);
                        continue block15;
                    }
                }
                logger.warn("Unknown type: {}", (Object)key.type());
            }
        }
    }

    private <T extends Element> void save(Group group, List<Line> lines, Repository<Long, T> repository) throws RepositoryException {
        Element entity = (Element)repository.get((Object)group.id());
        if (entity != null) {
            HashMap<String, String> tags = new HashMap<String, String>(entity.getTags());
            for (Line line : lines) {
                tags.put(line.attributeKey(), line.attributeValue());
            }
            entity.setTags(tags);
            repository.put((Object)entity);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ImportDaylightTranslations.class.getSimpleName() + "[", "]").add("file=" + String.valueOf(this.file)).add("database=" + String.valueOf(this.database)).toString();
    }

    record Group(String type, Long id, String name) {
    }

    record Line(String type, Long id, String name, String attributeKey, String attributeValue) {
        public Group group() {
            return new Group(this.type, this.id, this.name);
        }

        public static Line parse(String line) {
            String[] parts = line.split("\t");
            String type = parts[0];
            long id = Long.parseLong(parts[1]);
            String name = parts[2];
            String key = parts[3];
            String val = parts[4];
            return new Line(type, id, name, key, val);
        }
    }
}

