/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Time;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.TemporalDatum;

@XmlType(name="TemporalCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="TemporalCRS")
public class DefaultTemporalCRS
extends AbstractCRS
implements TemporalCRS {
    private static final long serialVersionUID = 3000119849197222007L;
    private TemporalDatum datum;
    private transient UnitConverter toSeconds;
    private transient long origin;

    public DefaultTemporalCRS(Map<String, ?> properties, TemporalDatum datum, TimeCS cs) {
        super(properties, (CoordinateSystem)cs);
        ArgumentChecks.ensureNonNull((String)"datum", (Object)datum);
        this.datum = datum;
        this.initializeConverter();
    }

    protected DefaultTemporalCRS(TemporalCRS crs) {
        super((CoordinateReferenceSystem)crs);
        this.datum = crs.getDatum();
        this.initializeConverter();
    }

    public static DefaultTemporalCRS castOrCopy(TemporalCRS object) {
        return object == null || object instanceof DefaultTemporalCRS ? (DefaultTemporalCRS)object : new DefaultTemporalCRS(object);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeConverter();
    }

    private void initializeConverter() {
        this.toSeconds = this.getUnit().getConverterTo(Units.SECOND);
        long t = this.datum.getOrigin().getTime();
        this.origin = t / 1000L;
        if ((t %= 1000L) != 0L) {
            UnitConverter c = Units.converter(null, (Number)Fraction.valueOf((long)t, (long)1000L));
            this.toSeconds = c.concatenate(this.toSeconds);
        }
    }

    public Class<? extends TemporalCRS> getInterface() {
        return TemporalCRS.class;
    }

    @XmlElement(name="temporalDatum", required=true)
    public TemporalDatum getDatum() {
        return this.datum;
    }

    @XmlElement(name="timeCS", required=true)
    public TimeCS getCoordinateSystem() {
        return (TimeCS)super.getCoordinateSystem();
    }

    public final Unit<Time> getUnit() {
        return super.getCoordinateSystem().getAxis(0).getUnit().asType(Time.class);
    }

    @Override
    public DefaultTemporalCRS forConvention(AxesConvention convention) {
        return (DefaultTemporalCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        return new DefaultTemporalCRS(properties, this.datum, (TimeCS)cs);
    }

    public Instant toInstant(double value) {
        if (Double.isFinite(value)) {
            value = this.toSeconds.convert(value);
            long t = Math.round(value);
            return Instant.ofEpochSecond(Math.addExact(t, this.origin), Math.round((value - (double)t) * 1.0E9));
        }
        return null;
    }

    public Date toDate(double value) {
        if (Double.isFinite(value)) {
            value = this.toSeconds.convert(value);
            long t = Math.round(value);
            long ms = Math.addExact(t, this.origin);
            ms = Math.multiplyExact(ms, 1000);
            ms = Math.addExact(Math.round((value - (double)t) * 1000.0), ms);
            return new Date(ms);
        }
        return null;
    }

    public Duration toDuration(double delta) {
        if (Double.isFinite(delta *= Units.derivative((UnitConverter)this.toSeconds, (double)Double.NaN))) {
            long t = Math.round(delta);
            return Duration.ofSeconds(t, Math.round((delta - (double)t) * 1.0E9));
        }
        return null;
    }

    public double toValue(Instant time) {
        if (time != null) {
            double t = Math.subtractExact(time.getEpochSecond(), this.origin);
            return this.toSeconds.inverse().convert(t += (double)time.getNano() / 1.0E9);
        }
        return Double.NaN;
    }

    public double toValue(Date time) {
        if (time != null) {
            long ms = time.getTime();
            long t = ms / 1000L;
            t = Math.subtractExact(t, this.origin);
            return this.toSeconds.inverse().convert((double)t + (double)(ms %= 1000L) / 1000.0);
        }
        return Double.NaN;
    }

    public double toValue(Duration delta) {
        if (delta != null) {
            double t = delta.getSeconds();
            t += (double)delta.getNano() / 1.0E9;
            return t *= Units.derivative((UnitConverter)this.toSeconds.inverse(), (double)Double.NaN);
        }
        return Double.NaN;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return DefaultTemporalCRS.isBaseCRS(formatter) ? "BaseTimeCRS" : "TimeCRS";
    }

    private DefaultTemporalCRS() {
    }

    private void setDatum(TemporalDatum value) {
        if (this.datum == null) {
            this.datum = value;
            if (super.getCoordinateSystem() != null) {
                this.initializeConverter();
            }
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultVerticalCRS.class, (String)"setDatum", (String)"temporalDatum");
        }
    }

    private void setCoordinateSystem(TimeCS cs) {
        this.setCoordinateSystem("timeCS", (CoordinateSystem)cs);
        if (this.toSeconds == null && this.datum != null) {
            this.initializeConverter();
        }
    }
}

