/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.ObjectStreamException;
import java.util.HashMap;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.TensorParameters;
import org.apache.sis.referencing.NamedIdentifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;

class MatrixParameters
extends TensorParameters<Double> {
    private static final long serialVersionUID = 8452879524565700115L;

    MatrixParameters(ParameterDescriptor<Integer> numRow, ParameterDescriptor<Integer> numCol) {
        super(Double.class, "elt_", "_", numRow, numCol);
    }

    static boolean isEPSG(int[] indices) {
        return indices[0] < 2 && indices[1] <= 2;
    }

    static String indicesToAlias(int[] indices) {
        int col;
        int row = indices[0];
        if (row >= 0 && row < 26 && (col = indices[1]) >= 0 && col < 10) {
            return String.valueOf(new char[]{(char)(65 + row), (char)(48 + col)});
        }
        return null;
    }

    static int[] aliasToIndices(String alias) {
        int col;
        int row;
        if (alias.length() == 2 && (row = alias.charAt(0) - 65) >= 0 && row < 26 && (col = alias.charAt(1) - 48) >= 0 && col < 10) {
            return new int[]{row, col};
        }
        return null;
    }

    @Override
    protected int[] nameToIndices(String name) throws IllegalArgumentException {
        int[] indices = MatrixParameters.aliasToIndices(name);
        if (indices == null) {
            indices = super.nameToIndices(name);
        }
        return indices;
    }

    @Override
    protected ParameterDescriptor<Double> createElementDescriptor(int[] indices) throws IllegalArgumentException {
        HashMap<String, NamedIdentifier> properties = new HashMap<String, NamedIdentifier>(4);
        properties.put("name", new NamedIdentifier((Citation)Citations.OGC, "OGC", (CharSequence)this.indicesToName(indices), null, null));
        String c = MatrixParameters.indicesToAlias(indices);
        if (c != null) {
            properties.put("alias", new NamedIdentifier(Citations.SIS, "SIS", (CharSequence)c, null, null));
        }
        return new DefaultParameterDescriptor<Double>(properties, 0, 1, Double.class, null, null, (Double)this.getDefaultValue(indices));
    }

    Object readResolve() throws ObjectStreamException {
        return this.equals(WKT1) ? WKT1 : this;
    }
}

