/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.net.URLConnection;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.apache.logging.log4j.core.util.BasicAuthorizationProvider;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertyEnvironment;
import org.apache.logging.log4j.util.PropertyKey;

public interface AuthorizationProvider {
    public void addAuthorization(URLConnection var1);

    public static AuthorizationProvider getAuthorizationProvider(PropertyEnvironment properties) {
        String authClass = properties.getStringProperty((PropertyKey)Log4jPropertyKey.CONFIG_AUTH_PROVIDER);
        if (authClass != null) {
            try {
                return (AuthorizationProvider)LoaderUtil.newInstanceOfUnchecked((String)authClass, AuthorizationProvider.class);
            }
            catch (LinkageError | RuntimeException e) {
                StatusLogger.getLogger().warn("Unable to create {}, using default", (Object)authClass, (Object)e);
            }
        }
        return new BasicAuthorizationProvider(properties);
    }
}

