/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.baremaps.data.type.DataType;

public class MapDataType<K, V>
implements DataType<Map<K, V>> {
    private final DataType<K> keyType;
    private final DataType<V> valueType;

    public MapDataType(DataType<K> keyType, DataType<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public int size(Map<K, V> value) {
        int size = 4;
        for (Map.Entry<K, V> entry : value.entrySet()) {
            size += this.keyType.size(entry.getKey());
            size += this.valueType.size(entry.getValue());
        }
        return size;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, Map<K, V> value) {
        buffer.putInt(position, this.size(value));
        int p = position + 4;
        for (Map.Entry<K, V> entry : value.entrySet()) {
            this.keyType.write(buffer, p, entry.getKey());
            this.valueType.write(buffer, p += this.keyType.size(entry.getKey()), entry.getValue());
            p += this.valueType.size(entry.getValue());
        }
    }

    @Override
    public Map<K, V> read(ByteBuffer buffer, int position) {
        V value;
        int size = buffer.getInt(position);
        HashMap<K, V> map = new HashMap<K, V>(size);
        for (int p = position + 4; p < position + size; p += this.valueType.size(value)) {
            K key = this.keyType.read(buffer, p);
            value = this.valueType.read(buffer, p += this.keyType.size(key));
            map.put(key, value);
        }
        return map;
    }
}

