/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.data.type.DataType;

public class BooleanArrayDataType
implements DataType<boolean[]> {
    @Override
    public int size(boolean[] values) {
        return 4 + values.length * 1;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, boolean[] values) {
        buffer.putInt(position, this.size(values));
        int p = position + 4;
        for (boolean value : values) {
            buffer.put(p, (byte)(value ? 1 : 0));
            ++p;
        }
    }

    @Override
    public boolean[] read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int length = (size - 4) / 1;
        boolean[] values = new boolean[length];
        for (int index = 0; index < length; ++index) {
            values[index] = buffer.get(position + 4 + index * 1) == 1;
        }
        return values;
    }
}

