/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.auth;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.auth.AuthToken;
import com.linecorp.armeria.common.auth.OAuth1aToken;
import com.linecorp.armeria.common.auth.OAuth1aTokenBuilder;
import com.linecorp.armeria.internal.common.PercentDecoder;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import io.netty.util.AsciiString;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OAuth1aTokenExtractor
implements Function<RequestHeaders, OAuth1aToken> {
    private static final Logger logger = LoggerFactory.getLogger(OAuth1aTokenExtractor.class);
    private static final Pattern AUTHORIZATION_HEADER_PATTERN = Pattern.compile("\\s*(?i)oauth\\s+(?<parameters>\\S+)\\s*");
    private final AsciiString header;

    OAuth1aTokenExtractor(CharSequence header) {
        this.header = HttpHeaderNames.of(header);
    }

    @Override
    @Nullable
    public OAuth1aToken apply(RequestHeaders headers) {
        String authorization = Objects.requireNonNull(headers, "headers").get((CharSequence)this.header);
        if (Strings.isNullOrEmpty(authorization)) {
            return null;
        }
        Matcher matcher = AUTHORIZATION_HEADER_PATTERN.matcher(authorization);
        if (!matcher.matches()) {
            logger.warn("Invalid authorization header: " + authorization);
            return null;
        }
        OAuth1aTokenBuilder builder = AuthToken.builderForOAuth1a();
        for (String token : matcher.group("parameters").split(",")) {
            int sep = token.indexOf(61);
            if (sep == -1 || token.charAt(sep + 1) != '\"' || token.charAt(token.length() - 1) != '\"') {
                logger.warn("Invalid token: " + token);
                return null;
            }
            String key = token.substring(0, sep);
            String value = token.substring(sep + 2, token.length() - 1);
            builder.put(PercentDecoder.decodeComponent(key), PercentDecoder.decodeComponent(value));
        }
        return builder.build();
    }
}

