/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.audit;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.AccessDeniedException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.api.UnsupportedRequestException;
import org.apache.hadoop.fs.s3a.audit.AuditFailureException;
import org.apache.hadoop.fs.s3a.audit.AuditManagerS3A;
import org.apache.hadoop.fs.s3a.audit.AuditOperationRejectedException;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.audit.OperationAuditor;
import org.apache.hadoop.fs.s3a.audit.OperationAuditorOptions;
import org.apache.hadoop.fs.s3a.audit.impl.ActiveAuditManagerS3A;
import org.apache.hadoop.fs.s3a.audit.impl.LoggingAuditor;
import org.apache.hadoop.fs.s3a.audit.impl.NoopAuditManagerS3A;
import org.apache.hadoop.fs.s3a.audit.impl.S3AInternalAuditConstants;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;

public final class AuditIntegration {
    private static final Logger LOG = LoggerFactory.getLogger(AuditIntegration.class);

    private AuditIntegration() {
    }

    public static AuditManagerS3A createAndStartAuditManager(Configuration conf, IOStatisticsStore iostatistics) {
        AuditManagerS3A auditManager;
        if (conf.getBoolean("fs.s3a.audit.enabled", true)) {
            auditManager = new ActiveAuditManagerS3A(Objects.requireNonNull(iostatistics));
        } else {
            LOG.debug("auditing is disabled");
            auditManager = AuditIntegration.stubAuditManager();
        }
        auditManager.init(conf);
        auditManager.start();
        LOG.debug("Started Audit Manager {}", (Object)auditManager);
        return auditManager;
    }

    public static AuditManagerS3A stubAuditManager() {
        return new NoopAuditManagerS3A();
    }

    public static OperationAuditor createAndInitAuditor(Configuration conf, String key, OperationAuditorOptions options) throws IOException {
        Class auditClassname = conf.getClass(key, LoggingAuditor.class, OperationAuditor.class);
        try {
            LOG.debug("Auditor class is {}", (Object)auditClassname);
            Constructor constructor = auditClassname.getConstructor(new Class[0]);
            OperationAuditor instance = (OperationAuditor)constructor.newInstance(new Object[0]);
            instance.init(options);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            throw new IOException("Failed to instantiate class " + auditClassname + " defined in " + key + ": " + e, e);
        }
    }

    public static AuditSpanS3A retrieveAttachedSpan(ExecutionAttributes executionAttributes) {
        return (AuditSpanS3A)executionAttributes.getAttribute(S3AInternalAuditConstants.AUDIT_SPAN_EXECUTION_ATTRIBUTE);
    }

    public static void attachSpanToRequest(ExecutionAttributes executionAttributes, AuditSpanS3A span) {
        executionAttributes.putAttribute(S3AInternalAuditConstants.AUDIT_SPAN_EXECUTION_ATTRIBUTE, (Object)span);
    }

    public static IOException translateAuditException(String path, AuditFailureException exception) {
        if (exception instanceof AuditOperationRejectedException) {
            return new UnsupportedRequestException(path, exception.getMessage(), (Throwable)((Object)exception));
        }
        return (AccessDeniedException)new AccessDeniedException(path, null, exception.toString()).initCause((Throwable)((Object)exception));
    }

    public static IOException maybeTranslateAuditException(String path, Exception exception) {
        if (exception instanceof AuditFailureException) {
            return AuditIntegration.translateAuditException(path, (AuditFailureException)((Object)exception));
        }
        if (exception.getCause() instanceof AuditFailureException) {
            return AuditIntegration.translateAuditException(path, (AuditFailureException)((Object)exception.getCause()));
        }
        return null;
    }

    public static boolean containsAuditException(Exception exception) {
        return exception instanceof AuditFailureException || exception.getCause() instanceof AuditFailureException;
    }
}

