/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorAwaitReturnNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import java.util.ArrayDeque;

public class AsyncGeneratorDrainQueueNode
extends AsyncGeneratorAwaitReturnNode {
    AsyncGeneratorDrainQueueNode(JSContext context) {
        super(context);
    }

    public static AsyncGeneratorDrainQueueNode create(JSContext context) {
        return new AsyncGeneratorDrainQueueNode(context);
    }

    public final void asyncGeneratorCompleteStepAndDrainQueue(VirtualFrame frame, Object generator, Completion.Type resultType, Object resultValue) {
        ArrayDeque queue = (ArrayDeque)this.getGeneratorQueue.getValue(generator);
        this.setGeneratorState.setValue(generator, (Object)JSFunction.AsyncGeneratorState.Completed);
        this.asyncGeneratorCompleteStep(frame, resultType, resultValue, true, queue);
        if (!queue.isEmpty()) {
            this.asyncGeneratorDrainQueue(frame, generator, queue);
        }
    }

    public final void asyncGeneratorDrainQueue(VirtualFrame frame, Object generator, ArrayDeque<AsyncGeneratorRequest> queue) {
        Object state;
        assert ((state = JSObjectUtil.getHiddenProperty((JSDynamicObject)((Object)generator), JSFunction.ASYNC_GENERATOR_STATE_ID)) == JSFunction.AsyncGeneratorState.Completed) : state;
        while (!queue.isEmpty()) {
            AsyncGeneratorRequest next = queue.peekFirst();
            if (next.getCompletionType() == Completion.Type.Return) {
                this.setGeneratorState.setValue(generator, (Object)JSFunction.AsyncGeneratorState.AwaitingReturn);
                try {
                    this.asyncGeneratorAwaitReturn(generator, queue);
                    break;
                }
                catch (AbstractTruffleException ex) {
                    this.asyncGeneratorRejectBrokenPromise(frame, generator, ex, queue);
                    continue;
                }
            }
            this.asyncGeneratorCompleteStep(frame, next.getCompletionType(), next.getCompletionValue(), true, queue);
        }
    }
}

