/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.ConvertedCategory;
import org.apache.sis.coverage.IllegalSampleDimensionException;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.io.wkt.UnformattableObjectException;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class CategoryList
extends AbstractList<Category>
implements MathTransform1D,
Serializable {
    private static final long serialVersionUID = -457688134719705403L;
    static final CategoryList EMPTY = new CategoryList();
    final NumberRange<?> range;
    private final double[] minimums;
    private final Category[] categories;
    private final double[] converseRanges;
    private transient int lastUsed;
    final CategoryList converse;
    private final double fallback;

    private CategoryList() {
        this.range = null;
        this.minimums = ArraysExt.EMPTY_DOUBLE;
        this.categories = new Category[0];
        this.converseRanges = null;
        this.converse = this;
        this.fallback = Double.NaN;
    }

    private CategoryList(Category[] categories, CategoryList converse, Number background) {
        Category category;
        boolean isSampleToUnit;
        this.categories = categories;
        int count = categories.length;
        boolean bl = isSampleToUnit = converse == null;
        if (isSampleToUnit) {
            for (int i = 0; i < count; ++i) {
                Category c = categories[i];
                if (!(c instanceof ConvertedCategory)) continue;
                categories[i] = new Category(c, null);
            }
        }
        Arrays.sort(categories, Category.COMPARATOR);
        double[] extremums = new double[count * 2];
        this.minimums = new double[count];
        int countOfFiniteRanges = 0;
        NumberRange range = null;
        int i = count;
        while (--i >= 0) {
            category = categories[i];
            this.minimums[i] = category.range.getMinDouble(true);
            if (!Double.isNaN(this.minimums[i])) {
                if (range == null) {
                    range = categories[0].range;
                    assert (!Double.isNaN(range.getMinDouble())) : range;
                }
                range = range.unionAny(category.range);
            }
            int j = i << 1;
            NumberRange<?> cr = category.converse.range;
            double d = cr.getMaxDouble(true);
            extremums[j | 1] = d;
            extremums[j] = cr.getMinDouble(true);
            if (!(!Double.isNaN(d) | !Double.isNaN(extremums[j]))) continue;
            ++countOfFiniteRanges;
        }
        this.range = range;
        Object object = this.converseRanges = (Object)(countOfFiniteRanges >= 2 ? extremums : null);
        assert (ArraysExt.isSorted((double[])this.minimums, (boolean)false));
        for (i = 1; i < count; ++i) {
            category = categories[i];
            Category previous = categories[i - 1];
            double minimum = this.minimums[i];
            if (Category.compare(minimum, previous.range.getMaxDouble(true)) <= 0) {
                throw new IllegalSampleDimensionException(Resources.format((short)15, previous.name, previous.getRangeLabel(), category.name, category.getRangeLabel()));
            }
            double limit = previous.range.getMaxDouble(false);
            if (!(minimum > limit) || !previous.converse.isConvertedQualitative() || category.converse.isConvertedQualitative()) continue;
            this.minimums[i] = limit;
        }
        assert (ArraysExt.isSorted((double[])this.minimums, (boolean)true));
        if (isSampleToUnit) {
            int i2;
            boolean isQualitative = true;
            boolean isIdentity = true;
            Category[] convertedCategories = new Category[count];
            for (i2 = 0; i2 < count; ++i2) {
                Category converted;
                Category category2 = categories[i2];
                convertedCategories[i2] = converted = category2.converse;
                isQualitative &= converted.isConvertedQualitative();
                isIdentity &= category2 == converted;
            }
            if (isQualitative) {
                converse = EMPTY;
            } else if (isIdentity) {
                converse = this;
            } else {
                converse = new CategoryList(convertedCategories, this, background);
                if (this.converseRanges != null) {
                    for (i2 = 1; i2 < this.converseRanges.length; i2 += 2) {
                        double maximum = this.converseRanges[i2];
                        int p = ~Arrays.binarySearch(converse.minimums, maximum);
                        if (p >= 0 && p < count) {
                            double limit = Math.nextDown(converse.minimums[p]);
                            if (Double.isNaN(limit)) {
                                limit = Double.POSITIVE_INFINITY;
                            }
                            if (limit > maximum) {
                                this.converseRanges[i2] = limit;
                            }
                            if (p != 1) continue;
                            this.converseRanges[i2 - 1] = Double.NEGATIVE_INFINITY;
                            continue;
                        }
                        if (p != count) continue;
                        this.converseRanges[i2] = Double.POSITIVE_INFINITY;
                    }
                }
            }
        }
        this.converse = converse;
        if (count != 0) {
            NumberRange<?> cr;
            double cv;
            if (!Double.isNaN(this.minimums[0])) {
                this.minimums[0] = Double.NEGATIVE_INFINITY;
            }
            if (isSampleToUnit) {
                int n = converse.minimums.length;
                if (n != 0 && Double.isNaN(converse.minimums[n - 1])) {
                    this.fallback = 0.0;
                    return;
                }
            } else if (background == null && converse.categories.length != 0 && ((cv = (cr = converse.categories[0].range).getMinDouble()) > 0.0 || cv == 0.0 && !cr.isMinIncluded())) {
                this.fallback = 0.0;
                return;
            }
        }
        this.fallback = !isSampleToUnit && background != null ? background.doubleValue() : Double.NaN;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.categories.length == 0 ? EMPTY : this;
    }

    static CategoryList create(Category[] categories, Number background) {
        return new CategoryList(categories, null, background);
    }

    final boolean allowsNaN() {
        int n = this.minimums.length;
        return n != 0 && Double.isNaN(this.minimums[n - 1]);
    }

    final MathTransform1D getTransferFunction() {
        MathTransform1D tr = this.categories[0].toConverse;
        int i = this.categories.length;
        while (--i >= 1) {
            if (tr.equals(this.categories[i].toConverse)) continue;
            tr = this;
            break;
        }
        return tr;
    }

    static int binarySearch(double[] minimums, double sample) {
        int low = 0;
        int high = minimums.length - 1;
        boolean sampleIsNaN = Double.isNaN(sample);
        while (low <= high) {
            boolean adjustLow;
            long smpRawBits;
            int mid = low + high >>> 1;
            double midVal = minimums[mid];
            if (midVal < sample) {
                low = mid + 1;
                continue;
            }
            if (midVal > sample) {
                high = mid - 1;
                continue;
            }
            long midRawBits = Double.doubleToRawLongBits(midVal);
            if (midRawBits == (smpRawBits = Double.doubleToRawLongBits(sample))) {
                return mid;
            }
            boolean midIsNaN = Double.isNaN(midVal);
            if (sampleIsNaN) {
                adjustLow = !midIsNaN || midRawBits < smpRawBits;
            } else {
                boolean bl = adjustLow = !midIsNaN && midRawBits < smpRawBits;
            }
            if (adjustLow) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return sampleIsNaN ? -1 : low - 1;
    }

    final Category search(double sample) {
        int i = CategoryList.binarySearch(this.minimums, sample);
        return i >= 0 ? this.categories[i] : null;
    }

    private double unmappedValue(double value) throws TransformException {
        if (MathFunctions.isPositiveZero((double)this.fallback)) {
            return value;
        }
        if (Double.isNaN(this.fallback)) {
            throw new TransformException(CategoryList.formatNoCategory(value));
        }
        return this.fallback;
    }

    private static String formatNoCategory(double value) {
        return Resources.format((short)49, Double.isNaN(value) ? "NaN #" + MathFunctions.toNanOrdinal((float)((float)value)) : Double.valueOf(value));
    }

    private void transform(double[] srcPts, float[] srcFloat, int srcOff, double[] dstPts, float[] dstFloat, int dstOff, int numPts) throws TransformException {
        int direction;
        int srcToDst = dstOff - srcOff;
        if (srcOff >= dstOff || (srcFloat != null ? srcFloat != dstFloat : srcPts != dstPts)) {
            direction = 1;
        } else {
            direction = -1;
            srcOff += numPts - 1;
        }
        int index = this.lastUsed;
        double value = Double.NaN;
        int peekOff = srcOff;
        while (true) {
            int count;
            double minimum = this.minimums[index];
            double limit = index + 1 < this.minimums.length ? this.minimums[index + 1] : Double.NaN;
            long rawBits = Double.doubleToRawLongBits(minimum);
            while (--numPts >= 0) {
                double d = value = srcFloat != null ? (double)srcFloat[peekOff] : srcPts[peekOff];
                if (value >= minimum ? value >= limit : Double.doubleToRawLongBits(value) != rawBits) break;
                peekOff += direction;
            }
            if ((count = peekOff - srcOff) < 0) {
                count = -count;
                srcOff -= count - 1;
            }
            int stepOff = srcOff + srcToDst;
            MathTransform1D piece = this.categories[index].toConverse;
            if (srcFloat != null) {
                if (dstFloat != null) {
                    piece.transform(srcFloat, srcOff, dstFloat, stepOff, count);
                } else {
                    piece.transform(srcFloat, srcOff, dstPts, stepOff, count);
                }
            } else if (dstFloat != null) {
                piece.transform(srcPts, srcOff, dstFloat, stepOff, count);
            } else {
                piece.transform(srcPts, srcOff, dstPts, stepOff, count);
            }
            if (this.converseRanges != null) {
                dstOff = srcOff + srcToDst;
                if (dstFloat != null) {
                    float min = (float)this.converseRanges[index << 1];
                    float max = (float)this.converseRanges[index << 1 | 1];
                    while (--count >= 0) {
                        float check = dstFloat[dstOff];
                        if (check < min) {
                            dstFloat[dstOff] = min;
                        } else if (check > max) {
                            dstFloat[dstOff] = max;
                        }
                        ++dstOff;
                    }
                } else {
                    double min = this.converseRanges[index << 1];
                    double max = this.converseRanges[index << 1 | 1];
                    while (--count >= 0) {
                        double check = dstPts[dstOff];
                        if (check < min) {
                            dstPts[dstOff] = min;
                        } else if (check > max) {
                            dstPts[dstOff] = max;
                        }
                        ++dstOff;
                    }
                }
            }
            if (numPts < 0) break;
            while ((index = CategoryList.binarySearch(this.minimums, value)) < 0) {
                double fill = this.unmappedValue(value);
                int i = peekOff + srcToDst;
                if (dstFloat != null) {
                    dstFloat[i] = (float)fill;
                } else {
                    dstPts[i] = fill;
                }
                if (--numPts < 0) {
                    return;
                }
                value = srcFloat != null ? (double)srcFloat[peekOff] : srcPts[peekOff += direction];
            }
            srcOff = peekOff;
            peekOff += direction;
        }
        this.lastUsed = index;
    }

    private static void ensureNonNull(Object srcPts, Object dstPts) {
        ArgumentChecks.ensureNonNull((String)"srcPts", (Object)srcPts);
        ArgumentChecks.ensureNonNull((String)"dstPts", (Object)dstPts);
    }

    public final void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        CategoryList.ensureNonNull(srcPts, dstPts);
        this.transform(srcPts, null, srcOff, dstPts, null, dstOff, numPts);
    }

    public final void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        CategoryList.ensureNonNull(srcPts, dstPts);
        this.transform(null, srcPts, srcOff, null, dstPts, dstOff, numPts);
    }

    public final void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        CategoryList.ensureNonNull(srcPts, dstPts);
        this.transform(null, srcPts, srcOff, dstPts, null, dstOff, numPts);
    }

    public final void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        CategoryList.ensureNonNull(srcPts, dstPts);
        this.transform(srcPts, null, srcOff, null, dstPts, dstOff, numPts);
    }

    public final double transform(double value) throws TransformException {
        int index = this.lastUsed;
        double minimum = this.minimums[index];
        if (value >= minimum ? index + 1 < this.minimums.length && value >= this.minimums[index + 1] : Double.doubleToRawLongBits(value) != Double.doubleToRawLongBits(minimum)) {
            index = CategoryList.binarySearch(this.minimums, value);
            if (index < 0) {
                return this.unmappedValue(value);
            }
            this.lastUsed = index;
        }
        value = this.categories[index].toConverse.transform(value);
        if (this.converseRanges != null) {
            double d;
            double d2;
            double bound = this.converseRanges[index << 1];
            if (value < d2) {
                return bound;
            }
            bound = this.converseRanges[index << 1 | 1];
            if (value > d) {
                return bound;
            }
        }
        return value;
    }

    public final double derivative(double value) throws TransformException {
        int index = this.lastUsed;
        double minimum = this.minimums[index];
        if (value >= minimum ? index + 1 < this.minimums.length && value >= this.minimums[index + 1] : Double.doubleToRawLongBits(value) != Double.doubleToRawLongBits(minimum)) {
            index = CategoryList.binarySearch(this.minimums, value);
            if (index < 0) {
                throw new TransformException(CategoryList.formatNoCategory(value));
            }
            this.lastUsed = index;
        }
        return this.categories[index].toConverse.derivative(value);
    }

    public final DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"ptSrc", (Object)ptSrc);
        ArgumentChecks.ensureDimensionMatches((String)"ptSrc", (int)1, (DirectPosition)ptSrc);
        if (ptDst == null) {
            ptDst = new GeneralDirectPosition(1);
        } else {
            ArgumentChecks.ensureDimensionMatches((String)"ptDst", (int)1, (DirectPosition)ptDst);
        }
        ptDst.setOrdinate(0, this.transform(ptSrc.getOrdinate(0)));
        return ptDst;
    }

    public final Matrix derivative(DirectPosition point) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"point", (Object)point);
        ArgumentChecks.ensureDimensionMatches((String)"point", (int)1, (DirectPosition)point);
        return new Matrix1(this.derivative(point.getOrdinate(0)));
    }

    public boolean isIdentity() {
        return this.converse == this;
    }

    public final MathTransform1D inverse() {
        return this.converse;
    }

    public final int getSourceDimensions() {
        return 1;
    }

    public final int getTargetDimensions() {
        return 1;
    }

    @Override
    public final int size() {
        return this.categories.length;
    }

    @Override
    public final Category get(int i) {
        return this.categories[i];
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CategoryList) {
            CategoryList that = (CategoryList)object;
            if (Arrays.equals(this.categories, that.categories)) {
                assert (Arrays.equals(this.minimums, that.minimums));
            } else {
                return false;
            }
        }
        return super.equals(object);
    }

    public String toWKT() throws UnsupportedOperationException {
        throw new UnformattableObjectException("Not yet implemented.");
    }
}

