/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di.resolver;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.lang.Nullable;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.di.InstanceFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.spi.FactoryResolver;
import org.apache.logging.log4j.plugins.di.spi.ResolvableKey;
import org.apache.logging.log4j.plugins.model.PluginType;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Cast;

public class PluginElementFactoryResolver<T>
implements FactoryResolver<T> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Class<? extends Annotation> annotationType;

    public PluginElementFactoryResolver() {
        this(PluginElement.class);
    }

    protected PluginElementFactoryResolver(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public boolean supportsKey(Key<?> key) {
        return key.getQualifierType() == this.annotationType;
    }

    @Override
    public Supplier<T> getFactory(ResolvableKey<T> resolvableKey, InstanceFactory instanceFactory) {
        Key key = resolvableKey.key();
        Collection<String> aliases = resolvableKey.aliases();
        return () -> {
            Node node = instanceFactory.getInstance(Node.CURRENT_NODE);
            LOGGER.trace("Configuring node {} element {}", (Object)node.getName(), (Object)key);
            String name = key.getName();
            Class rawType = key.getRawType();
            Class<?> componentType = rawType.getComponentType();
            return componentType != null ? PluginElementFactoryResolver.findChildElements(node, name, aliases, componentType) : PluginElementFactoryResolver.findChildElement(node, name, aliases, rawType);
        };
    }

    private static <T> T findChildElements(Node node, String name, Collection<String> aliases, Class<?> componentType) {
        Iterator<Node> iterator = node.getChildren().iterator();
        ArrayList values = new ArrayList();
        while (iterator.hasNext()) {
            Node child = iterator.next();
            if (!PluginElementFactoryResolver.nodeElementMatchesNameOrType(child, name, aliases, componentType)) continue;
            Object value = child.getObject();
            if (value == null) {
                LOGGER.error("Skipping null child object with name {} in element {}", (Object)child.getName(), (Object)node.getName());
                continue;
            }
            iterator.remove();
            if (value.getClass().isArray()) {
                return (T)Cast.cast(value);
            }
            values.add(value);
        }
        int size = values.size();
        Object array = Array.newInstance(componentType, size);
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, values.get(i));
        }
        return (T)Cast.cast((Object)array);
    }

    private static <T> @Nullable T findChildElement(Node node, String name, Collection<String> aliases, Class<?> targetType) {
        List<Node> children = node.getChildren();
        Iterator<Node> iterator = children.iterator();
        while (iterator.hasNext()) {
            Node child = iterator.next();
            if (!PluginElementFactoryResolver.nodeElementMatchesNameOrType(child, name, aliases, targetType)) continue;
            iterator.remove();
            return child.getObject();
        }
        return null;
    }

    private static boolean nodeElementMatchesNameOrType(Node node, String name, Collection<String> aliases, Class<?> targetType) {
        return Optional.ofNullable(node.getType()).filter(pluginType -> PluginElementFactoryResolver.pluginTypeMatchesNameOrType(pluginType, name, aliases, targetType)).isPresent();
    }

    private static boolean pluginTypeMatchesNameOrType(PluginType<?> pluginType, String name, Collection<String> aliases, Class<?> targetType) {
        return PluginElementFactoryResolver.elementNameMatches(pluginType, name, aliases) || targetType.isAssignableFrom(pluginType.getPluginClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean elementNameMatches(PluginType<?> pluginType, String name, Collection<String> aliases) {
        String elementName = pluginType.getElementName();
        if (elementName.equalsIgnoreCase(name)) return true;
        if (!aliases.stream().anyMatch(elementName::equalsIgnoreCase)) return false;
        return true;
    }
}

