/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.user.TileDao;

public class TileProperties {
    private static final Logger LOGGER = Logger.getLogger(TileProperties.class.getName());
    public static final String GEOPACKAGE_PROPERTIES_FILE = "tiles.properties";
    public static final String GEOPACKAGE_PROPERTIES_EPSG = "epsg";
    public static final String GEOPACKAGE_PROPERTIES_MIN_X = "min_x";
    public static final String GEOPACKAGE_PROPERTIES_MAX_X = "max_x";
    public static final String GEOPACKAGE_PROPERTIES_MIN_Y = "min_y";
    public static final String GEOPACKAGE_PROPERTIES_MAX_Y = "max_y";
    public static final String GEOPACKAGE_PROPERTIES_ZOOM_LEVEL = "zoom_level";
    public static final String GEOPACKAGE_PROPERTIES_MATRIX_WIDTH = "matrix_width";
    public static final String GEOPACKAGE_PROPERTIES_MATRIX_HEIGHT = "matrix_height";
    private File propertiesFile;
    private Properties properties;

    public TileProperties(File directory) {
        this.propertiesFile = new File(directory, GEOPACKAGE_PROPERTIES_FILE);
    }

    public void load() {
        this.properties = new Properties();
        try {
            FileInputStream in = new FileInputStream(this.propertiesFile);
            try {
                this.properties.load(in);
            }
            catch (Exception e) {
                throw new GeoPackageException("Failed to load properties file for GeoPackage file format located at: " + this.propertiesFile, (Throwable)e);
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to close properties file: " + this.propertiesFile, e);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new GeoPackageException("GeoPackage file format requires a properties file located at: " + this.propertiesFile, (Throwable)e);
        }
    }

    public Integer getIntegerProperty(String property, boolean required) {
        Integer integerValue = null;
        String value = this.getProperty(property, required);
        if (value != null) {
            try {
                integerValue = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new GeoPackageException("tiles.properties property file property '" + property + "' must be an integer");
            }
        }
        return integerValue;
    }

    public Double getDoubleProperty(String property, boolean required) {
        Double doubleValue = null;
        String value = this.getProperty(property, required);
        if (value != null) {
            try {
                doubleValue = Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new GeoPackageException("tiles.properties property file property '" + property + "' must be a double");
            }
        }
        return doubleValue;
    }

    public String getProperty(String property, boolean required) {
        if (this.properties == null) {
            throw new GeoPackageException("Properties must be loaded before reading");
        }
        String value = this.properties.getProperty(property);
        if (value == null && required) {
            throw new GeoPackageException("tiles.properties property file missing required property: " + property);
        }
        return value;
    }

    public void writeFile(TileDao tileDao) {
        try {
            PrintWriter pw = new PrintWriter(this.propertiesFile);
            TileMatrixSet tileMatrixSet = tileDao.getTileMatrixSet();
            pw.println("epsg=" + tileMatrixSet.getSrs().getOrganizationCoordsysId());
            pw.println("min_x=" + tileMatrixSet.getMinX());
            pw.println("max_x=" + tileMatrixSet.getMaxX());
            pw.println("min_y=" + tileMatrixSet.getMinY());
            pw.println("max_y=" + tileMatrixSet.getMaxY());
            for (TileMatrix tileMatrix : tileDao.getTileMatrices()) {
                long zoom = tileMatrix.getZoomLevel();
                pw.println(TileProperties.getMatrixWidthProperty(zoom) + "=" + tileMatrix.getMatrixWidth());
                pw.println(TileProperties.getMatrixHeightProperty(zoom) + "=" + tileMatrix.getMatrixHeight());
            }
            pw.close();
        }
        catch (FileNotFoundException e) {
            throw new GeoPackageException("GeoPackage file format properties file could not be created: " + this.propertiesFile, (Throwable)e);
        }
    }

    public static String getMatrixWidthProperty(long zoom) {
        return TileProperties.getMatrixWidthProperty(String.valueOf(zoom));
    }

    public static String getMatrixWidthProperty(String zoom) {
        return "zoom_level." + zoom + ".matrix_width";
    }

    public static String getMatrixHeightProperty(long zoom) {
        return TileProperties.getMatrixHeightProperty(String.valueOf(zoom));
    }

    public static String getMatrixHeightProperty(String zoom) {
        return "zoom_level." + zoom + ".matrix_height";
    }
}

