/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.nga.index.FeatureTableIndex;
import mil.nga.geopackage.extension.rtree.RTreeIndexExtension;
import mil.nga.geopackage.extension.rtree.RTreeIndexTableDao;
import mil.nga.geopackage.features.index.FeatureIndexFeatureResults;
import mil.nga.geopackage.features.index.FeatureIndexLocation;
import mil.nga.geopackage.features.index.FeatureIndexResults;
import mil.nga.geopackage.features.index.FeatureIndexType;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeaturePaginatedResults;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.ManualFeatureQuery;
import mil.nga.geopackage.io.GeoPackageProgress;
import mil.nga.proj.Projection;
import mil.nga.sf.GeometryEnvelope;

public class FeatureIndexManager {
    private static final Logger LOGGER = Logger.getLogger(FeatureIndexManager.class.getName());
    private final FeatureDao featureDao;
    private final FeatureTableIndex featureTableIndex;
    private final RTreeIndexTableDao rTreeIndexTableDao;
    private final ManualFeatureQuery manualFeatureQuery;
    private Set<FeatureIndexType> indexLocationQueryOrder = new LinkedHashSet<FeatureIndexType>();
    private FeatureIndexType indexLocation;
    private boolean continueOnError = true;
    private boolean geodesic = false;

    public FeatureIndexManager(GeoPackage geoPackage, String featureTable) {
        this(geoPackage, geoPackage.getFeatureDao(featureTable));
    }

    public FeatureIndexManager(GeoPackage geoPackage, FeatureDao featureDao) {
        this(geoPackage, featureDao, false);
    }

    public FeatureIndexManager(GeoPackage geoPackage, String featureTable, boolean geodesic) {
        this(geoPackage, geoPackage.getFeatureDao(featureTable), geodesic);
    }

    public FeatureIndexManager(GeoPackage geoPackage, FeatureDao featureDao, boolean geodesic) {
        this.featureDao = featureDao;
        this.geodesic = geodesic;
        this.featureTableIndex = new FeatureTableIndex(geoPackage, featureDao, geodesic);
        RTreeIndexExtension rTreeExtension = new RTreeIndexExtension(geoPackage, geodesic);
        this.rTreeIndexTableDao = rTreeExtension.getTableDao(featureDao);
        this.manualFeatureQuery = new ManualFeatureQuery(featureDao, geodesic);
        this.indexLocationQueryOrder.add(FeatureIndexType.RTREE);
        this.indexLocationQueryOrder.add(FeatureIndexType.GEOPACKAGE);
    }

    public void close() {
        this.featureTableIndex.close();
    }

    public FeatureDao getFeatureDao() {
        return this.featureDao;
    }

    public FeatureTableIndex getFeatureTableIndex() {
        return this.featureTableIndex;
    }

    public RTreeIndexTableDao getRTreeIndexTableDao() {
        return this.rTreeIndexTableDao;
    }

    public Set<FeatureIndexType> getIndexLocationQueryOrder() {
        return Collections.unmodifiableSet(this.indexLocationQueryOrder);
    }

    public FeatureIndexType getIndexLocation() {
        return this.indexLocation;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public boolean isGeodesic() {
        return this.geodesic;
    }

    public void setGeodesic(boolean geodesic) {
        this.geodesic = geodesic;
        this.featureTableIndex.setGeodesic(geodesic);
        this.rTreeIndexTableDao.getRTreeIndexExtension().setGeodesic(geodesic);
        this.manualFeatureQuery.setGeodesic(geodesic);
    }

    public void prioritizeQueryLocation(Collection<FeatureIndexType> types) {
        this.prioritizeQueryLocation(types.toArray(new FeatureIndexType[types.size()]));
    }

    public void prioritizeQueryLocation(FeatureIndexType ... types) {
        LinkedHashSet<FeatureIndexType> queryOrder = new LinkedHashSet<FeatureIndexType>();
        for (FeatureIndexType type : types) {
            if (type == FeatureIndexType.NONE) continue;
            queryOrder.add(type);
        }
        queryOrder.addAll(this.indexLocationQueryOrder);
        this.indexLocationQueryOrder = queryOrder;
    }

    public void setIndexLocationOrder(Collection<FeatureIndexType> types) {
        this.setIndexLocationOrder(types.toArray(new FeatureIndexType[types.size()]));
    }

    public void setIndexLocationOrder(FeatureIndexType ... types) {
        LinkedHashSet<FeatureIndexType> queryOrder = new LinkedHashSet<FeatureIndexType>();
        for (FeatureIndexType type : types) {
            if (type == FeatureIndexType.NONE) continue;
            queryOrder.add(type);
        }
        this.indexLocationQueryOrder = queryOrder;
    }

    public void setIndexLocation(FeatureIndexType indexLocation) {
        this.indexLocation = indexLocation;
    }

    public void setProgress(GeoPackageProgress progress) {
        this.featureTableIndex.setProgress(progress);
        this.rTreeIndexTableDao.setProgress(progress);
    }

    public int index() {
        return this.index(this.verifyIndexLocation(), false);
    }

    public int index(List<FeatureIndexType> types) {
        int count = 0;
        for (FeatureIndexType type : types) {
            int typeCount = this.index(type);
            count = Math.max(count, typeCount);
        }
        return count;
    }

    public int index(FeatureIndexType type) {
        return this.index(type, false);
    }

    public int index(boolean force) {
        return this.index(this.verifyIndexLocation(), force);
    }

    public int index(boolean force, List<FeatureIndexType> types) {
        int count = 0;
        for (FeatureIndexType type : types) {
            int typeCount = this.index(type, force);
            count = Math.max(count, typeCount);
        }
        return count;
    }

    public int index(FeatureIndexType type, boolean force) {
        if (type == null) {
            throw new GeoPackageException("FeatureIndexType is required to index");
        }
        int count = 0;
        switch (type) {
            case GEOPACKAGE: {
                count = this.featureTableIndex.index(force);
                break;
            }
            case RTREE: {
                boolean rTreeIndexed = this.rTreeIndexTableDao.has();
                if (rTreeIndexed && !force) break;
                if (rTreeIndexed) {
                    this.rTreeIndexTableDao.delete();
                }
                this.rTreeIndexTableDao.create();
                count = this.rTreeIndexTableDao.count();
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported FeatureIndexType: " + type);
            }
        }
        return count;
    }

    public boolean index(FeatureRow row) {
        return this.index(this.verifyIndexLocation(), row);
    }

    public boolean index(FeatureRow row, List<FeatureIndexType> types) {
        boolean indexed = false;
        for (FeatureIndexType type : types) {
            if (!this.index(type, row)) continue;
            indexed = true;
        }
        return indexed;
    }

    public boolean index(FeatureIndexType type, FeatureRow row) {
        boolean indexed = false;
        if (type == null) {
            throw new GeoPackageException("FeatureIndexType is required to index");
        }
        switch (type) {
            case GEOPACKAGE: {
                indexed = this.featureTableIndex.index(row);
                break;
            }
            case RTREE: {
                indexed = true;
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported FeatureIndexType: " + type);
            }
        }
        return indexed;
    }

    public boolean deleteIndex() {
        return this.deleteIndex(this.verifyIndexLocation());
    }

    public boolean deleteAllIndexes() {
        return this.deleteIndex(this.indexLocationQueryOrder);
    }

    public boolean deleteIndex(Collection<FeatureIndexType> types) {
        boolean deleted = false;
        for (FeatureIndexType type : types) {
            if (!this.deleteIndex(type)) continue;
            deleted = true;
        }
        return deleted;
    }

    public boolean deleteIndex(FeatureIndexType type) {
        if (type == null) {
            throw new GeoPackageException("FeatureIndexType is required to delete index");
        }
        boolean deleted = false;
        switch (type) {
            case GEOPACKAGE: {
                deleted = this.featureTableIndex.deleteIndex();
                break;
            }
            case RTREE: {
                this.rTreeIndexTableDao.delete();
                deleted = true;
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported FeatureIndexType: " + type);
            }
        }
        return deleted;
    }

    public boolean deleteIndex(FeatureRow row) {
        return this.deleteIndex(this.verifyIndexLocation(), row);
    }

    public boolean deleteIndex(FeatureRow row, List<FeatureIndexType> types) {
        boolean deleted = false;
        for (FeatureIndexType type : types) {
            if (!this.deleteIndex(type, row)) continue;
            deleted = true;
        }
        return deleted;
    }

    public boolean deleteIndex(FeatureIndexType type, FeatureRow row) {
        return this.deleteIndex(type, row.getId());
    }

    public boolean deleteIndex(long geomId) {
        return this.deleteIndex(this.verifyIndexLocation(), geomId);
    }

    public boolean deleteIndex(long geomId, List<FeatureIndexType> types) {
        boolean deleted = false;
        for (FeatureIndexType type : types) {
            if (!this.deleteIndex(type, geomId)) continue;
            deleted = true;
        }
        return deleted;
    }

    public boolean deleteIndex(FeatureIndexType type, long geomId) {
        if (type == null) {
            throw new GeoPackageException("FeatureIndexType is required to delete index");
        }
        boolean deleted = false;
        switch (type) {
            case GEOPACKAGE: {
                deleted = this.featureTableIndex.deleteIndex(geomId) > 0;
                break;
            }
            case RTREE: {
                deleted = true;
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported FeatureIndexType: " + type);
            }
        }
        return deleted;
    }

    public boolean retainIndex(FeatureIndexType type) {
        ArrayList<FeatureIndexType> retain = new ArrayList<FeatureIndexType>();
        retain.add(type);
        return this.retainIndex(retain);
    }

    public boolean retainIndex(Collection<FeatureIndexType> types) {
        HashSet<FeatureIndexType> delete = new HashSet<FeatureIndexType>(this.indexLocationQueryOrder);
        delete.removeAll(types);
        return this.deleteIndex(delete);
    }

    public boolean isIndexed() {
        FeatureIndexType type;
        boolean indexed = false;
        Iterator<FeatureIndexType> iterator = this.indexLocationQueryOrder.iterator();
        while (iterator.hasNext() && !(indexed = this.isIndexed(type = iterator.next()))) {
        }
        return indexed;
    }

    public boolean isIndexed(FeatureIndexType type) {
        boolean indexed = false;
        if (type == null) {
            indexed = this.isIndexed();
        } else {
            switch (type) {
                case GEOPACKAGE: {
                    indexed = this.featureTableIndex.isIndexed();
                    break;
                }
                case RTREE: {
                    indexed = this.rTreeIndexTableDao.has();
                    break;
                }
                default: {
                    throw new GeoPackageException("Unsupported FeatureIndexType: " + type);
                }
            }
        }
        return indexed;
    }

    public List<FeatureIndexType> getIndexedTypes() {
        ArrayList<FeatureIndexType> indexed = new ArrayList<FeatureIndexType>();
        for (FeatureIndexType type : this.indexLocationQueryOrder) {
            if (!this.isIndexed(type)) continue;
            indexed.add(type);
        }
        return indexed;
    }

    public Date getLastIndexed() {
        FeatureIndexType type;
        Date lastIndexed = null;
        Iterator<FeatureIndexType> iterator = this.indexLocationQueryOrder.iterator();
        while (iterator.hasNext() && (lastIndexed = this.getLastIndexed(type = iterator.next())) == null) {
        }
        return lastIndexed;
    }

    public Date getLastIndexed(FeatureIndexType type) {
        Date lastIndexed = null;
        if (type == null) {
            lastIndexed = this.getLastIndexed();
        } else {
            switch (type) {
                case GEOPACKAGE: {
                    lastIndexed = this.featureTableIndex.getLastIndexed();
                    break;
                }
                case RTREE: {
                    if (!this.rTreeIndexTableDao.has()) break;
                    lastIndexed = new Date();
                    break;
                }
                default: {
                    throw new GeoPackageException("Unsupported FeatureIndexType: " + type);
                }
            }
        }
        return lastIndexed;
    }

    public FeatureIndexLocation getLocation() {
        return new FeatureIndexLocation(this);
    }

    public FeatureIndexType getIndexedType() {
        FeatureIndexType indexType = FeatureIndexType.NONE;
        for (FeatureIndexType type : this.indexLocationQueryOrder) {
            if (!this.isIndexed(type)) continue;
            indexType = type;
            break;
        }
        return indexType;
    }

    public String getIdColumn() {
        return this.featureDao.getPkColumnName();
    }

    public FeatureIndexResults query() {
        return this.query(false);
    }

    public FeatureIndexResults query(boolean distinct) {
        return this.query(distinct, this.featureDao.getColumnNames());
    }

    public FeatureIndexResults query(String[] columns) {
        return this.query(false, columns);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns) {
        FeatureIndexFeatureResults results = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        FeatureResultSet geoPackageResultSet = this.featureTableIndex.queryFeatures(distinct, columns);
                        results = new FeatureIndexFeatureResults(geoPackageResultSet);
                        break;
                    }
                    case RTREE: {
                        FeatureResultSet rTreeResultSet = this.rTreeIndexTableDao.queryFeatures(distinct, columns);
                        results = new FeatureIndexFeatureResults(rTreeResultSet);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to query from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (results == null) {
            FeatureResultSet featureResultSet = this.manualFeatureQuery.query(distinct, columns);
            results = new FeatureIndexFeatureResults(featureResultSet);
        }
        return results;
    }

    public long count() {
        Long count = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        count = this.featureTableIndex.count();
                        break;
                    }
                    case RTREE: {
                        count = this.rTreeIndexTableDao.count();
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to count from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (count == null) {
            count = this.manualFeatureQuery.countWithGeometries();
        }
        return count;
    }

    public long countColumn(String column) {
        return this.count(false, column);
    }

    public long count(boolean distinct, String column) {
        Long count = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        count = this.featureTableIndex.countFeatures(distinct, column);
                        break;
                    }
                    case RTREE: {
                        count = this.rTreeIndexTableDao.countFeatures(distinct, column);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to count from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (count == null) {
            count = this.manualFeatureQuery.count(distinct, column);
        }
        return count;
    }

    public FeatureIndexResults query(Map<String, Object> fieldValues) {
        return this.query(false, fieldValues);
    }

    public FeatureIndexResults query(boolean distinct, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.query(distinct, where, whereArgs);
    }

    public FeatureIndexResults query(String[] columns, Map<String, Object> fieldValues) {
        return this.query(false, columns, fieldValues);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.query(distinct, columns, where, whereArgs);
    }

    public long count(Map<String, Object> fieldValues) {
        return this.count(false, null, fieldValues);
    }

    public long count(String column, Map<String, Object> fieldValues) {
        return this.count(false, column, fieldValues);
    }

    public long count(boolean distinct, String column, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.count(distinct, column, where, whereArgs);
    }

    public FeatureIndexResults query(String where) {
        return this.query(false, where);
    }

    public FeatureIndexResults query(boolean distinct, String where) {
        return this.query(distinct, where, null);
    }

    public FeatureIndexResults query(String[] columns, String where) {
        return this.query(false, columns, where);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, String where) {
        return this.query(distinct, columns, where, null);
    }

    public long count(String where) {
        return this.count(false, null, where);
    }

    public long count(String column, String where) {
        return this.count(false, column, where);
    }

    public long count(boolean distinct, String column, String where) {
        return this.count(distinct, column, where, null);
    }

    public FeatureIndexResults query(String where, String[] whereArgs) {
        return this.query(false, where, whereArgs);
    }

    public FeatureIndexResults query(boolean distinct, String where, String[] whereArgs) {
        return this.query(distinct, this.featureDao.getColumnNames(), where, whereArgs);
    }

    public FeatureIndexResults query(String[] columns, String where, String[] whereArgs) {
        return this.query(false, columns, where, whereArgs);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, String where, String[] whereArgs) {
        FeatureIndexFeatureResults results = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        FeatureResultSet geoPackageResultSet = this.featureTableIndex.queryFeatures(distinct, columns, where, whereArgs);
                        results = new FeatureIndexFeatureResults(geoPackageResultSet);
                        break;
                    }
                    case RTREE: {
                        FeatureResultSet rTreeResultSet = this.rTreeIndexTableDao.queryFeatures(distinct, columns, where, whereArgs);
                        results = new FeatureIndexFeatureResults(rTreeResultSet);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to query from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (results == null) {
            FeatureResultSet featureResultSet = this.manualFeatureQuery.query(distinct, columns, where, whereArgs);
            results = new FeatureIndexFeatureResults(featureResultSet);
        }
        return results;
    }

    public long count(String where, String[] whereArgs) {
        return this.count(false, null, where, whereArgs);
    }

    public long count(String column, String where, String[] whereArgs) {
        return this.count(false, column, where, whereArgs);
    }

    public long count(boolean distinct, String column, String where, String[] whereArgs) {
        Long count = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        count = this.featureTableIndex.countFeatures(distinct, column, where, whereArgs);
                        break;
                    }
                    case RTREE: {
                        count = this.rTreeIndexTableDao.countFeatures(distinct, column, where, whereArgs);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to count from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (count == null) {
            count = this.manualFeatureQuery.count(distinct, column, where, whereArgs);
        }
        return count;
    }

    public BoundingBox getBoundingBox() {
        BoundingBox bounds = null;
        boolean success = false;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        bounds = this.featureTableIndex.getBoundingBox();
                        break;
                    }
                    case RTREE: {
                        bounds = this.rTreeIndexTableDao.getBoundingBox();
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                success = true;
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to get bounding box from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (!success) {
            bounds = this.manualFeatureQuery.getBoundingBox();
        }
        return bounds;
    }

    public BoundingBox getBoundingBox(Projection projection) {
        BoundingBox bounds = null;
        boolean success = false;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        bounds = this.featureTableIndex.getBoundingBox(projection);
                        break;
                    }
                    case RTREE: {
                        bounds = this.rTreeIndexTableDao.getBoundingBox(projection);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                success = true;
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to get bounding box from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (!success) {
            bounds = this.manualFeatureQuery.getBoundingBox(projection);
        }
        return bounds;
    }

    public FeatureIndexResults query(BoundingBox boundingBox) {
        return this.query(false, boundingBox);
    }

    public FeatureIndexResults query(boolean distinct, BoundingBox boundingBox) {
        return this.query(distinct, boundingBox.buildEnvelope());
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox) {
        return this.query(false, columns, boundingBox);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, BoundingBox boundingBox) {
        return this.query(distinct, columns, boundingBox.buildEnvelope());
    }

    public long count(BoundingBox boundingBox) {
        return this.count(false, null, boundingBox);
    }

    public long count(String column, BoundingBox boundingBox) {
        return this.count(false, column, boundingBox);
    }

    public long count(boolean distinct, String column, BoundingBox boundingBox) {
        return this.count(distinct, column, boundingBox.buildEnvelope());
    }

    public FeatureIndexResults query(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.query(false, boundingBox, fieldValues);
    }

    public FeatureIndexResults query(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.query(distinct, boundingBox.buildEnvelope(), fieldValues);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.query(false, columns, boundingBox, fieldValues);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.query(distinct, columns, boundingBox.buildEnvelope(), fieldValues);
    }

    public long count(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.count(false, null, boundingBox, fieldValues);
    }

    public long count(String column, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.count(false, column, boundingBox, fieldValues);
    }

    public long count(boolean distinct, String column, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.count(distinct, column, boundingBox.buildEnvelope(), fieldValues);
    }

    public FeatureIndexResults query(BoundingBox boundingBox, String where) {
        return this.query(false, boundingBox, where);
    }

    public FeatureIndexResults query(boolean distinct, BoundingBox boundingBox, String where) {
        return this.query(distinct, boundingBox, where, null);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, String where) {
        return this.query(false, columns, boundingBox, where);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, BoundingBox boundingBox, String where) {
        return this.query(distinct, columns, boundingBox, where, null);
    }

    public long count(BoundingBox boundingBox, String where) {
        return this.count(false, null, boundingBox, where);
    }

    public long count(String column, BoundingBox boundingBox, String where) {
        return this.count(false, column, boundingBox, where);
    }

    public long count(boolean distinct, String column, BoundingBox boundingBox, String where) {
        return this.count(distinct, column, boundingBox, where, null);
    }

    public FeatureIndexResults query(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.query(false, boundingBox, where, whereArgs);
    }

    public FeatureIndexResults query(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.query(distinct, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.query(false, columns, boundingBox, where, whereArgs);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.query(distinct, columns, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public long count(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.count(false, null, boundingBox, where, whereArgs);
    }

    public long count(String column, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.count(false, column, boundingBox, where, whereArgs);
    }

    public long count(boolean distinct, String column, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.count(distinct, column, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public FeatureIndexResults query(GeometryEnvelope envelope) {
        return this.query(false, envelope);
    }

    public FeatureIndexResults query(boolean distinct, GeometryEnvelope envelope) {
        return this.query(distinct, envelope, null, null);
    }

    public FeatureIndexResults query(String[] columns, GeometryEnvelope envelope) {
        return this.query(false, columns, envelope);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, GeometryEnvelope envelope) {
        return this.query(distinct, columns, envelope, null, null);
    }

    public long count(GeometryEnvelope envelope) {
        return this.count(false, null, envelope);
    }

    public long count(String column, GeometryEnvelope envelope) {
        return this.count(false, column, envelope);
    }

    public long count(boolean distinct, String column, GeometryEnvelope envelope) {
        Long count = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        if (column != null) {
                            count = this.featureTableIndex.countFeatures(distinct, column, envelope);
                            break;
                        }
                        count = this.featureTableIndex.count(envelope);
                        break;
                    }
                    case RTREE: {
                        if (column != null) {
                            count = this.rTreeIndexTableDao.count(distinct, column, envelope);
                            break;
                        }
                        count = this.rTreeIndexTableDao.count(envelope);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to count from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (count == null) {
            if (column != null) {
                throw new GeoPackageException("Count by column and envelope is unsupported as a manual feature query. column: " + column);
            }
            count = this.manualFeatureQuery.count(envelope);
        }
        return count;
    }

    public FeatureIndexResults query(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.query(false, envelope, fieldValues);
    }

    public FeatureIndexResults query(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.query(distinct, envelope, where, whereArgs);
    }

    public FeatureIndexResults query(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.query(false, columns, envelope, fieldValues);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.query(distinct, columns, envelope, where, whereArgs);
    }

    public long count(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.count(false, null, envelope, fieldValues);
    }

    public long count(String column, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.count(false, column, envelope, fieldValues);
    }

    public long count(boolean distinct, String column, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.count(distinct, column, envelope, where, whereArgs);
    }

    public FeatureIndexResults query(GeometryEnvelope envelope, String where) {
        return this.query(false, envelope, where);
    }

    public FeatureIndexResults query(boolean distinct, GeometryEnvelope envelope, String where) {
        return this.query(distinct, envelope, where, null);
    }

    public FeatureIndexResults query(String[] columns, GeometryEnvelope envelope, String where) {
        return this.query(false, columns, envelope, where);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, GeometryEnvelope envelope, String where) {
        return this.query(distinct, columns, envelope, where, null);
    }

    public long count(GeometryEnvelope envelope, String where) {
        return this.count(false, null, envelope, where);
    }

    public long count(String column, GeometryEnvelope envelope, String where) {
        return this.count(false, column, envelope, where);
    }

    public long count(boolean distinct, String column, GeometryEnvelope envelope, String where) {
        return this.count(distinct, column, envelope, where, null);
    }

    public FeatureIndexResults query(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.query(false, envelope, where, whereArgs);
    }

    public FeatureIndexResults query(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.query(distinct, this.featureDao.getColumnNames(), envelope, where, whereArgs);
    }

    public FeatureIndexResults query(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.query(false, columns, envelope, where, whereArgs);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs) {
        FeatureIndexResults results = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        FeatureResultSet geoPackageResultSet = this.featureTableIndex.queryFeatures(distinct, columns, envelope, where, whereArgs);
                        results = new FeatureIndexFeatureResults(geoPackageResultSet);
                        break;
                    }
                    case RTREE: {
                        FeatureResultSet rTreeResultSet = this.rTreeIndexTableDao.queryFeatures(distinct, columns, envelope, where, whereArgs);
                        results = new FeatureIndexFeatureResults(rTreeResultSet);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to query from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (results == null) {
            results = this.manualFeatureQuery.query(distinct, columns, envelope, where, whereArgs);
        }
        return results;
    }

    public long count(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.count(false, null, envelope, where, whereArgs);
    }

    public long count(String column, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.count(false, column, envelope, where, whereArgs);
    }

    public long count(boolean distinct, String column, GeometryEnvelope envelope, String where, String[] whereArgs) {
        Long count = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        count = this.featureTableIndex.countFeatures(distinct, column, envelope, where, whereArgs);
                        break;
                    }
                    case RTREE: {
                        count = this.rTreeIndexTableDao.countFeatures(distinct, column, envelope, where, whereArgs);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to count from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (count == null) {
            if (column != null) {
                throw new GeoPackageException("Count by column and envelope is unsupported as a manual feature query. column: " + column);
            }
            count = this.manualFeatureQuery.count(envelope, where, whereArgs);
        }
        return count;
    }

    public FeatureIndexResults query(BoundingBox boundingBox, Projection projection) {
        return this.query(false, boundingBox, projection);
    }

    public FeatureIndexResults query(boolean distinct, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, featureBoundingBox);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, Projection projection) {
        return this.query(false, columns, boundingBox, projection);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, columns, featureBoundingBox);
    }

    public long count(BoundingBox boundingBox, Projection projection) {
        return this.count(false, null, boundingBox, projection);
    }

    public long count(String column, BoundingBox boundingBox, Projection projection) {
        return this.count(false, column, boundingBox, projection);
    }

    public long count(boolean distinct, String column, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.count(distinct, column, featureBoundingBox);
    }

    public FeatureIndexResults query(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.query(false, boundingBox, projection, fieldValues);
    }

    public FeatureIndexResults query(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, featureBoundingBox, fieldValues);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.query(false, columns, boundingBox, projection, fieldValues);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, columns, featureBoundingBox, fieldValues);
    }

    public long count(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.count(false, null, boundingBox, projection, fieldValues);
    }

    public long count(String column, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.count(false, column, boundingBox, projection, fieldValues);
    }

    public long count(boolean distinct, String column, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.count(distinct, column, featureBoundingBox, fieldValues);
    }

    public FeatureIndexResults query(BoundingBox boundingBox, Projection projection, String where) {
        return this.query(false, boundingBox, projection, where);
    }

    public FeatureIndexResults query(boolean distinct, BoundingBox boundingBox, Projection projection, String where) {
        return this.query(distinct, boundingBox, projection, where, null);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, Projection projection, String where) {
        return this.query(false, columns, boundingBox, projection, where);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where) {
        return this.query(distinct, columns, boundingBox, projection, where, null);
    }

    public long count(BoundingBox boundingBox, Projection projection, String where) {
        return this.count(false, null, boundingBox, projection, where);
    }

    public long count(String column, BoundingBox boundingBox, Projection projection, String where) {
        return this.count(false, column, boundingBox, projection, where);
    }

    public long count(boolean distinct, String column, BoundingBox boundingBox, Projection projection, String where) {
        return this.count(distinct, column, boundingBox, projection, where, null);
    }

    public FeatureIndexResults query(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.query(false, boundingBox, projection, where, whereArgs);
    }

    public FeatureIndexResults query(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, featureBoundingBox, where, whereArgs);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.query(false, columns, boundingBox, projection, where, whereArgs);
    }

    public FeatureIndexResults query(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, columns, featureBoundingBox, where, whereArgs);
    }

    public long count(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.count(false, null, boundingBox, projection, where, whereArgs);
    }

    public long count(String column, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.count(false, column, boundingBox, projection, where, whereArgs);
    }

    public long count(boolean distinct, String column, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.count(distinct, column, featureBoundingBox, where, whereArgs);
    }

    public static boolean isPaginated(FeatureIndexResults results) {
        boolean paginated = false;
        if (results instanceof FeatureIndexFeatureResults) {
            paginated = FeatureIndexManager.isPaginated((FeatureIndexFeatureResults)results);
        }
        return paginated;
    }

    public static boolean isPaginated(FeatureIndexFeatureResults results) {
        return FeaturePaginatedResults.isPaginated(results.getResultSet());
    }

    public FeaturePaginatedResults paginate(FeatureIndexResults results) {
        return FeatureIndexManager.paginate(this.getFeatureDao(), results);
    }

    public static FeaturePaginatedResults paginate(FeatureDao featureDao, FeatureIndexResults results) {
        if (!(results instanceof FeatureIndexFeatureResults)) {
            throw new GeoPackageException("Results do not contain a feature result set. Expected: " + FeatureIndexFeatureResults.class.getSimpleName() + ", Received: " + results.getClass().getSimpleName());
        }
        return FeaturePaginatedResults.create(featureDao, ((FeatureIndexFeatureResults)results).getResultSet());
    }

    public FeatureIndexResults queryForChunk(int limit) {
        return this.queryForChunk(this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(int limit, long offset) {
        return this.queryForChunk(this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String orderBy, int limit) {
        return this.queryForChunk(false, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String orderBy, int limit, long offset) {
        return this.queryForChunk(false, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, int limit) {
        return this.queryForChunk(distinct, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, int limit, long offset) {
        return this.queryForChunk(distinct, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String orderBy, int limit) {
        return this.queryForChunk(distinct, this.featureDao.getColumnNames(), orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, this.featureDao.getColumnNames(), orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, int limit) {
        return this.queryForChunk(columns, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, int limit, long offset) {
        return this.queryForChunk(columns, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, String orderBy, int limit) {
        return this.queryForChunk(false, columns, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, int limit) {
        return this.queryForChunk(distinct, columns, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, int limit, long offset) {
        return this.queryForChunk(distinct, columns, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, orderBy, limit, 0L);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, String orderBy, int limit, long offset) {
        FeatureIndexFeatureResults results = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        FeatureResultSet geoPackageResultSet = this.featureTableIndex.queryFeaturesForChunk(distinct, columns, orderBy, limit, offset);
                        results = new FeatureIndexFeatureResults(geoPackageResultSet);
                        break;
                    }
                    case RTREE: {
                        FeatureResultSet rTreeResultSet = this.rTreeIndexTableDao.queryFeaturesForChunk(distinct, columns, orderBy, limit, offset);
                        results = new FeatureIndexFeatureResults(rTreeResultSet);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to query from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (results == null) {
            FeatureResultSet featureResultSet = this.manualFeatureQuery.queryForChunk(distinct, columns, orderBy, limit, offset);
            results = new FeatureIndexFeatureResults(featureResultSet);
        }
        return results;
    }

    public FeatureIndexResults queryForChunk(Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryForChunk(false, fieldValues, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, fieldValues, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(distinct, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(distinct, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, Map<String, Object> fieldValues, String orderBy, int limit) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.queryForChunk(distinct, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.queryForChunk(distinct, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(columns, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(columns, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryForChunk(false, columns, fieldValues, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, fieldValues, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(distinct, columns, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(distinct, columns, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, String orderBy, int limit) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.queryForChunk(distinct, columns, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.queryForChunk(distinct, columns, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(String where, int limit) {
        return this.queryForChunk(where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(String where, int limit, long offset) {
        return this.queryForChunk(where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String where, String orderBy, int limit) {
        return this.queryForChunk(false, where, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, where, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, String where, int limit) {
        return this.queryForChunk(distinct, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, String where, int limit, long offset) {
        return this.queryForChunk(distinct, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String where, String orderBy, int limit) {
        return this.queryForChunk(distinct, where, null, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, where, null, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(String[] columns, String where, int limit) {
        return this.queryForChunk(columns, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(String[] columns, String where, int limit, long offset) {
        return this.queryForChunk(columns, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, String where, String orderBy, int limit) {
        return this.queryForChunk(false, columns, where, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, where, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, String[] columns, String where, int limit) {
        return this.queryForChunk(distinct, columns, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, String[] columns, String where, int limit, long offset) {
        return this.queryForChunk(distinct, columns, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, String where, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, where, null, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, columns, where, null, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String where, String[] whereArgs, int limit) {
        return this.queryForChunk(where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(false, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(distinct, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(distinct, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(distinct, this.featureDao.getColumnNames(), where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, this.featureDao.getColumnNames(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(columns, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(columns, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(false, columns, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(distinct, columns, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(distinct, columns, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, where, whereArgs, orderBy, limit, 0L);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        FeatureIndexFeatureResults results = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        FeatureResultSet geoPackageResultSet = this.featureTableIndex.queryFeaturesForChunk(distinct, columns, where, whereArgs, orderBy, limit, offset);
                        results = new FeatureIndexFeatureResults(geoPackageResultSet);
                        break;
                    }
                    case RTREE: {
                        FeatureResultSet rTreeResultSet = this.rTreeIndexTableDao.queryFeaturesForChunk(distinct, columns, where, whereArgs, orderBy, limit, offset);
                        results = new FeatureIndexFeatureResults(rTreeResultSet);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to query from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (results == null) {
            FeatureResultSet featureResultSet = this.manualFeatureQuery.queryForChunk(distinct, columns, where, whereArgs, orderBy, limit, offset);
            results = new FeatureIndexFeatureResults(featureResultSet);
        }
        return results;
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, int limit) {
        return this.queryForChunk(boundingBox, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, int limit, long offset) {
        return this.queryForChunk(boundingBox, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryForChunk(false, boundingBox, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, boundingBox, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, int limit) {
        return this.queryForChunk(distinct, boundingBox, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryForChunk(distinct, boundingBox.buildEnvelope(), orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox.buildEnvelope(), orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, int limit) {
        return this.queryForChunk(columns, boundingBox, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, int limit, long offset) {
        return this.queryForChunk(columns, boundingBox, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryForChunk(false, columns, boundingBox, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, boundingBox, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox.buildEnvelope(), orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox.buildEnvelope(), orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(boundingBox, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(boundingBox, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryForChunk(false, boundingBox, fieldValues, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, boundingBox, fieldValues, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(distinct, boundingBox, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryForChunk(distinct, boundingBox.buildEnvelope(), fieldValues, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox.buildEnvelope(), fieldValues, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(columns, boundingBox, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(columns, boundingBox, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryForChunk(false, columns, boundingBox, fieldValues, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, boundingBox, fieldValues, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox.buildEnvelope(), fieldValues, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox.buildEnvelope(), fieldValues, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(BoundingBox boundingBox, String where, int limit) {
        return this.queryForChunk(boundingBox, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(BoundingBox boundingBox, String where, int limit, long offset) {
        return this.queryForChunk(boundingBox, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, String where, String orderBy, int limit) {
        return this.queryForChunk(false, boundingBox, where, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, boundingBox, where, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, BoundingBox boundingBox, String where, int limit) {
        return this.queryForChunk(distinct, boundingBox, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, BoundingBox boundingBox, String where, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, String where, String orderBy, int limit) {
        return this.queryForChunk(distinct, boundingBox, where, null, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox, where, null, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(String[] columns, BoundingBox boundingBox, String where, int limit) {
        return this.queryForChunk(columns, boundingBox, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(String[] columns, BoundingBox boundingBox, String where, int limit, long offset) {
        return this.queryForChunk(columns, boundingBox, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, String where, String orderBy, int limit) {
        return this.queryForChunk(false, columns, boundingBox, where, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, boundingBox, where, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, String[] columns, BoundingBox boundingBox, String where, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, String[] columns, BoundingBox boundingBox, String where, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox, where, null, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox, where, null, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(boundingBox, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(boundingBox, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(false, boundingBox, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, boundingBox, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(distinct, boundingBox, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(distinct, boundingBox.buildEnvelope(), where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox.buildEnvelope(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(columns, boundingBox, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(columns, boundingBox, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(false, columns, boundingBox, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, boundingBox, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox.buildEnvelope(), where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox.buildEnvelope(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, int limit) {
        return this.queryForChunk(envelope, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, int limit, long offset) {
        return this.queryForChunk(envelope, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryForChunk(false, envelope, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, envelope, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, int limit) {
        return this.queryForChunk(distinct, envelope, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, int limit, long offset) {
        return this.queryForChunk(distinct, envelope, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryForChunk(distinct, envelope, null, null, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, envelope, null, null, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, int limit) {
        return this.queryForChunk(columns, envelope, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, int limit, long offset) {
        return this.queryForChunk(columns, envelope, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryForChunk(false, columns, envelope, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, envelope, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, int limit) {
        return this.queryForChunk(distinct, columns, envelope, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, int limit, long offset) {
        return this.queryForChunk(distinct, columns, envelope, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, envelope, null, null, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, columns, envelope, null, null, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(envelope, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(envelope, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryForChunk(false, envelope, fieldValues, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, envelope, fieldValues, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(distinct, envelope, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(distinct, envelope, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.queryForChunk(distinct, envelope, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.queryForChunk(distinct, envelope, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(columns, envelope, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(columns, envelope, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryForChunk(false, columns, envelope, fieldValues, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, envelope, fieldValues, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(distinct, columns, envelope, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(distinct, columns, envelope, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.queryForChunk(distinct, columns, envelope, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.queryForChunk(distinct, columns, envelope, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(GeometryEnvelope envelope, String where, int limit) {
        return this.queryForChunk(envelope, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(GeometryEnvelope envelope, String where, int limit, long offset) {
        return this.queryForChunk(envelope, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, String where, String orderBy, int limit) {
        return this.queryForChunk(false, envelope, where, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, envelope, where, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, GeometryEnvelope envelope, String where, int limit) {
        return this.queryForChunk(distinct, envelope, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, GeometryEnvelope envelope, String where, int limit, long offset) {
        return this.queryForChunk(distinct, envelope, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, String where, String orderBy, int limit) {
        return this.queryForChunk(distinct, envelope, where, null, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, envelope, where, null, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(String[] columns, GeometryEnvelope envelope, String where, int limit) {
        return this.queryForChunk(columns, envelope, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(String[] columns, GeometryEnvelope envelope, String where, int limit, long offset) {
        return this.queryForChunk(columns, envelope, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, String where, String orderBy, int limit) {
        return this.queryForChunk(false, columns, envelope, where, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, envelope, where, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, int limit) {
        return this.queryForChunk(distinct, columns, envelope, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, int limit, long offset) {
        return this.queryForChunk(distinct, columns, envelope, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, envelope, where, null, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, columns, envelope, where, null, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(envelope, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(envelope, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(false, envelope, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, envelope, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(distinct, envelope, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(distinct, envelope, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(distinct, this.featureDao.getColumnNames(), envelope, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, this.featureDao.getColumnNames(), envelope, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(columns, envelope, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(columns, envelope, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(false, columns, envelope, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, envelope, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(distinct, columns, envelope, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(distinct, columns, envelope, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, envelope, where, whereArgs, orderBy, limit, 0L);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        FeatureIndexResults results = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        FeatureResultSet geoPackageResultSet = this.featureTableIndex.queryFeaturesForChunk(distinct, columns, envelope, where, whereArgs, orderBy, limit, offset);
                        results = new FeatureIndexFeatureResults(geoPackageResultSet);
                        break;
                    }
                    case RTREE: {
                        FeatureResultSet rTreeResultSet = this.rTreeIndexTableDao.queryFeaturesForChunk(distinct, columns, envelope, where, whereArgs, orderBy, limit, offset);
                        results = new FeatureIndexFeatureResults(rTreeResultSet);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + type);
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to query from feature index: " + type, e);
                    continue;
                }
                throw e;
            }
        }
        if (results == null) {
            results = this.manualFeatureQuery.queryForChunk(distinct, columns, envelope, where, whereArgs, orderBy, limit, offset);
        }
        return results;
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryForChunk(boundingBox, projection, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryForChunk(boundingBox, projection, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        return this.queryForChunk(false, boundingBox, projection, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, boundingBox, projection, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryForChunk(distinct, boundingBox, projection, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox, projection, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, featureBoundingBox, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, featureBoundingBox, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryForChunk(columns, boundingBox, projection, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryForChunk(columns, boundingBox, projection, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        return this.queryForChunk(false, columns, boundingBox, projection, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, boundingBox, projection, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox, projection, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox, projection, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, columns, featureBoundingBox, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, columns, featureBoundingBox, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(boundingBox, projection, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(boundingBox, projection, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryForChunk(false, boundingBox, projection, fieldValues, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, boundingBox, projection, fieldValues, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(distinct, boundingBox, projection, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox, projection, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, featureBoundingBox, fieldValues, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, featureBoundingBox, fieldValues, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(columns, boundingBox, projection, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(columns, boundingBox, projection, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryForChunk(false, columns, boundingBox, projection, fieldValues, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, boundingBox, projection, fieldValues, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox, projection, fieldValues, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox, projection, fieldValues, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, columns, featureBoundingBox, fieldValues, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, columns, featureBoundingBox, fieldValues, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(BoundingBox boundingBox, Projection projection, String where, int limit) {
        return this.queryForChunk(boundingBox, projection, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(BoundingBox boundingBox, Projection projection, String where, int limit, long offset) {
        return this.queryForChunk(boundingBox, projection, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit) {
        return this.queryForChunk(false, boundingBox, projection, where, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, boundingBox, projection, where, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, BoundingBox boundingBox, Projection projection, String where, int limit) {
        return this.queryForChunk(distinct, boundingBox, projection, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, BoundingBox boundingBox, Projection projection, String where, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox, projection, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit) {
        return this.queryForChunk(distinct, boundingBox, projection, where, null, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox, projection, where, null, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(String[] columns, BoundingBox boundingBox, Projection projection, String where, int limit) {
        return this.queryForChunk(columns, boundingBox, projection, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(String[] columns, BoundingBox boundingBox, Projection projection, String where, int limit, long offset) {
        return this.queryForChunk(columns, boundingBox, projection, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit) {
        return this.queryForChunk(false, columns, boundingBox, projection, where, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, boundingBox, projection, where, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox, projection, where, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunkIdOrder(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox, projection, where, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox, projection, where, null, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox, projection, where, null, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(boundingBox, projection, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(boundingBox, projection, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(false, boundingBox, projection, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, boundingBox, projection, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(distinct, boundingBox, projection, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox, projection, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, featureBoundingBox, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, featureBoundingBox, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(columns, boundingBox, projection, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(columns, boundingBox, projection, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryForChunk(false, columns, boundingBox, projection, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, boundingBox, projection, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox, projection, where, whereArgs, this.getIdColumn(), limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox, projection, where, whereArgs, this.getIdColumn(), limit, offset);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, columns, featureBoundingBox, where, whereArgs, orderBy, limit);
    }

    public FeatureIndexResults queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, columns, featureBoundingBox, where, whereArgs, orderBy, limit, offset);
    }

    private FeatureIndexType verifyIndexLocation() {
        if (this.indexLocation == null) {
            throw new GeoPackageException("Index Location is not set, set the location or call an index method specifying the location");
        }
        return this.indexLocation;
    }
}

