/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.nga.style;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.attributes.AttributesDao;
import mil.nga.geopackage.attributes.AttributesResultSet;
import mil.nga.geopackage.extension.nga.style.FeatureCoreStyleExtension;
import mil.nga.geopackage.extension.nga.style.FeatureStyle;
import mil.nga.geopackage.extension.nga.style.FeatureStyles;
import mil.nga.geopackage.extension.nga.style.IconDao;
import mil.nga.geopackage.extension.nga.style.IconRow;
import mil.nga.geopackage.extension.nga.style.Icons;
import mil.nga.geopackage.extension.nga.style.StyleDao;
import mil.nga.geopackage.extension.nga.style.StyleMappingDao;
import mil.nga.geopackage.extension.nga.style.StyleMappingRow;
import mil.nga.geopackage.extension.nga.style.StyleRow;
import mil.nga.geopackage.extension.nga.style.Styles;
import mil.nga.geopackage.extension.related.RelatedTablesCoreExtension;
import mil.nga.geopackage.extension.related.RelatedTablesExtension;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.style.PixelBounds;
import mil.nga.geopackage.user.UserTable;
import mil.nga.geopackage.user.custom.UserCustomResultSet;
import mil.nga.sf.GeometryType;

public class FeatureStyleExtension
extends FeatureCoreStyleExtension {
    protected final RelatedTablesExtension relatedTables = (RelatedTablesExtension)super.getRelatedTables();

    public FeatureStyleExtension(GeoPackage geoPackage) {
        super((GeoPackageCore)geoPackage, (RelatedTablesCoreExtension)new RelatedTablesExtension(geoPackage));
    }

    public GeoPackage getGeoPackage() {
        return (GeoPackage)this.geoPackage;
    }

    public RelatedTablesExtension getRelatedTables() {
        return this.relatedTables;
    }

    public StyleMappingDao getStyleMappingDao(String featureTable) {
        return this.getMappingDao("nga_style_", featureTable);
    }

    public StyleMappingDao getTableStyleMappingDao(String featureTable) {
        return this.getMappingDao("nga_style_default_", featureTable);
    }

    public StyleMappingDao getIconMappingDao(String featureTable) {
        return this.getMappingDao("nga_icon_", featureTable);
    }

    public StyleMappingDao getTableIconMappingDao(String featureTable) {
        return this.getMappingDao("nga_icon_default_", featureTable);
    }

    private StyleMappingDao getMappingDao(String tablePrefix, String featureTable) {
        String tableName = tablePrefix + featureTable;
        StyleMappingDao dao = null;
        if (this.geoPackage.isTableOrView(tableName)) {
            dao = new StyleMappingDao(this.relatedTables.getUserDao(tableName));
        }
        return dao;
    }

    public StyleDao getStyleDao() {
        StyleDao styleDao = null;
        if (this.geoPackage.isTableOrView("nga_style")) {
            AttributesDao attributesDao = this.getGeoPackage().getAttributesDao("nga_style");
            styleDao = new StyleDao(attributesDao);
            this.relatedTables.setContents((UserTable)styleDao.getTable());
        }
        return styleDao;
    }

    public IconDao getIconDao() {
        IconDao iconDao = null;
        if (this.geoPackage.isTableOrView("nga_icon")) {
            iconDao = new IconDao(this.relatedTables.getUserDao("nga_icon"));
            this.relatedTables.setContents((UserTable)iconDao.getTable());
        }
        return iconDao;
    }

    public FeatureStyles getTableFeatureStyles(FeatureTable featureTable) {
        return this.getTableFeatureStyles(featureTable.getTableName());
    }

    public FeatureStyles getTableFeatureStyles(String featureTable) {
        FeatureStyles featureStyles = null;
        Long id = this.contentsId.getId(featureTable);
        if (id != null) {
            Styles styles = this.getTableStyles(featureTable, id);
            Icons icons = this.getTableIcons(featureTable, id);
            if (styles != null || icons != null) {
                featureStyles = new FeatureStyles(styles, icons);
            }
        }
        return featureStyles;
    }

    public Styles getTableStyles(FeatureTable featureTable) {
        return this.getTableStyles(featureTable.getTableName());
    }

    public Styles getTableStyles(String featureTable) {
        Styles styles = null;
        Long id = this.contentsId.getId(featureTable);
        if (id != null) {
            styles = this.getTableStyles(featureTable, id);
        }
        return styles;
    }

    private Styles getTableStyles(String featureTable, long contentsId) {
        return this.getTableStyles(contentsId, this.getTableStyleMappingDao(featureTable));
    }

    public StyleRow getTableStyle(String featureTable, GeometryType geometryType) {
        StyleRow styleRow = null;
        Styles tableStyles = this.getTableStyles(featureTable);
        if (tableStyles != null) {
            styleRow = tableStyles.getStyle(geometryType);
        }
        return styleRow;
    }

    public StyleRow getTableStyleDefault(String featureTable) {
        return this.getTableStyle(featureTable, null);
    }

    public Icons getTableIcons(FeatureTable featureTable) {
        return this.getTableIcons(featureTable.getTableName());
    }

    public Icons getTableIcons(String featureTable) {
        Icons icons = null;
        Long id = this.contentsId.getId(featureTable);
        if (id != null) {
            icons = this.getTableIcons(featureTable, id);
        }
        return icons;
    }

    private Icons getTableIcons(String featureTable, long contentsId) {
        return this.getTableIcons(contentsId, this.getTableIconMappingDao(featureTable));
    }

    public IconRow getTableIconDefault(String featureTable) {
        return this.getTableIcon(featureTable, null);
    }

    public IconRow getTableIcon(String featureTable, GeometryType geometryType) {
        IconRow iconRow = null;
        Icons tableIcons = this.getTableIcons(featureTable);
        if (tableIcons != null) {
            iconRow = tableIcons.getIcon(geometryType);
        }
        return iconRow;
    }

    public Map<Long, StyleRow> getStyles(String featureTable) {
        HashMap<Long, StyleRow> styles = new HashMap<Long, StyleRow>();
        Styles tableStyles = this.getTableStyles(featureTable);
        if (tableStyles != null) {
            StyleRow defaultStyleRow = tableStyles.getDefault();
            if (defaultStyleRow != null) {
                styles.put(defaultStyleRow.getId(), defaultStyleRow);
            }
            for (StyleRow styleRow : tableStyles.getStyles().values()) {
                styles.put(styleRow.getId(), styleRow);
            }
        }
        styles.putAll(this.getFeatureStyles(featureTable));
        return styles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, StyleRow> getFeatureStyles(String featureTable) {
        HashMap<Long, StyleRow> styles = new HashMap<Long, StyleRow>();
        StyleMappingDao mappingDao = this.getStyleMappingDao(featureTable);
        StyleDao styleDao = this.getStyleDao();
        if (mappingDao != null && styleDao != null) {
            try (UserCustomResultSet resultSet = (UserCustomResultSet)mappingDao.query(true, new String[]{"related_id"});){
                while (resultSet.moveToNext()) {
                    StyleMappingRow styleMappingRow = mappingDao.getRow(resultSet);
                    StyleRow styleRow = styleDao.queryForRow(styleMappingRow);
                    styles.put(styleRow.getId(), styleRow);
                }
            }
        }
        return styles;
    }

    public Map<Long, IconRow> getIcons(String featureTable) {
        HashMap<Long, IconRow> icons = new HashMap<Long, IconRow>();
        Icons tableIcons = this.getTableIcons(featureTable);
        if (tableIcons != null) {
            IconRow defaultIconRow = tableIcons.getDefault();
            if (defaultIconRow != null) {
                icons.put(defaultIconRow.getId(), defaultIconRow);
            }
            for (IconRow iconRow : tableIcons.getIcons().values()) {
                icons.put(iconRow.getId(), iconRow);
            }
        }
        icons.putAll(this.getFeatureIcons(featureTable));
        return icons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, IconRow> getFeatureIcons(String featureTable) {
        HashMap<Long, IconRow> icons = new HashMap<Long, IconRow>();
        StyleMappingDao mappingDao = this.getIconMappingDao(featureTable);
        IconDao iconDao = this.getIconDao();
        if (mappingDao != null && iconDao != null) {
            try (UserCustomResultSet resultSet = (UserCustomResultSet)mappingDao.query(true, new String[]{"related_id"});){
                while (resultSet.moveToNext()) {
                    StyleMappingRow styleMappingRow = mappingDao.getRow(resultSet);
                    IconRow iconRow = iconDao.queryForRow(styleMappingRow);
                    icons.put(iconRow.getId(), iconRow);
                }
            }
        }
        return icons;
    }

    public FeatureStyles getFeatureStyles(FeatureRow featureRow) {
        return this.getFeatureStyles(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId());
    }

    public FeatureStyles getFeatureStyles(String featureTable, long featureId) {
        Styles styles = this.getStyles(featureTable, featureId);
        Icons icons = this.getIcons(featureTable, featureId);
        FeatureStyles featureStyles = null;
        if (styles != null || icons != null) {
            featureStyles = new FeatureStyles(styles, icons);
        }
        return featureStyles;
    }

    public FeatureStyle getFeatureStyle(FeatureRow featureRow) {
        return this.getFeatureStyle(featureRow, featureRow.getGeometryType());
    }

    public FeatureStyle getFeatureStyle(FeatureRow featureRow, GeometryType geometryType) {
        return this.getFeatureStyle(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), geometryType);
    }

    public FeatureStyle getFeatureStyleDefault(FeatureRow featureRow) {
        return this.getFeatureStyle(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), null);
    }

    public FeatureStyle getFeatureStyle(String featureTable, long featureId, GeometryType geometryType) {
        FeatureStyle featureStyle = null;
        StyleRow style = this.getStyle(featureTable, featureId, geometryType);
        IconRow icon = this.getIcon(featureTable, featureId, geometryType);
        if (style != null || icon != null) {
            featureStyle = new FeatureStyle(style, icon);
        }
        return featureStyle;
    }

    public FeatureStyle getFeatureStyleDefault(String featureTable, long featureId) {
        return this.getFeatureStyle(featureTable, featureId, null);
    }

    public Styles getStyles(FeatureRow featureRow) {
        return this.getStyles(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId());
    }

    public Styles getStyles(String featureTable, long featureId) {
        return this.getStyles(featureId, this.getStyleMappingDao(featureTable));
    }

    public StyleRow getStyle(FeatureRow featureRow) {
        return this.getStyle(featureRow, featureRow.getGeometryType());
    }

    public StyleRow getStyle(FeatureRow featureRow, GeometryType geometryType) {
        return this.getStyle(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), geometryType);
    }

    public StyleRow getStyleDefault(FeatureRow featureRow) {
        return this.getStyle(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), null);
    }

    public StyleRow getStyle(String featureTable, long featureId, GeometryType geometryType) {
        return this.getStyle(featureTable, featureId, geometryType, true);
    }

    public StyleRow getStyleDefault(String featureTable, long featureId) {
        return this.getStyle(featureTable, featureId, null, true);
    }

    public StyleRow getStyle(String featureTable, long featureId, GeometryType geometryType, boolean tableStyle) {
        StyleRow styleRow = null;
        Styles styles = this.getStyles(featureTable, featureId);
        if (styles != null) {
            styleRow = styles.getStyle(geometryType);
        }
        if (styleRow == null && tableStyle) {
            styleRow = this.getTableStyle(featureTable, geometryType);
        }
        return styleRow;
    }

    public StyleRow getStyleDefault(String featureTable, long featureId, boolean tableStyle) {
        return this.getStyle(featureTable, featureId, null, tableStyle);
    }

    public Icons getIcons(FeatureRow featureRow) {
        return this.getIcons(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId());
    }

    public Icons getIcons(String featureTable, long featureId) {
        return this.getIcons(featureId, this.getIconMappingDao(featureTable));
    }

    public IconRow getIcon(FeatureRow featureRow) {
        return this.getIcon(featureRow, featureRow.getGeometryType());
    }

    public IconRow getIcon(FeatureRow featureRow, GeometryType geometryType) {
        return this.getIcon(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), geometryType);
    }

    public IconRow getIconDefault(FeatureRow featureRow) {
        return this.getIcon(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), null);
    }

    public IconRow getIcon(String featureTable, long featureId, GeometryType geometryType) {
        return this.getIcon(featureTable, featureId, geometryType, true);
    }

    public IconRow getIconDefault(String featureTable, long featureId) {
        return this.getIcon(featureTable, featureId, null, true);
    }

    public IconRow getIcon(String featureTable, long featureId, GeometryType geometryType, boolean tableIcon) {
        IconRow iconRow = null;
        Icons icons = this.getIcons(featureTable, featureId);
        if (icons != null) {
            iconRow = icons.getIcon(geometryType);
        }
        if (iconRow == null && tableIcon) {
            iconRow = this.getTableIcon(featureTable, geometryType);
        }
        return iconRow;
    }

    public IconRow getIconDefault(String featureTable, long featureId, boolean tableIcon) {
        return this.getIcon(featureTable, featureId, null, tableIcon);
    }

    private Styles getStyles(long featureId, StyleMappingDao mappingDao) {
        return this.getStyles(featureId, mappingDao, false);
    }

    private Styles getTableStyles(long featureId, StyleMappingDao mappingDao) {
        return this.getStyles(featureId, mappingDao, true);
    }

    private Styles getStyles(long featureId, StyleMappingDao mappingDao, boolean tableStyles) {
        List<StyleMappingRow> styleMappingRows;
        StyleDao styleDao;
        Styles styles = null;
        if (mappingDao != null && (styleDao = this.getStyleDao()) != null && !(styleMappingRows = mappingDao.queryByBaseFeatureId(featureId)).isEmpty()) {
            for (StyleMappingRow styleMappingRow : styleMappingRows) {
                StyleRow styleRow = styleDao.queryForRow(styleMappingRow);
                if (styleRow == null) continue;
                if (styles == null) {
                    styles = new Styles(tableStyles);
                }
                styles.setStyle(styleRow, styleMappingRow.getGeometryType());
            }
        }
        return styles;
    }

    private Icons getIcons(long featureId, StyleMappingDao mappingDao) {
        return this.getIcons(featureId, mappingDao, false);
    }

    private Icons getTableIcons(long featureId, StyleMappingDao mappingDao) {
        return this.getIcons(featureId, mappingDao, true);
    }

    private Icons getIcons(long featureId, StyleMappingDao mappingDao, boolean tableIcons) {
        List<StyleMappingRow> styleMappingRows;
        IconDao iconDao;
        Icons icons = null;
        if (mappingDao != null && (iconDao = this.getIconDao()) != null && !(styleMappingRows = mappingDao.queryByBaseFeatureId(featureId)).isEmpty()) {
            for (StyleMappingRow styleMappingRow : styleMappingRows) {
                IconRow iconRow = iconDao.queryForRow(styleMappingRow);
                if (iconRow == null) continue;
                if (icons == null) {
                    icons = new Icons(tableIcons);
                }
                icons.setIcon(iconRow, styleMappingRow.getGeometryType());
            }
        }
        return icons;
    }

    public void setTableFeatureStyles(FeatureTable featureTable, FeatureStyles featureStyles) {
        this.setTableFeatureStyles(featureTable.getTableName(), featureStyles);
    }

    public void setTableFeatureStyles(String featureTable, FeatureStyles featureStyles) {
        if (featureStyles != null) {
            this.setTableStyles(featureTable, featureStyles.getStyles());
            this.setTableIcons(featureTable, featureStyles.getIcons());
        } else {
            this.deleteTableFeatureStyles(featureTable);
        }
    }

    public void setTableStyles(FeatureTable featureTable, Styles styles) {
        this.setTableStyles(featureTable.getTableName(), styles);
    }

    public void setTableStyles(String featureTable, Styles styles) {
        this.deleteTableStyles(featureTable);
        if (styles != null) {
            if (styles.getDefault() != null) {
                this.setTableStyleDefault(featureTable, styles.getDefault());
            }
            for (Map.Entry<GeometryType, StyleRow> style : styles.getStyles().entrySet()) {
                this.setTableStyle(featureTable, style.getKey(), style.getValue());
            }
        }
    }

    public void setTableStyleDefault(FeatureTable featureTable, StyleRow style) {
        this.setTableStyleDefault(featureTable.getTableName(), style);
    }

    public void setTableStyleDefault(String featureTable, StyleRow style) {
        this.setTableStyle(featureTable, null, style);
    }

    public void setTableStyle(FeatureTable featureTable, GeometryType geometryType, StyleRow style) {
        this.setTableStyle(featureTable.getTableName(), geometryType, style);
    }

    public void setTableStyle(String featureTable, GeometryType geometryType, StyleRow style) {
        this.deleteTableStyle(featureTable, geometryType);
        if (style != null) {
            this.createTableStyleRelationship(featureTable);
            long featureContentsId = this.contentsId.getOrCreateId(featureTable);
            long styleId = this.getOrInsertStyle(style);
            StyleMappingDao mappingDao = this.getTableStyleMappingDao(featureTable);
            this.insertStyleMapping(mappingDao, featureContentsId, styleId, geometryType);
        }
    }

    public void setTableIcons(FeatureTable featureTable, Icons icons) {
        this.setTableIcons(featureTable.getTableName(), icons);
    }

    public void setTableIcons(String featureTable, Icons icons) {
        this.deleteTableIcons(featureTable);
        if (icons != null) {
            if (icons.getDefault() != null) {
                this.setTableIconDefault(featureTable, icons.getDefault());
            }
            for (Map.Entry<GeometryType, IconRow> icon : icons.getIcons().entrySet()) {
                this.setTableIcon(featureTable, icon.getKey(), icon.getValue());
            }
        }
    }

    public void setTableIconDefault(FeatureTable featureTable, IconRow icon) {
        this.setTableIconDefault(featureTable.getTableName(), icon);
    }

    public void setTableIconDefault(String featureTable, IconRow icon) {
        this.setTableIcon(featureTable, null, icon);
    }

    public void setTableIcon(FeatureTable featureTable, GeometryType geometryType, IconRow icon) {
        this.setTableIcon(featureTable.getTableName(), geometryType, icon);
    }

    public void setTableIcon(String featureTable, GeometryType geometryType, IconRow icon) {
        this.deleteTableIcon(featureTable, geometryType);
        if (icon != null) {
            this.createTableIconRelationship(featureTable);
            long featureContentsId = this.contentsId.getOrCreateId(featureTable);
            long iconId = this.getOrInsertIcon(icon);
            StyleMappingDao mappingDao = this.getTableIconMappingDao(featureTable);
            this.insertStyleMapping(mappingDao, featureContentsId, iconId, geometryType);
        }
    }

    public void setFeatureStyles(FeatureRow featureRow, FeatureStyles featureStyles) {
        this.setFeatureStyles(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), featureStyles);
    }

    public void setFeatureStyles(String featureTable, long featureId, FeatureStyles featureStyles) {
        if (featureStyles != null) {
            this.setStyles(featureTable, featureId, featureStyles.getStyles());
            this.setIcons(featureTable, featureId, featureStyles.getIcons());
        } else {
            this.deleteStyles(featureTable, featureId);
            this.deleteIcons(featureTable, featureId);
        }
    }

    public void setFeatureStyle(FeatureRow featureRow, FeatureStyle featureStyle) {
        this.setFeatureStyle(featureRow, featureRow.getGeometryType(), featureStyle);
    }

    public void setFeatureStyle(FeatureRow featureRow, GeometryType geometryType, FeatureStyle featureStyle) {
        this.setFeatureStyle(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), geometryType, featureStyle);
    }

    public void setFeatureStyleDefault(FeatureRow featureRow, FeatureStyle featureStyle) {
        this.setFeatureStyle(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), null, featureStyle);
    }

    public void setFeatureStyle(String featureTable, long featureId, GeometryType geometryType, FeatureStyle featureStyle) {
        if (featureStyle != null) {
            this.setStyle(featureTable, featureId, geometryType, featureStyle.getStyle());
            this.setIcon(featureTable, featureId, geometryType, featureStyle.getIcon());
        } else {
            this.deleteStyle(featureTable, featureId, geometryType);
            this.deleteIcon(featureTable, featureId, geometryType);
        }
    }

    public void setFeatureStyleDefault(String featureTable, long featureId, FeatureStyle featureStyle) {
        this.setFeatureStyle(featureTable, featureId, null, featureStyle);
    }

    public void setStyles(FeatureRow featureRow, Styles styles) {
        this.setStyles(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), styles);
    }

    public void setStyles(String featureTable, long featureId, Styles styles) {
        this.deleteStyles(featureTable, featureId);
        if (styles != null) {
            if (styles.getDefault() != null) {
                this.setStyleDefault(featureTable, featureId, styles.getDefault());
            }
            for (Map.Entry<GeometryType, StyleRow> style : styles.getStyles().entrySet()) {
                this.setStyle(featureTable, featureId, style.getKey(), style.getValue());
            }
        }
    }

    public void setStyle(FeatureRow featureRow, StyleRow style) {
        this.setStyle(featureRow, featureRow.getGeometryType(), style);
    }

    public void setStyle(FeatureRow featureRow, GeometryType geometryType, StyleRow style) {
        this.setStyle(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), geometryType, style);
    }

    public void setStyleDefault(FeatureRow featureRow, StyleRow style) {
        this.setStyle(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), null, style);
    }

    public void setStyle(String featureTable, long featureId, GeometryType geometryType, StyleRow style) {
        this.deleteStyle(featureTable, featureId, geometryType);
        if (style != null) {
            this.createStyleRelationship(featureTable);
            long styleId = this.getOrInsertStyle(style);
            StyleMappingDao mappingDao = this.getStyleMappingDao(featureTable);
            this.insertStyleMapping(mappingDao, featureId, styleId, geometryType);
        }
    }

    public void setStyleDefault(String featureTable, long featureId, StyleRow style) {
        this.setStyle(featureTable, featureId, null, style);
    }

    public void setIcons(FeatureRow featureRow, Icons icons) {
        this.setIcons(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), icons);
    }

    public void setIcons(String featureTable, long featureId, Icons icons) {
        this.deleteIcons(featureTable, featureId);
        if (icons != null) {
            if (icons.getDefault() != null) {
                this.setIconDefault(featureTable, featureId, icons.getDefault());
            }
            for (Map.Entry<GeometryType, IconRow> icon : icons.getIcons().entrySet()) {
                this.setIcon(featureTable, featureId, icon.getKey(), icon.getValue());
            }
        }
    }

    public void setIcon(FeatureRow featureRow, IconRow icon) {
        this.setIcon(featureRow, featureRow.getGeometryType(), icon);
    }

    public void setIcon(FeatureRow featureRow, GeometryType geometryType, IconRow icon) {
        this.setIcon(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), geometryType, icon);
    }

    public void setIconDefault(FeatureRow featureRow, IconRow icon) {
        this.setIcon(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), null, icon);
    }

    public void setIcon(String featureTable, long featureId, GeometryType geometryType, IconRow icon) {
        this.deleteIcon(featureTable, featureId, geometryType);
        if (icon != null) {
            this.createIconRelationship(featureTable);
            long iconId = this.getOrInsertIcon(icon);
            StyleMappingDao mappingDao = this.getIconMappingDao(featureTable);
            this.insertStyleMapping(mappingDao, featureId, iconId, geometryType);
        }
    }

    public void setIconDefault(String featureTable, long featureId, IconRow icon) {
        this.setIcon(featureTable, featureId, null, icon);
    }

    private long getOrInsertStyle(StyleRow style) {
        long styleId;
        if (style.hasId()) {
            styleId = style.getId();
        } else {
            StyleDao styleDao = this.getStyleDao();
            styleId = styleDao.create(style);
        }
        return styleId;
    }

    private long getOrInsertIcon(IconRow icon) {
        long iconId;
        if (icon.hasId()) {
            iconId = icon.getId();
        } else {
            IconDao iconDao = this.getIconDao();
            iconId = iconDao.create(icon);
        }
        return iconId;
    }

    private void insertStyleMapping(StyleMappingDao mappingDao, long baseId, long relatedId, GeometryType geometryType) {
        StyleMappingRow row = mappingDao.newRow();
        row.setBaseId(baseId);
        row.setRelatedId(relatedId);
        row.setGeometryType(geometryType);
        mappingDao.insert(row);
    }

    public void deleteAllFeatureStyles(FeatureTable featureTable) {
        this.deleteAllFeatureStyles(featureTable.getTableName());
    }

    public void deleteAllFeatureStyles(String featureTable) {
        this.deleteTableFeatureStyles(featureTable);
        this.deleteFeatureStyles(featureTable);
    }

    public void deleteAllStyles(FeatureTable featureTable) {
        this.deleteAllStyles(featureTable.getTableName());
    }

    public void deleteAllStyles(String featureTable) {
        this.deleteTableStyles(featureTable);
        this.deleteStyles(featureTable);
    }

    public void deleteAllIcons(FeatureTable featureTable) {
        this.deleteAllIcons(featureTable.getTableName());
    }

    public void deleteAllIcons(String featureTable) {
        this.deleteTableIcons(featureTable);
        this.deleteIcons(featureTable);
    }

    public void deleteTableFeatureStyles(FeatureTable featureTable) {
        this.deleteTableFeatureStyles(featureTable.getTableName());
    }

    public void deleteTableFeatureStyles(String featureTable) {
        this.deleteTableStyles(featureTable);
        this.deleteTableIcons(featureTable);
    }

    public void deleteTableStyles(FeatureTable featureTable) {
        this.deleteTableStyles(featureTable.getTableName());
    }

    public void deleteTableStyles(String featureTable) {
        this.deleteTableMappings(this.getTableStyleMappingDao(featureTable), featureTable);
    }

    public void deleteTableStyleDefault(FeatureTable featureTable) {
        this.deleteTableStyleDefault(featureTable.getTableName());
    }

    public void deleteTableStyleDefault(String featureTable) {
        this.deleteTableStyle(featureTable, null);
    }

    public void deleteTableStyle(FeatureTable featureTable, GeometryType geometryType) {
        this.deleteTableStyle(featureTable.getTableName(), geometryType);
    }

    public void deleteTableStyle(String featureTable, GeometryType geometryType) {
        this.deleteTableMapping(this.getTableStyleMappingDao(featureTable), featureTable, geometryType);
    }

    public void deleteTableIcons(FeatureTable featureTable) {
        this.deleteTableIcons(featureTable.getTableName());
    }

    public void deleteTableIcons(String featureTable) {
        this.deleteTableMappings(this.getTableIconMappingDao(featureTable), featureTable);
    }

    public void deleteTableIconDefault(FeatureTable featureTable) {
        this.deleteTableIconDefault(featureTable.getTableName());
    }

    public void deleteTableIconDefault(String featureTable) {
        this.deleteTableIcon(featureTable, null);
    }

    public void deleteTableIcon(FeatureTable featureTable, GeometryType geometryType) {
        this.deleteTableIcon(featureTable.getTableName(), geometryType);
    }

    public void deleteTableIcon(String featureTable, GeometryType geometryType) {
        this.deleteTableMapping(this.getTableIconMappingDao(featureTable), featureTable, geometryType);
    }

    private void deleteTableMappings(StyleMappingDao mappingDao, String featureTable) {
        Long featureContentsId;
        if (mappingDao != null && (featureContentsId = this.contentsId.getId(featureTable)) != null) {
            mappingDao.deleteByBaseId(featureContentsId);
        }
    }

    private void deleteTableMapping(StyleMappingDao mappingDao, String featureTable, GeometryType geometryType) {
        Long featureContentsId;
        if (mappingDao != null && (featureContentsId = this.contentsId.getId(featureTable)) != null) {
            mappingDao.deleteByBaseId(featureContentsId, geometryType);
        }
    }

    public void deleteFeatureStyles(FeatureTable featureTable) {
        this.deleteFeatureStyles(featureTable.getTableName());
    }

    public void deleteFeatureStyles(String featureTable) {
        this.deleteStyles(featureTable);
        this.deleteIcons(featureTable);
    }

    public void deleteStyles(FeatureTable featureTable) {
        this.deleteStyles(featureTable.getTableName());
    }

    public void deleteStyles(String featureTable) {
        this.deleteMappings(this.getStyleMappingDao(featureTable));
    }

    public void deleteStyles(FeatureRow featureRow) {
        this.deleteStyles(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId());
    }

    public void deleteStyles(String featureTable, long featureId) {
        this.deleteMappings(this.getStyleMappingDao(featureTable), featureId);
    }

    public void deleteStyleDefault(FeatureRow featureRow) {
        this.deleteStyleDefault(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId());
    }

    public void deleteStyleDefault(String featureTable, long featureId) {
        this.deleteStyle(featureTable, featureId, null);
    }

    public void deleteStyle(FeatureRow featureRow) {
        this.deleteStyle(featureRow, featureRow.getGeometryType());
    }

    public void deleteStyle(FeatureRow featureRow, GeometryType geometryType) {
        this.deleteStyle(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), geometryType);
    }

    public void deleteStyle(String featureTable, long featureId, GeometryType geometryType) {
        this.deleteMapping(this.getStyleMappingDao(featureTable), featureId, geometryType);
    }

    public void deleteIcons(FeatureTable featureTable) {
        this.deleteIcons(featureTable.getTableName());
    }

    public void deleteIcons(String featureTable) {
        this.deleteMappings(this.getIconMappingDao(featureTable));
    }

    public void deleteIcons(FeatureRow featureRow) {
        this.deleteIcons(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId());
    }

    public void deleteIcons(String featureTable, long featureId) {
        this.deleteMappings(this.getIconMappingDao(featureTable), featureId);
    }

    public void deleteIconDefault(FeatureRow featureRow) {
        this.deleteIconDefault(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId());
    }

    public void deleteIconDefault(String featureTable, long featureId) {
        this.deleteIcon(featureTable, featureId, null);
    }

    public void deleteIcon(FeatureRow featureRow) {
        this.deleteIcon(featureRow, featureRow.getGeometryType());
    }

    public void deleteIcon(FeatureRow featureRow, GeometryType geometryType) {
        this.deleteIcon(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId(), geometryType);
    }

    public void deleteIcon(String featureTable, long featureId, GeometryType geometryType) {
        this.deleteMapping(this.getIconMappingDao(featureTable), featureId, geometryType);
    }

    public int countStyleRowMappings(StyleRow styleRow) throws SQLException {
        return this.countStyleRowMappings(styleRow.getId());
    }

    public int countStyleRowMappings(long id) throws SQLException {
        return this.relatedTables.countMappingsToRelated("nga_style", id);
    }

    public boolean hasStyleRowMapping(StyleRow styleRow) throws SQLException {
        return this.hasStyleRowMapping(styleRow.getId());
    }

    public boolean hasStyleRowMapping(long id) throws SQLException {
        return this.relatedTables.hasMappingToRelated("nga_style", id);
    }

    public int deleteStyleRowMappings(StyleRow styleRow) throws SQLException {
        return this.deleteStyleRowMappings(styleRow.getId());
    }

    public int deleteStyleRowMappings(long id) throws SQLException {
        return this.relatedTables.deleteMappingsToRelated("nga_style", id);
    }

    public int deleteStyleRow(StyleRow styleRow) throws SQLException {
        return this.deleteStyleRow(styleRow.getId());
    }

    public int deleteStyleRowNotMapped(StyleRow styleRow) throws SQLException {
        return this.deleteStyleRowNotMapped(styleRow.getId());
    }

    public int deleteStyleRow(long id) throws SQLException {
        int count = 0;
        StyleDao styleDao = this.getStyleDao();
        if (styleDao != null) {
            count = this.deleteStyleRowMappings(id);
            count += styleDao.deleteById(id);
        }
        return count;
    }

    public int deleteStyleRowNotMapped(long id) throws SQLException {
        int count = 0;
        if (!this.hasStyleRowMapping(id)) {
            count = this.deleteStyleRow(id);
        }
        return count;
    }

    public int deleteStyleRows(String whereClause, String[] whereArgs) throws SQLException {
        int count = 0;
        StyleDao styleDao = this.getStyleDao();
        if (styleDao != null) {
            count += this.deleteStyleRows((AttributesResultSet)styleDao.query(whereClause, whereArgs));
            count += styleDao.delete(whereClause, whereArgs);
        }
        return count;
    }

    public int deleteStyleRowsNotMapped(String whereClause, String[] whereArgs) throws SQLException {
        int count = 0;
        StyleDao styleDao = this.getStyleDao();
        if (styleDao != null) {
            count += this.deleteStyleRowsNotMapped((AttributesResultSet)styleDao.query(whereClause, whereArgs));
        }
        return count;
    }

    public int deleteStyleRows(Map<String, Object> fieldValues) throws SQLException {
        int count = 0;
        StyleDao styleDao = this.getStyleDao();
        if (styleDao != null) {
            count += this.deleteStyleRows((AttributesResultSet)styleDao.queryForFieldValues(fieldValues));
            count += styleDao.delete(fieldValues);
        }
        return count;
    }

    public int deleteStyleRowsNotMapped(Map<String, Object> fieldValues) throws SQLException {
        int count = 0;
        StyleDao styleDao = this.getStyleDao();
        if (styleDao != null) {
            count += this.deleteStyleRowsNotMapped((AttributesResultSet)styleDao.queryForFieldValues(fieldValues));
        }
        return count;
    }

    public int deleteStyleRows() throws SQLException {
        int count = 0;
        StyleDao styleDao = this.getStyleDao();
        if (styleDao != null) {
            count += this.deleteStyleRows((AttributesResultSet)styleDao.query());
            count += styleDao.deleteAll();
        }
        return count;
    }

    public int deleteStyleRowsNotMapped() throws SQLException {
        int count = 0;
        StyleDao styleDao = this.getStyleDao();
        if (styleDao != null) {
            count += this.deleteStyleRowsNotMapped((AttributesResultSet)styleDao.query());
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteStyleRows(AttributesResultSet resultSet) throws SQLException {
        int count = 0;
        try {
            for (long id : resultSet.ids()) {
                count += this.deleteStyleRowMappings(id);
            }
        }
        finally {
            resultSet.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteStyleRowsNotMapped(AttributesResultSet resultSet) throws SQLException {
        int count = 0;
        try {
            for (long id : resultSet.ids()) {
                count += this.deleteStyleRowNotMapped(id);
            }
        }
        finally {
            resultSet.close();
        }
        return count;
    }

    public int countIconRowMappings(IconRow iconRow) throws SQLException {
        return this.countIconRowMappings(iconRow.getId());
    }

    public int countIconRowMappings(long id) throws SQLException {
        return this.relatedTables.countMappingsToRelated("nga_icon", id);
    }

    public boolean hasIconRowMapping(IconRow iconRow) throws SQLException {
        return this.hasIconRowMapping(iconRow.getId());
    }

    public boolean hasIconRowMapping(long id) throws SQLException {
        return this.relatedTables.hasMappingToRelated("nga_icon", id);
    }

    public int deleteIconRowMappings(IconRow iconRow) throws SQLException {
        return this.deleteIconRowMappings(iconRow.getId());
    }

    public int deleteIconRowMappings(long id) throws SQLException {
        return this.relatedTables.deleteMappingsToRelated("nga_icon", id);
    }

    public int deleteIconRow(IconRow iconRow) throws SQLException {
        return this.deleteIconRow(iconRow.getId());
    }

    public int deleteIconRowNotMapped(IconRow iconRow) throws SQLException {
        return this.deleteIconRowNotMapped(iconRow.getId());
    }

    public int deleteIconRow(long id) throws SQLException {
        int count = 0;
        IconDao iconDao = this.getIconDao();
        if (iconDao != null) {
            count = this.deleteIconRowMappings(id);
            count += iconDao.deleteById(id);
        }
        return count;
    }

    public int deleteIconRowNotMapped(long id) throws SQLException {
        int count = 0;
        if (!this.hasIconRowMapping(id)) {
            count = this.deleteIconRow(id);
        }
        return count;
    }

    public int deleteIconRows(String whereClause, String[] whereArgs) throws SQLException {
        int count = 0;
        IconDao iconDao = this.getIconDao();
        if (iconDao != null) {
            count += this.deleteIconRows((UserCustomResultSet)iconDao.query(whereClause, whereArgs));
            count += iconDao.delete(whereClause, whereArgs);
        }
        return count;
    }

    public int deleteIconRowsNotMapped(String whereClause, String[] whereArgs) throws SQLException {
        int count = 0;
        IconDao iconDao = this.getIconDao();
        if (iconDao != null) {
            count += this.deleteIconRowsNotMapped((UserCustomResultSet)iconDao.query(whereClause, whereArgs));
        }
        return count;
    }

    public int deleteIconRows(Map<String, Object> fieldValues) throws SQLException {
        int count = 0;
        IconDao iconDao = this.getIconDao();
        if (iconDao != null) {
            count += this.deleteIconRows((UserCustomResultSet)iconDao.queryForFieldValues(fieldValues));
            count += iconDao.delete(fieldValues);
        }
        return count;
    }

    public int deleteIconRowsNotMapped(Map<String, Object> fieldValues) throws SQLException {
        int count = 0;
        IconDao iconDao = this.getIconDao();
        if (iconDao != null) {
            count += this.deleteIconRowsNotMapped((UserCustomResultSet)iconDao.queryForFieldValues(fieldValues));
        }
        return count;
    }

    public int deleteIconRows() throws SQLException {
        int count = 0;
        IconDao iconDao = this.getIconDao();
        if (iconDao != null) {
            count += this.deleteIconRows((UserCustomResultSet)iconDao.query());
            count += iconDao.deleteAll();
        }
        return count;
    }

    public int deleteIconRowsNotMapped() throws SQLException {
        int count = 0;
        IconDao iconDao = this.getIconDao();
        if (iconDao != null) {
            count += this.deleteIconRowsNotMapped((UserCustomResultSet)iconDao.query());
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteIconRows(UserCustomResultSet resultSet) throws SQLException {
        int count = 0;
        try {
            for (long id : resultSet.ids()) {
                count += this.deleteIconRowMappings(id);
            }
        }
        finally {
            resultSet.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteIconRowsNotMapped(UserCustomResultSet resultSet) throws SQLException {
        int count = 0;
        try {
            for (long id : resultSet.ids()) {
                count += this.deleteIconRowNotMapped(id);
            }
        }
        finally {
            resultSet.close();
        }
        return count;
    }

    private void deleteMappings(StyleMappingDao mappingDao) {
        if (mappingDao != null) {
            mappingDao.deleteAll();
        }
    }

    private void deleteMappings(StyleMappingDao mappingDao, long featureId) {
        if (mappingDao != null) {
            mappingDao.deleteByBaseId(featureId);
        }
    }

    private void deleteMapping(StyleMappingDao mappingDao, long featureId, GeometryType geometryType) {
        if (mappingDao != null) {
            mappingDao.deleteByBaseId(featureId, geometryType);
        }
    }

    public List<Long> getAllTableStyleIds(FeatureTable featureTable) {
        return this.getAllTableStyleIds(featureTable.getTableName());
    }

    public List<Long> getAllTableStyleIds(String featureTable) {
        List<Long> styleIds = null;
        StyleMappingDao mappingDao = this.getTableStyleMappingDao(featureTable);
        if (mappingDao != null) {
            styleIds = mappingDao.uniqueRelatedIds();
        }
        return styleIds;
    }

    public List<Long> getAllTableIconIds(FeatureTable featureTable) {
        return this.getAllTableIconIds(featureTable.getTableName());
    }

    public List<Long> getAllTableIconIds(String featureTable) {
        List<Long> iconIds = null;
        StyleMappingDao mappingDao = this.getTableIconMappingDao(featureTable);
        if (mappingDao != null) {
            iconIds = mappingDao.uniqueRelatedIds();
        }
        return iconIds;
    }

    public List<Long> getAllStyleIds(FeatureTable featureTable) {
        return this.getAllStyleIds(featureTable.getTableName());
    }

    public List<Long> getAllStyleIds(String featureTable) {
        List<Long> styleIds = null;
        StyleMappingDao mappingDao = this.getStyleMappingDao(featureTable);
        if (mappingDao != null) {
            styleIds = mappingDao.uniqueRelatedIds();
        }
        return styleIds;
    }

    public List<Long> getAllIconIds(FeatureTable featureTable) {
        return this.getAllIconIds(featureTable.getTableName());
    }

    public List<Long> getAllIconIds(String featureTable) {
        List<Long> iconIds = null;
        StyleMappingDao mappingDao = this.getIconMappingDao(featureTable);
        if (mappingDao != null) {
            iconIds = mappingDao.uniqueRelatedIds();
        }
        return iconIds;
    }

    public PixelBounds calculatePixelBounds(String featureTable) {
        return this.calculatePixelBounds(featureTable, 1.0f);
    }

    public PixelBounds calculatePixelBounds(String featureTable, float scale) {
        Map<Long, StyleRow> styles = this.getStyles(featureTable);
        Map<Long, IconRow> icons = this.getIcons(featureTable);
        PixelBounds pixelBounds = new PixelBounds();
        for (StyleRow styleRow : styles.values()) {
            FeatureStyleExtension.calculatePixelBounds(pixelBounds, styleRow, scale);
        }
        for (IconRow iconRow : icons.values()) {
            FeatureStyleExtension.calculatePixelBounds(pixelBounds, iconRow, scale);
        }
        return pixelBounds;
    }

    public static PixelBounds calculatePixelBounds(StyleRow styleRow) {
        return FeatureStyleExtension.calculatePixelBounds(styleRow, 1.0f);
    }

    public static PixelBounds calculatePixelBounds(StyleRow styleRow, float scale) {
        PixelBounds pixelBounds = new PixelBounds();
        FeatureStyleExtension.calculatePixelBounds(pixelBounds, styleRow, scale);
        return pixelBounds;
    }

    public static void calculatePixelBounds(PixelBounds pixelBounds, StyleRow styleRow) {
        FeatureStyleExtension.calculatePixelBounds(pixelBounds, styleRow, 1.0f);
    }

    public static void calculatePixelBounds(PixelBounds pixelBounds, StyleRow styleRow, float scale) {
        double styleHalfWidth = (double)scale * (styleRow.getWidthOrDefault() / 2.0);
        pixelBounds.expandLength(styleHalfWidth);
    }

    public static PixelBounds calculatePixelBounds(IconRow iconRow) {
        return FeatureStyleExtension.calculatePixelBounds(iconRow, 1.0f);
    }

    public static PixelBounds calculatePixelBounds(IconRow iconRow, float scale) {
        PixelBounds pixelBounds = new PixelBounds();
        FeatureStyleExtension.calculatePixelBounds(pixelBounds, iconRow, scale);
        return pixelBounds;
    }

    public static void calculatePixelBounds(PixelBounds pixelBounds, IconRow iconRow) {
        FeatureStyleExtension.calculatePixelBounds(pixelBounds, iconRow, 1.0f);
    }

    public static void calculatePixelBounds(PixelBounds pixelBounds, IconRow iconRow, float scale) {
        double[] iconDimensions = iconRow.getDerivedDimensions();
        double iconWidth = (double)scale * Math.ceil(iconDimensions[0]);
        double iconHeight = (double)scale * Math.ceil(iconDimensions[1]);
        double anchorU = iconRow.getAnchorUOrDefault();
        double anchorV = iconRow.getAnchorVOrDefault();
        double left = anchorU * iconWidth;
        double right = iconWidth - left;
        double top = anchorV * iconHeight;
        double bottom = iconHeight - top;
        pixelBounds.expandLeft(right);
        pixelBounds.expandRight(left);
        pixelBounds.expandUp(bottom);
        pixelBounds.expandDown(top);
    }
}

