/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import org.apache.baremaps.ogcapi.model.ExtentSpatial;
import org.apache.baremaps.ogcapi.model.ExtentTemporal;

@ApiModel(description="The extent of the data in the collection. In the Core only spatial and temporal extents are specified. Extensions may add additional members to represent other extents, for example, thermal or pressure ranges.  The first item in the array describes the overall extent of the data. All subsequent items describe more precise extents, e.g., to identify clusters of data. Clients only interested in the overall extent will only need to access the first item in each array.")
@JsonTypeName(value="extent")
public class Extent {
    @Valid
    private ExtentSpatial spatial;
    @Valid
    private ExtentTemporal temporal;

    public Extent spatial(ExtentSpatial spatial) {
        this.spatial = spatial;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="spatial")
    public ExtentSpatial getSpatial() {
        return this.spatial;
    }

    @JsonProperty(value="spatial")
    public void setSpatial(ExtentSpatial spatial) {
        this.spatial = spatial;
    }

    public Extent temporal(ExtentTemporal temporal) {
        this.temporal = temporal;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="temporal")
    public ExtentTemporal getTemporal() {
        return this.temporal;
    }

    @JsonProperty(value="temporal")
    public void setTemporal(ExtentTemporal temporal) {
        this.temporal = temporal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extent extent = (Extent)o;
        return Objects.equals(this.spatial, extent.spatial) && Objects.equals(this.temporal, extent.temporal);
    }

    public int hashCode() {
        return Objects.hash(this.spatial, this.temporal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Extent {\n");
        sb.append("    spatial: ").append(this.toIndentedString(this.spatial)).append("\n");
        sb.append("    temporal: ").append(this.toIndentedString(this.temporal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

