/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.baremaps.ogcapi.model.Crs;

@ApiModel(description="Minimum bounding rectangle surrounding a 2D resource in the CRS indicated elsewhere")
@JsonTypeName(value="BoundingBox2D")
public class BoundingBox2D {
    @Valid
    private List<BigDecimal> lowerLeft = new ArrayList<BigDecimal>();
    @Valid
    private List<BigDecimal> upperRight = new ArrayList<BigDecimal>();
    @Valid
    private Crs crs;
    @Valid
    private List<String> orderedAxes = null;

    public BoundingBox2D lowerLeft(List<BigDecimal> lowerLeft) {
        this.lowerLeft = lowerLeft;
        return this;
    }

    @ApiModelProperty(required=true, value="A 2D Point in the CRS indicated elsewhere")
    @JsonProperty(value="lowerLeft")
    @NotNull
    @Size(min=2, max=2)
    public @NotNull @Size(min=2, max=2) List<BigDecimal> getLowerLeft() {
        return this.lowerLeft;
    }

    @JsonProperty(value="lowerLeft")
    public void setLowerLeft(List<BigDecimal> lowerLeft) {
        this.lowerLeft = lowerLeft;
    }

    public BoundingBox2D addLowerLeftItem(BigDecimal lowerLeftItem) {
        if (this.lowerLeft == null) {
            this.lowerLeft = new ArrayList<BigDecimal>();
        }
        this.lowerLeft.add(lowerLeftItem);
        return this;
    }

    public BoundingBox2D removeLowerLeftItem(BigDecimal lowerLeftItem) {
        if (lowerLeftItem != null && this.lowerLeft != null) {
            this.lowerLeft.remove(lowerLeftItem);
        }
        return this;
    }

    public BoundingBox2D upperRight(List<BigDecimal> upperRight) {
        this.upperRight = upperRight;
        return this;
    }

    @ApiModelProperty(required=true, value="A 2D Point in the CRS indicated elsewhere")
    @JsonProperty(value="upperRight")
    @NotNull
    @Size(min=2, max=2)
    public @NotNull @Size(min=2, max=2) List<BigDecimal> getUpperRight() {
        return this.upperRight;
    }

    @JsonProperty(value="upperRight")
    public void setUpperRight(List<BigDecimal> upperRight) {
        this.upperRight = upperRight;
    }

    public BoundingBox2D addUpperRightItem(BigDecimal upperRightItem) {
        if (this.upperRight == null) {
            this.upperRight = new ArrayList<BigDecimal>();
        }
        this.upperRight.add(upperRightItem);
        return this;
    }

    public BoundingBox2D removeUpperRightItem(BigDecimal upperRightItem) {
        if (upperRightItem != null && this.upperRight != null) {
            this.upperRight.remove(upperRightItem);
        }
        return this;
    }

    public BoundingBox2D crs(Crs crs) {
        this.crs = crs;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="crs")
    public Crs getCrs() {
        return this.crs;
    }

    @JsonProperty(value="crs")
    public void setCrs(Crs crs) {
        this.crs = crs;
    }

    public BoundingBox2D orderedAxes(List<String> orderedAxes) {
        this.orderedAxes = orderedAxes;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="orderedAxes")
    @Size(min=2, max=2)
    public @Size(min=2, max=2) List<String> getOrderedAxes() {
        return this.orderedAxes;
    }

    @JsonProperty(value="orderedAxes")
    public void setOrderedAxes(List<String> orderedAxes) {
        this.orderedAxes = orderedAxes;
    }

    public BoundingBox2D addOrderedAxesItem(String orderedAxesItem) {
        if (this.orderedAxes == null) {
            this.orderedAxes = new ArrayList<String>();
        }
        this.orderedAxes.add(orderedAxesItem);
        return this;
    }

    public BoundingBox2D removeOrderedAxesItem(String orderedAxesItem) {
        if (orderedAxesItem != null && this.orderedAxes != null) {
            this.orderedAxes.remove(orderedAxesItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundingBox2D boundingBox2D = (BoundingBox2D)o;
        return Objects.equals(this.lowerLeft, boundingBox2D.lowerLeft) && Objects.equals(this.upperRight, boundingBox2D.upperRight) && Objects.equals(this.crs, boundingBox2D.crs) && Objects.equals(this.orderedAxes, boundingBox2D.orderedAxes);
    }

    public int hashCode() {
        return Objects.hash(this.lowerLeft, this.upperRight, this.crs, this.orderedAxes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BoundingBox2D {\n");
        sb.append("    lowerLeft: ").append(this.toIndentedString(this.lowerLeft)).append("\n");
        sb.append("    upperRight: ").append(this.toIndentedString(this.upperRight)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString(this.crs)).append("\n");
        sb.append("    orderedAxes: ").append(this.toIndentedString(this.orderedAxes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

