/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.shapefile;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.baremaps.database.schema.AbstractDataTable;
import org.apache.baremaps.database.schema.DataRow;
import org.apache.baremaps.database.schema.DataRowType;
import org.apache.baremaps.database.schema.DataTableException;
import org.apache.baremaps.storage.shapefile.internal.ShapefileInputStream;
import org.apache.baremaps.storage.shapefile.internal.ShapefileReader;

public class ShapefileDataTable
extends AbstractDataTable {
    private final ShapefileReader shapeFile;

    public ShapefileDataTable(Path file) {
        this.shapeFile = new ShapefileReader(file.toString());
    }

    @Override
    public DataRowType rowType() throws DataTableException {
        ShapefileInputStream input = this.shapeFile.read();
        try {
            DataRowType dataRowType = input.rowType();
            if (input != null) {
                input.close();
            }
            return dataRowType;
        }
        catch (Throwable throwable) {
            try {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DataTableException(e);
            }
        }
    }

    @Override
    public Iterator<DataRow> iterator() {
        try {
            return new ShapefileIterator(this.shapeFile.read());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long sizeAsLong() {
        return Long.MAX_VALUE;
    }

    public static class ShapefileIterator
    implements Iterator<DataRow> {
        private final ShapefileInputStream shapefileInputStream;
        private DataRow next;

        public ShapefileIterator(ShapefileInputStream shapefileInputStream) {
            this.shapefileInputStream = shapefileInputStream;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.next == null) {
                    this.next = this.shapefileInputStream.readRow();
                }
                return this.next != null;
            }
            catch (IOException exception) {
                this.shapefileInputStream.close();
                return false;
            }
        }

        @Override
        public DataRow next() {
            try {
                if (this.next == null) {
                    this.next = this.shapefileInputStream.readRow();
                }
                DataRow current = this.next;
                this.next = null;
                return current;
            }
            catch (Exception e) {
                this.shapefileInputStream.close();
                throw new NoSuchElementException();
            }
        }
    }
}

