/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage;

import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.logger.Level;
import com.j256.ormlite.logger.LogBackendType;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.support.ConnectionSource;
import java.io.File;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.GeoPackageImpl;
import mil.nga.geopackage.db.GeoPackageConnection;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageTableCreator;
import mil.nga.geopackage.io.GeoPackageIOUtils;
import mil.nga.geopackage.validate.GeoPackageValidate;

public class GeoPackageManager {
    public static File create(File file) {
        return GeoPackageManager.create(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File create(File file, boolean validate) {
        boolean isGeoPackage = true;
        if (GeoPackageIOUtils.hasFileExtension((File)file)) {
            if (validate) {
                GeoPackageValidate.validateGeoPackageExtension((File)file);
            } else {
                isGeoPackage = GeoPackageValidate.hasGeoPackageExtension((File)file);
            }
        } else {
            file = GeoPackageManager.addExtension(file);
        }
        if (file.exists()) {
            throw new GeoPackageException("File already exists: " + file.getAbsolutePath());
        }
        try (GeoPackageConnection connection = GeoPackageManager.connect(file);){
            if (isGeoPackage) {
                connection.setApplicationId();
                connection.setUserVersion();
                GeoPackageTableCreator tableCreator = new GeoPackageTableCreator((GeoPackageCoreConnection)connection);
                tableCreator.createRequired();
            }
        }
        return file;
    }

    public static File create(File directory, String name) {
        return GeoPackageManager.create(directory, name, true);
    }

    public static File create(File directory, String name, boolean validate) {
        return GeoPackageManager.create(new File(directory, name), validate);
    }

    public static GeoPackage open(File file) {
        return GeoPackageManager.open(true, file);
    }

    public static GeoPackage open(boolean writable, File file) {
        return GeoPackageManager.open(writable, file, true);
    }

    public static GeoPackage open(File file, boolean validate) {
        return GeoPackageManager.open(true, file, validate);
    }

    public static GeoPackage open(boolean writable, File file, boolean validate) {
        return GeoPackageManager.open(file.getName(), writable, file, validate);
    }

    public static GeoPackage open(String name, File file) {
        return GeoPackageManager.open(name, true, file);
    }

    public static GeoPackage open(String name, boolean writable, File file) {
        return GeoPackageManager.open(name, writable, file, true);
    }

    public static GeoPackage open(String name, File file, boolean validate) {
        return GeoPackageManager.open(name, true, file, validate);
    }

    public static GeoPackage open(String name, boolean writable, File file, boolean validate) {
        File existingFile = GeoPackageManager.existingFile(file);
        if (existingFile == null) {
            throw new GeoPackageException("File not found: " + file.getAbsolutePath());
        }
        file = existingFile;
        if (validate && GeoPackageIOUtils.hasFileExtension((File)file)) {
            GeoPackageValidate.validateGeoPackageExtension((File)file);
        }
        GeoPackageConnection connection = GeoPackageManager.connect(file);
        GeoPackageImpl geoPackage = new GeoPackageImpl(name, file, connection, writable);
        if (validate) {
            try {
                GeoPackageValidate.validateMinimumTables((GeoPackageCore)geoPackage);
            }
            catch (RuntimeException e) {
                geoPackage.close();
                throw e;
            }
        }
        return geoPackage;
    }

    public static boolean isWritable(File file) {
        return Files.isWritable(file.toPath());
    }

    public static File addExtension(File file) {
        if (!GeoPackageIOUtils.hasFileExtension((File)file)) {
            file = GeoPackageIOUtils.addFileExtension((File)file, (String)"gpkg");
        }
        return file;
    }

    public static String addExtension(String file) {
        if (!GeoPackageIOUtils.hasFileExtension((String)file)) {
            file = GeoPackageIOUtils.addFileExtension((String)file, (String)"gpkg");
        }
        return file;
    }

    public static File existingFile(File file) {
        File existingFile = null;
        if (file.exists()) {
            existingFile = file;
        } else if ((file = GeoPackageManager.addExtension(file)).exists()) {
            existingFile = file;
        }
        return existingFile;
    }

    public static boolean exists(File file) {
        return GeoPackageManager.existingFile(file) != null;
    }

    private static GeoPackageConnection connect(File file) {
        JdbcConnectionSource connectionSource;
        Connection databaseConnection;
        String databaseUrl = "jdbc:sqlite:" + file.getPath();
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new GeoPackageException("Failed to load the SQLite JDBC driver", (Throwable)e);
        }
        try {
            databaseConnection = DriverManager.getConnection(databaseUrl);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get connection to the SQLite file: " + file.getAbsolutePath(), (Throwable)e);
        }
        try {
            connectionSource = new JdbcConnectionSource(databaseUrl);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get connection source to the SQLite file: " + file.getAbsolutePath(), (Throwable)e);
        }
        GeoPackageConnection connection = new GeoPackageConnection(file, databaseConnection, (ConnectionSource)connectionSource);
        connection.enableForeignKeys();
        return connection;
    }

    static {
        System.setProperty("com.j256.simplelogging.level", Level.ERROR.name());
        if (LogBackendType.JAVA_UTIL.isAvailable()) {
            LoggerFactory.setLogBackendType((LogBackendType)LogBackendType.JAVA_UTIL);
        }
    }
}

