/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.iploc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.netty.HttpServers;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import javax.ws.rs.core.Application;
import org.apache.baremaps.iploc.IpLocRepository;
import org.apache.baremaps.server.ClassPathResource;
import org.apache.baremaps.server.CorsFilter;
import org.apache.baremaps.server.IpLocResource;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="serve", description={"Start an IP to location web service."})
public class Serve
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Serve.class);
    @CommandLine.Option(names={"--database"}, paramLabel="DATABASE", description={"The path of the SQLite database."}, defaultValue="iploc.db")
    private Path database;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        String jdbcUrl = String.format("JDBC:sqlite:%s", this.database.toString());
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(jdbcUrl);
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        HikariDataSource dataSource = new HikariDataSource(config);
        final IpLocRepository ipLocRepository = new IpLocRepository((DataSource)dataSource);
        ResourceConfig application = new ResourceConfig().register(CorsFilter.class).register(IpLocResource.class).register(ClassPathResource.class).register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind("iploc").to(String.class).named("directory");
                this.bind("index.html").to(String.class).named("index");
                this.bind(ipLocRepository).to(IpLocRepository.class).named("iplocRepository");
            }
        });
        BlockingStreamingHttpService httpService = new HttpJerseyRouterBuilder().buildBlockingStreaming((Application)application);
        HttpServerContext serverContext = HttpServers.forPort((int)this.port).listenBlockingStreamingAndAwait(httpService);
        logger.info("Listening on {}", (Object)serverContext.listenAddress());
        serverContext.awaitShutdown();
        return 0;
    }
}

