/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.util.format.FormatElement;
import org.apache.calcite.util.format.FormatElementEnum;
import org.apache.calcite.util.format.FormatModel;

public class FormatModels {
    public static final FormatModel DEFAULT;
    public static final FormatModel BIG_QUERY;

    private FormatModels() {
    }

    private static Pattern regexFromMap(Map<String, FormatElement> elementMap) {
        StringBuilder regex = new StringBuilder();
        for (String key : elementMap.keySet()) {
            regex.append("(").append(Pattern.quote(key)).append(")|");
        }
        regex.setLength(regex.length() - 1);
        return Pattern.compile(regex.toString());
    }

    public static FormatModel create(Map<String, FormatElement> elementMap) {
        Pattern pattern = FormatModels.regexFromMap(elementMap);
        return new FormatModelImpl(pattern, elementMap);
    }

    public static FormatElement literalElement(String literal) {
        return new FormatModelElementLiteral(literal);
    }

    public static FormatElement compositeElement(String description, FormatElement ... fmtElements) {
        return new CompositeFormatElement((List<FormatElement>)ImmutableList.copyOf((Object[])fmtElements), description);
    }

    static {
        HashMap<String, FormatElement> map = new HashMap<String, FormatElement>();
        for (FormatElementEnum fe : FormatElementEnum.values()) {
            map.put(fe.toString(), fe);
        }
        DEFAULT = FormatModels.create(map);
        map.clear();
        map.put("%A", FormatElementEnum.DAY);
        map.put("%a", FormatElementEnum.DY);
        map.put("%B", FormatElementEnum.MONTH);
        map.put("%b", FormatElementEnum.MON);
        map.put("%c", FormatModels.compositeElement("The date and time representation (English);", FormatElementEnum.DY, FormatModels.literalElement(" "), FormatElementEnum.MON, FormatModels.literalElement(" "), FormatElementEnum.DD, FormatModels.literalElement(" "), FormatElementEnum.HH24, FormatModels.literalElement(":"), FormatElementEnum.MI, FormatModels.literalElement(":"), FormatElementEnum.SS, FormatModels.literalElement(" "), FormatElementEnum.YYYY));
        map.put("%d", FormatElementEnum.DD);
        map.put("%E1S", FormatElementEnum.FF1);
        map.put("%E2S", FormatElementEnum.FF2);
        map.put("%E3S", FormatElementEnum.FF3);
        map.put("%E4S", FormatElementEnum.FF4);
        map.put("%E5S", FormatElementEnum.FF5);
        map.put("%E*S", FormatElementEnum.FF6);
        map.put("%H", FormatElementEnum.HH24);
        map.put("%j", FormatElementEnum.DDD);
        map.put("%M", FormatElementEnum.MI);
        map.put("%m", FormatElementEnum.MM);
        map.put("%Q", FormatElementEnum.Q);
        map.put("%R", FormatModels.compositeElement("The time in the format %H:%M", FormatElementEnum.HH24, FormatModels.literalElement(":"), FormatElementEnum.MI));
        map.put("%S", FormatElementEnum.SS);
        map.put("%u", FormatElementEnum.D);
        map.put("%V", FormatElementEnum.IW);
        map.put("%W", FormatElementEnum.WW);
        map.put("%x", FormatModels.compositeElement("The date representation in MM/DD/YY format", FormatElementEnum.MM, FormatModels.literalElement("/"), FormatElementEnum.DD, FormatModels.literalElement("/"), FormatElementEnum.YY));
        map.put("%Y", FormatElementEnum.YYYY);
        map.put("%y", FormatElementEnum.YY);
        map.put("%Z", FormatElementEnum.TZR);
        BIG_QUERY = FormatModels.create(map);
    }

    private static class CompositeFormatElement
    implements FormatElement {
        private final String description;
        private final List<FormatElement> formatElements;

        CompositeFormatElement(List<FormatElement> formatElements, String description) {
            this.formatElements = ImmutableList.copyOf(formatElements);
            this.description = Objects.requireNonNull(description, "description");
        }

        @Override
        public String format(Date date) {
            StringBuilder buf = new StringBuilder();
            this.flatten(ele -> buf.append(ele.format(date)));
            return buf.toString();
        }

        @Override
        public void flatten(Consumer<FormatElement> consumer) {
            this.formatElements.forEach(consumer);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private static class FormatModelElementLiteral
    implements FormatElement {
        private final String literal;

        FormatModelElementLiteral(String literal) {
            this.literal = Objects.requireNonNull(literal, "literal");
        }

        @Override
        public String format(Date date) {
            return this.literal;
        }

        @Override
        public String getDescription() {
            return "Represents literal text in a format string";
        }

        public String toString() {
            return this.literal;
        }
    }

    private static class FormatModelImpl
    implements FormatModel {
        final Pattern pattern;
        final Map<String, FormatElement> elementMap;
        final Map<String, List<FormatElement>> memoizedElements = new ConcurrentHashMap<String, List<FormatElement>>();

        FormatModelImpl(Pattern pattern, Map<String, FormatElement> elementMap) {
            this.pattern = Objects.requireNonNull(pattern, "pattern");
            this.elementMap = ImmutableMap.copyOf(elementMap);
        }

        @Override
        public Map<String, FormatElement> getElementMap() {
            return this.elementMap;
        }

        private List<FormatElement> internalParse(String format) {
            String literal;
            ImmutableList.Builder elements = ImmutableList.builder();
            Matcher matcher = this.pattern.matcher(format);
            int i = 0;
            while (matcher.find()) {
                literal = format.substring(i, matcher.start());
                if (!literal.isEmpty()) {
                    elements.add((Object)FormatModels.literalElement(literal));
                }
                String key = matcher.group();
                elements.add((Object)this.getElementMap().getOrDefault(key, FormatModels.literalElement(key)));
                i = matcher.end();
            }
            literal = format.substring(i);
            if (!literal.isEmpty()) {
                elements.add((Object)FormatModels.literalElement(literal));
            }
            return elements.build();
        }

        @Override
        public List<FormatElement> parse(String format) {
            return this.memoizedElements.computeIfAbsent(format, this::internalParse);
        }
    }
}

