/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseFactory;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpService;
import java.util.Objects;

final class StreamingHttpServiceToHttpService
implements HttpService {
    private final StreamingHttpService original;

    StreamingHttpServiceToHttpService(StreamingHttpService original) {
        this.original = Objects.requireNonNull(original);
    }

    @Override
    public Single<HttpResponse> handle(HttpServiceContext ctx, HttpRequest request, HttpResponseFactory responseFactory) {
        return this.original.handle(ctx, request.toStreamingRequest(), ctx.streamingResponseFactory()).flatMap(StreamingHttpResponse::toResponse);
    }

    @Override
    public Completable closeAsync() {
        return this.original.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.original.closeAsyncGracefully();
    }
}

