/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.PayloadInfo;

final class DefaultPayloadInfo
implements PayloadInfo {
    private static final byte SAFE_TO_AGGREGATE = 1;
    private static final byte MAY_HAVE_TRAILERS = 2;
    private static final byte GENERIC_TYPE_BUFFER = 4;
    private static final byte EMPTY = 8;
    private byte flags;

    DefaultPayloadInfo() {
    }

    DefaultPayloadInfo(PayloadInfo from) {
        this.setAll(from);
    }

    DefaultPayloadInfo setAll(PayloadInfo from) {
        if (from instanceof DefaultPayloadInfo) {
            this.flags = ((DefaultPayloadInfo)from).flags;
        } else {
            this.setEmpty(from.isEmpty());
            this.setSafeToAggregate(from.isSafeToAggregate());
            this.setMayHaveTrailers(from.mayHaveTrailers());
            this.setGenericTypeBuffer(from.isGenericTypeBuffer());
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.isSet((byte)8);
    }

    @Override
    public boolean isSafeToAggregate() {
        return this.isSet((byte)1);
    }

    @Override
    public boolean mayHaveTrailers() {
        return this.isSet((byte)2);
    }

    @Override
    public boolean isGenericTypeBuffer() {
        return this.isSet((byte)4);
    }

    DefaultPayloadInfo setEmpty(boolean empty) {
        return this.set((byte)8, empty);
    }

    DefaultPayloadInfo setSafeToAggregate(boolean safeToAggregate) {
        return this.set((byte)1, safeToAggregate);
    }

    DefaultPayloadInfo setMayHaveTrailers(boolean mayHaveTrailers) {
        return this.set((byte)2, mayHaveTrailers);
    }

    DefaultPayloadInfo setGenericTypeBuffer(boolean genericTypeBuffer) {
        return this.set((byte)4, genericTypeBuffer);
    }

    DefaultPayloadInfo setMayHaveTrailersAndGenericTypeBuffer(boolean mayHaveTrailers) {
        this.flags = mayHaveTrailers ? (byte)((this.flags | 2) & 0xFFFFFFFB) : (byte)((this.flags | 4) & 0xFFFFFFFD);
        return this;
    }

    static DefaultPayloadInfo forTransportReceive(boolean requireTrailerHeader, HttpProtocolVersion version, HttpHeaders headers) {
        return new DefaultPayloadInfo().setMayHaveTrailers((version.major() > 1 || HttpProtocolVersion.h1TrailersSupported(version) && HeaderUtils.isTransferEncodingChunked(headers)) && (!requireTrailerHeader || headers.contains(HttpHeaderNames.TRAILER)));
    }

    static DefaultPayloadInfo forUserCreated() {
        return new DefaultPayloadInfo().setGenericTypeBuffer(true);
    }

    private boolean isSet(byte expected) {
        return (this.flags & expected) == expected;
    }

    private DefaultPayloadInfo set(byte flag, boolean enabled) {
        this.flags = enabled ? (byte)(this.flags | flag) : (byte)(this.flags & ~flag);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPayloadInfo that = (DefaultPayloadInfo)o;
        return this.flags == that.flags;
    }

    public int hashCode() {
        return this.flags;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{isEmpty=" + this.isEmpty() + ", isSafeToAggregate=" + this.isSafeToAggregate() + ", mayHaveTrailers=" + this.mayHaveTrailers() + ", isGenericTypeBuffer=" + this.isGenericTypeBuffer() + '}';
    }
}

