/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.raft;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class PartitionSnapshotInfo {
    private final long lastAppliedIndex;
    private final long lastAppliedTerm;
    @Nullable
    private final LeaseInfo leaseInfo;
    private final byte[] configurationBytes;
    private final Set<Integer> tableIds;

    public PartitionSnapshotInfo(long lastAppliedIndex, long lastAppliedTerm, @Nullable LeaseInfo leaseInfo, byte[] configurationBytes, Collection<Integer> tableIds) {
        this.lastAppliedIndex = lastAppliedIndex;
        this.lastAppliedTerm = lastAppliedTerm;
        this.leaseInfo = leaseInfo;
        this.configurationBytes = configurationBytes;
        this.tableIds = Set.copyOf(tableIds);
    }

    public long lastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    public long lastAppliedTerm() {
        return this.lastAppliedTerm;
    }

    @Nullable
    public LeaseInfo leaseInfo() {
        return this.leaseInfo;
    }

    public byte[] configurationBytes() {
        return this.configurationBytes;
    }

    public Set<Integer> tableIds() {
        return this.tableIds;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionSnapshotInfo that = (PartitionSnapshotInfo)o;
        return this.lastAppliedIndex == that.lastAppliedIndex && this.lastAppliedTerm == that.lastAppliedTerm && Objects.equals(this.leaseInfo, that.leaseInfo) && Arrays.equals(this.configurationBytes, that.configurationBytes) && this.tableIds.equals(that.tableIds);
    }

    public int hashCode() {
        int result = Long.hashCode(this.lastAppliedIndex);
        result = 31 * result + Long.hashCode(this.lastAppliedTerm);
        result = 31 * result + Objects.hashCode(this.leaseInfo);
        result = 31 * result + Arrays.hashCode(this.configurationBytes);
        result = 31 * result + this.tableIds.hashCode();
        return result;
    }

    public String toString() {
        return S.toString(this);
    }
}

