/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessageBuilder;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ZonePartitionIdMessageImpl
implements ZonePartitionIdMessage,
Cloneable {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 43;
    @IgniteToStringInclude
    private final int partitionId;
    @IgniteToStringInclude
    private final int zoneId;

    private ZonePartitionIdMessageImpl(int partitionId, int zoneId) {
        this.partitionId = partitionId;
        this.zoneId = zoneId;
    }

    @Override
    public int partitionId() {
        return this.partitionId;
    }

    @Override
    public int zoneId() {
        return this.zoneId;
    }

    public MessageSerializer serializer() {
        return ZonePartitionIdMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(ZonePartitionIdMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 43;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ZonePartitionIdMessageImpl otherMessage = (ZonePartitionIdMessageImpl)other;
        return this.partitionId == otherMessage.partitionId && this.zoneId == otherMessage.zoneId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.partitionId, this.zoneId);
        return result;
    }

    public ZonePartitionIdMessageImpl clone() {
        try {
            return (ZonePartitionIdMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ZonePartitionIdMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ZonePartitionIdMessageBuilder {
        private int partitionId;
        private int zoneId;

        private Builder() {
        }

        @Override
        public ZonePartitionIdMessageBuilder partitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public ZonePartitionIdMessageBuilder zoneId(int zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        @Override
        public int partitionId() {
            return this.partitionId;
        }

        @Override
        public int zoneId() {
            return this.zoneId;
        }

        @Override
        public ZonePartitionIdMessage build() {
            return new ZonePartitionIdMessageImpl(this.partitionId, this.zoneId);
        }
    }
}

