/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.UUID;
import org.apache.ignite.internal.lang.InternalTuple;

abstract class AbstractProjectedTuple
implements InternalTuple {
    protected InternalTuple delegate;
    protected int[] projection;
    private boolean normalized = false;

    AbstractProjectedTuple(InternalTuple delegate, int[] projection) {
        this.delegate = delegate;
        this.projection = projection;
    }

    public int elementCount() {
        return this.projection.length;
    }

    public boolean hasNullValue(int col) {
        return this.delegate.hasNullValue(this.projection[col]);
    }

    public boolean booleanValue(int col) {
        return this.delegate.booleanValue(this.projection[col]);
    }

    public Boolean booleanValueBoxed(int col) {
        return this.delegate.booleanValueBoxed(this.projection[col]);
    }

    public byte byteValue(int col) {
        return this.delegate.byteValue(this.projection[col]);
    }

    public Byte byteValueBoxed(int col) {
        return this.delegate.byteValueBoxed(this.projection[col]);
    }

    public short shortValue(int col) {
        return this.delegate.shortValue(this.projection[col]);
    }

    public Short shortValueBoxed(int col) {
        return this.delegate.shortValueBoxed(this.projection[col]);
    }

    public int intValue(int col) {
        return this.delegate.intValue(this.projection[col]);
    }

    public Integer intValueBoxed(int col) {
        return this.delegate.intValueBoxed(this.projection[col]);
    }

    public long longValue(int col) {
        return this.delegate.longValue(this.projection[col]);
    }

    public Long longValueBoxed(int col) {
        return this.delegate.longValueBoxed(this.projection[col]);
    }

    public float floatValue(int col) {
        return this.delegate.floatValue(this.projection[col]);
    }

    public Float floatValueBoxed(int col) {
        return this.delegate.floatValueBoxed(this.projection[col]);
    }

    public double doubleValue(int col) {
        return this.delegate.doubleValue(this.projection[col]);
    }

    public Double doubleValueBoxed(int col) {
        return this.delegate.doubleValueBoxed(this.projection[col]);
    }

    public BigDecimal decimalValue(int col, int decimalScale) {
        return this.delegate.decimalValue(this.projection[col], decimalScale);
    }

    public String stringValue(int col) {
        return this.delegate.stringValue(this.projection[col]);
    }

    public byte[] bytesValue(int col) {
        return this.delegate.bytesValue(this.projection[col]);
    }

    public UUID uuidValue(int col) {
        return this.delegate.uuidValue(this.projection[col]);
    }

    public LocalDate dateValue(int col) {
        return this.delegate.dateValue(this.projection[col]);
    }

    public LocalTime timeValue(int col) {
        return this.delegate.timeValue(this.projection[col]);
    }

    public LocalDateTime dateTimeValue(int col) {
        return this.delegate.dateTimeValue(this.projection[col]);
    }

    public Instant timestampValue(int col) {
        return this.delegate.timestampValue(this.projection[col]);
    }

    public Period periodValue(int col) {
        return this.delegate.periodValue(this.projection[col]);
    }

    public Duration durationValue(int col) {
        return this.delegate.durationValue(this.projection[col]);
    }

    public ByteBuffer byteBuffer() {
        this.normalizeIfNeeded();
        return this.delegate.byteBuffer();
    }

    protected abstract void normalize();

    private void normalizeIfNeeded() {
        if (this.normalized) {
            return;
        }
        this.normalize();
        this.normalized = true;
    }
}

