/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.proto.ProtocolVersion;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.jdbc.ConnectionPropertiesImpl;
import org.apache.ignite.internal.jdbc.JdbcConnection;

@AutoService(value={Driver.class})
public class IgniteJdbcDriver
implements Driver {
    private static Driver instance;
    private static final int MAJOR_VER;
    private static final int MINOR_VER;
    private final HybridTimestampTracker observableTimeTracker = HybridTimestampTracker.atomicTracker(null);

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        ConnectionPropertiesImpl connProps = new ConnectionPropertiesImpl();
        connProps.init(url, props);
        return new JdbcConnection(connProps, this.observableTimeTracker);
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith("jdbc:ignite:thin://");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        ConnectionPropertiesImpl connProps = new ConnectionPropertiesImpl();
        connProps.init(url, info);
        return connProps.getDriverPropertyInfo();
    }

    @Override
    public int getMajorVersion() {
        return MAJOR_VER;
    }

    @Override
    public int getMinorVersion() {
        return MINOR_VER;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("java.util.logging is not used.");
    }

    private static synchronized void register() {
        if (IgniteJdbcDriver.isRegistered()) {
            throw new RuntimeException("Driver is already registered. It can only be registered once.");
        }
        try {
            IgniteJdbcDriver registeredDriver = new IgniteJdbcDriver();
            DriverManager.registerDriver(registeredDriver);
            instance = registeredDriver;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to register Ignite JDBC driver.", e);
        }
    }

    private static boolean isRegistered() {
        return instance != null;
    }

    static {
        IgniteJdbcDriver.register();
        MAJOR_VER = ProtocolVersion.LATEST_VER.major();
        MINOR_VER = ProtocolVersion.LATEST_VER.minor();
    }
}

