/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.trait;

import java.util.Objects;
import org.apache.calcite.rel.RelDistribution;

public abstract class DistributionFunction {
    private String name;

    private DistributionFunction() {
    }

    public abstract RelDistribution.Type type();

    public final String name() {
        if (this.name != null) {
            return this.name;
        }
        this.name = this.name0().intern();
        return this.name;
    }

    public boolean affinity() {
        return false;
    }

    public static DistributionFunction affinity(int tableId, Object zoneId) {
        return new AffinityDistribution(tableId, zoneId);
    }

    protected String name0() {
        return this.type().shortName;
    }

    public final int hashCode() {
        return Objects.hashCode(this.name());
    }

    public final boolean equals(Object obj) {
        if (obj instanceof DistributionFunction) {
            return this.name() == ((DistributionFunction)obj).name();
        }
        return false;
    }

    public final String toString() {
        return this.name();
    }

    public static DistributionFunction any() {
        return AnyDistribution.INSTANCE;
    }

    public static DistributionFunction broadcast() {
        return BroadcastDistribution.INSTANCE;
    }

    public static DistributionFunction singleton() {
        return SingletonDistribution.INSTANCE;
    }

    public static DistributionFunction random() {
        return RandomDistribution.INSTANCE;
    }

    public static DistributionFunction hash() {
        return HashDistribution.INSTANCE;
    }

    public static DistributionFunction identity() {
        return IdentityDistribution.INSTANCE;
    }

    public static boolean satisfy(DistributionFunction f0, DistributionFunction f1) {
        if (f0 == f1 || f0.name() == f1.name()) {
            return true;
        }
        return f0 instanceof AffinityDistribution && f1 instanceof AffinityDistribution && Objects.equals(((AffinityDistribution)f0).zoneId(), ((AffinityDistribution)f1).zoneId());
    }

    public static final class AffinityDistribution
    extends HashDistribution {
        private final int tableId;
        private final Object zoneId;

        private AffinityDistribution(int tableId, Object zoneId) {
            this.zoneId = zoneId;
            this.tableId = tableId;
        }

        @Override
        public boolean affinity() {
            return true;
        }

        public int tableId() {
            return this.tableId;
        }

        public Object zoneId() {
            return this.zoneId;
        }

        @Override
        protected String name0() {
            return "affinity[tableId=" + this.tableId + ", zoneId=" + String.valueOf(this.zoneId) + "]";
        }
    }

    private static final class AnyDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new AnyDistribution();

        private AnyDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.ANY;
        }
    }

    private static final class BroadcastDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new BroadcastDistribution();

        private BroadcastDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.BROADCAST_DISTRIBUTED;
        }
    }

    private static final class SingletonDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new SingletonDistribution();

        private SingletonDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.SINGLETON;
        }
    }

    private static final class RandomDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new RandomDistribution();

        private RandomDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.RANDOM_DISTRIBUTED;
        }
    }

    private static class HashDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new HashDistribution();

        private HashDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.HASH_DISTRIBUTED;
        }
    }

    public static final class IdentityDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new IdentityDistribution();

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.HASH_DISTRIBUTED;
        }

        @Override
        protected String name0() {
            return "identity";
        }
    }
}

