/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.table.Table;

public class ClientTables
implements IgniteTables {
    private final ReliableChannel ch;
    private final MarshallersProvider marshallers;

    public ClientTables(ReliableChannel ch, MarshallersProvider marshallers) {
        this.ch = ch;
        this.marshallers = marshallers;
    }

    public List<Table> tables() {
        return (List)ViewUtils.sync(this.tablesAsync());
    }

    public CompletableFuture<List<Table>> tablesAsync() {
        return this.ch.serviceAsync(3, r -> {
            ClientMessageUnpacker in = r.in();
            int cnt = in.unpackInt();
            ArrayList<ClientTable> res = new ArrayList<ClientTable>(cnt);
            for (int i = 0; i < cnt; ++i) {
                res.add(new ClientTable(this.ch, this.marshallers, in.unpackInt(), in.unpackString()));
            }
            return res;
        });
    }

    public Table table(String name) {
        return (Table)ViewUtils.sync(this.tableAsync(name));
    }

    public CompletableFuture<Table> tableAsync(String name) {
        Objects.requireNonNull(name);
        return this.ch.serviceAsync(4, w -> w.out().packString(name), r -> r.in().tryUnpackNil() ? null : new ClientTable(this.ch, this.marshallers, r.in().unpackInt(), r.in().unpackString()));
    }
}

