/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.eventlog.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.eventlog.api.EventChannel;
import org.apache.ignite.internal.eventlog.config.schema.ChannelView;
import org.apache.ignite.internal.eventlog.config.schema.EventLogConfiguration;
import org.apache.ignite.internal.eventlog.impl.ChannelRegistry;
import org.apache.ignite.internal.eventlog.impl.EventChannelImpl;
import org.apache.ignite.internal.eventlog.impl.SinkRegistry;
import org.jetbrains.annotations.Nullable;

class ConfigurationBasedChannelRegistry
implements ChannelRegistry {
    private volatile Map<String, EventChannel> cache = new HashMap<String, EventChannel>();
    private volatile Map<String, Set<EventChannel>> typeCache = new HashMap<String, Set<EventChannel>>();
    private final SinkRegistry sinkRegistry;

    ConfigurationBasedChannelRegistry(EventLogConfiguration cfg, SinkRegistry sinkRegistry) {
        this.sinkRegistry = sinkRegistry;
        cfg.channels().listen((ConfigurationListener)new CacheUpdater());
    }

    @Override
    public EventChannel getByName(String name) {
        return this.cache.get(name);
    }

    @Override
    @Nullable
    public Set<EventChannel> findAllChannelsByEventType(String igniteEventType) {
        return this.typeCache.get(igniteEventType);
    }

    private class CacheUpdater
    implements ConfigurationListener<NamedListView<ChannelView>> {
        private CacheUpdater() {
        }

        public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<NamedListView<ChannelView>> ctx) {
            NamedListView newListValue = (NamedListView)ctx.newValue();
            HashMap<String, EventChannel> newCache = new HashMap<String, EventChannel>();
            HashMap<String, Set<EventChannel>> newTypeCache = new HashMap<String, Set<EventChannel>>();
            newListValue.forEach(view -> {
                if (view.enabled()) {
                    EventChannel channel = this.createChannel((ChannelView)view);
                    newCache.put(view.name(), channel);
                    for (String eventType : view.events()) {
                        newTypeCache.computeIfAbsent(eventType.trim(), t -> new HashSet()).add(channel);
                    }
                }
            });
            ConfigurationBasedChannelRegistry.this.cache = newCache;
            ConfigurationBasedChannelRegistry.this.typeCache = newTypeCache;
            return CompletableFuture.completedFuture(null);
        }

        private EventChannel createChannel(ChannelView view) {
            Set<String> types = Arrays.stream(view.events()).map(String::trim).collect(Collectors.toSet());
            return new EventChannelImpl(view.name(), types, ConfigurationBasedChannelRegistry.this.sinkRegistry);
        }
    }
}

