/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.tree.IgniteTree;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite.internal.storage.pagememory.mv.gc.GcQueue;
import org.jetbrains.annotations.Nullable;

class AddWriteCommittedInvokeClosure
implements IgniteTree.InvokeClosure<VersionChain> {
    private final RowId rowId;
    @Nullable
    private final BinaryRow row;
    private final HybridTimestamp commitTimestamp;
    private final AbstractPageMemoryMvPartitionStorage storage;
    private final GcQueue gcQueue;
    private IgniteTree.OperationType operationType;
    @Nullable
    private VersionChain newRow;
    private long rowLinkForAddToGcQueue = 0L;
    @Nullable
    private RowVersion prevRowVersion;

    AddWriteCommittedInvokeClosure(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp, AbstractPageMemoryMvPartitionStorage storage) {
        this.rowId = rowId;
        this.row = row;
        this.commitTimestamp = commitTimestamp;
        this.storage = storage;
        this.gcQueue = storage.renewableState.gcQueue();
    }

    public void call(@Nullable VersionChain oldRow) throws IgniteInternalCheckedException {
        if (oldRow != null && oldRow.isUncommitted()) {
            throw new StorageException("Write intent exists: [rowId={}, {}]", new Object[]{oldRow.rowId(), this.storage.createStorageInfo()});
        }
        if (this.row == null && oldRow == null) {
            this.operationType = IgniteTree.OperationType.NOOP;
            return;
        }
        if (oldRow == null) {
            this.operationType = IgniteTree.OperationType.PUT;
            RowVersion newVersion = this.insertCommittedRowVersion(this.row, this.commitTimestamp, 0L);
            this.newRow = VersionChain.createCommitted(this.rowId, newVersion.link(), newVersion.nextLink());
        } else {
            this.prevRowVersion = this.storage.readRowVersion(oldRow.headLink(), AbstractPageMemoryMvPartitionStorage.DONT_LOAD_VALUE);
            if (this.prevRowVersion.isTombstone() && this.row == null) {
                this.operationType = IgniteTree.OperationType.NOOP;
            } else {
                this.operationType = IgniteTree.OperationType.PUT;
                RowVersion newVersion = this.insertCommittedRowVersion(this.row, this.commitTimestamp, oldRow.headLink());
                this.newRow = VersionChain.createCommitted(this.rowId, newVersion.link(), newVersion.nextLink());
                this.rowLinkForAddToGcQueue = newVersion.link();
            }
        }
    }

    @Nullable
    public VersionChain newRow() {
        assert (this.operationType != IgniteTree.OperationType.PUT ? this.newRow == null : this.newRow != null) : "newRow=" + String.valueOf(this.newRow) + ", op=" + String.valueOf(this.operationType);
        return this.newRow;
    }

    public IgniteTree.OperationType operationType() {
        assert (this.operationType != null);
        return this.operationType;
    }

    private RowVersion insertCommittedRowVersion(@Nullable BinaryRow row, HybridTimestamp commitTimestamp, long nextPartitionlessLink) {
        RowVersion rowVersion = new RowVersion(this.storage.partitionId, commitTimestamp, nextPartitionlessLink, row);
        this.storage.insertRowVersion(rowVersion);
        return rowVersion;
    }

    void afterCompletion() {
        if (this.rowLinkForAddToGcQueue != 0L) {
            this.gcQueue.add(this.rowId, this.commitTimestamp, this.rowLinkForAddToGcQueue);
        }
        if (this.operationType == IgniteTree.OperationType.PUT) {
            if (this.prevRowVersion == null || this.prevRowVersion.isTombstone()) {
                if (this.row != null) {
                    this.storage.incrementEstimatedSize();
                }
            } else if (this.row == null) {
                this.storage.decrementEstimatedSize();
            }
        }
    }
}

