/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.criteria;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.internal.table.criteria.ColumnValidator;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;
import org.apache.ignite.table.criteria.Column;
import org.apache.ignite.table.criteria.Criteria;
import org.apache.ignite.table.criteria.CriteriaVisitor;
import org.apache.ignite.table.criteria.Expression;
import org.apache.ignite.table.criteria.Operator;
import org.apache.ignite.table.criteria.Parameter;

public class SqlSerializer
implements CriteriaVisitor<Void> {
    private static final Map<Operator, String> ELEMENT_TEMPLATES = Map.of(Operator.EQ, "{0} = {1}", Operator.NOT_EQ, "{0} <> {1}", Operator.IS_NULL, "{0} IS NULL", Operator.IS_NOT_NULL, "{0} IS NOT NULL", Operator.GOE, "{0} >= {1}", Operator.GT, "{0} > {1}", Operator.LOE, "{0} <= {1}", Operator.LT, "{0} < {1}", Operator.NOT, "NOT ({0})");
    private final Pattern pattern = Pattern.compile("\\{(\\d+)\\}");
    private final StringBuilder builder = new StringBuilder(128);
    private final List<Object> arguments = new LinkedList<Object>();

    public Object[] getArguments() {
        return this.arguments.toArray(new Object[0]);
    }

    @Override
    public <T> void visit(Parameter<T> argument, @Nullable Void context) {
        this.append("?");
        this.arguments.add(argument.getValue());
    }

    @Override
    public <T> void visit(Column column, @Nullable Void context) {
        this.append(IgniteNameUtils.quoteIfNeeded(column.getName()));
    }

    @Override
    public <T> void visit(Expression expression, @Nullable Void context) {
        Operator operator = expression.getOperator();
        Criteria[] elements = expression.getElements();
        if (operator == Operator.AND || operator == Operator.OR) {
            this.append(operator == Operator.AND ? ") AND (" : ") OR (", "(", ")", elements, context);
        } else if (operator == Operator.IN || operator == Operator.NOT_IN) {
            elements[0].accept(this, context);
            this.append(operator == Operator.IN ? " IN " : " NOT IN ");
            Criteria[] tail = Arrays.copyOfRange(elements, 1, elements.length);
            this.append(", ", "(", ")", tail, context);
        } else {
            String template = ELEMENT_TEMPLATES.get((Object)operator);
            int end = 0;
            Matcher matcher = this.pattern.matcher(template);
            while (matcher.find()) {
                if (matcher.start() > end) {
                    this.append(template.substring(end, matcher.start()));
                }
                int index = Integer.parseInt(matcher.group(1));
                elements[index].accept(this, context);
                end = matcher.end();
            }
            if (end < template.length()) {
                this.append(template.substring(end));
            }
        }
    }

    @Override
    public <T> void visit(Criteria criteria, @Nullable Void context) {
        criteria.accept(this, context);
    }

    public String toString() {
        return this.builder.toString();
    }

    private SqlSerializer append(String str) {
        this.builder.append(str);
        return this;
    }

    private void append(String delimiter, String prefix, String suffix, Criteria[] elements, @Nullable Void context) {
        if (elements.length > 1) {
            this.append(prefix);
        }
        for (int i = 0; i < elements.length; ++i) {
            elements[i].accept(this, context);
            if (i >= elements.length - 1) continue;
            this.append(delimiter);
        }
        if (elements.length > 1) {
            this.append(suffix);
        }
    }

    public static class Builder {
        @Nullable
        private String tableName;
        @Nullable
        private Collection<String> columnNames;
        @Nullable
        private String indexName;
        @Nullable
        private Criteria where;

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder columns(Collection<String> columnNames) {
            this.columnNames = columnNames;
            return this;
        }

        public Builder indexName(@Nullable String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder where(@Nullable Criteria where) {
            this.where = where;
            return this;
        }

        public SqlSerializer build() {
            if (StringUtils.nullOrBlank(this.tableName)) {
                throw new IllegalArgumentException("Table name can't be null or blank");
            }
            SqlSerializer ser = new SqlSerializer().append("SELECT");
            if (!StringUtils.nullOrBlank(this.indexName)) {
                if (!IgniteNameUtils.canonicalOrSimpleName(this.indexName)) {
                    throw new IllegalArgumentException("Index name must be alphanumeric with underscore and start with letter. Was: " + this.indexName);
                }
                ser.append(" /*+ FORCE_INDEX(").append(Builder.normalizeIndexName(this.indexName)).append(") */");
            }
            ser.append(" * FROM ").append(IgniteNameUtils.quoteIfNeeded(this.tableName));
            if (this.where != null) {
                if (CollectionUtils.nullOrEmpty(this.columnNames)) {
                    throw new IllegalArgumentException("The columns of the table must be specified to validate input");
                }
                ColumnValidator.INSTANCE.visit(this.where, this.columnNames);
                ser.append(" WHERE ");
                ser.visit(this.where, null);
            }
            return ser;
        }

        private static String normalizeIndexName(String name) {
            return IgniteNameUtils.quote(name.toUpperCase(Locale.ROOT));
        }
    }
}

