/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.hlc;

import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import org.apache.ignite.internal.lang.JavaLoggerFormatter;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.VarIntUtils;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public final class HybridTimestamp
implements Comparable<HybridTimestamp>,
Serializable {
    private static final long serialVersionUID = -4285668148196042529L;
    public static final long NULL_HYBRID_TIMESTAMP = 0L;
    public static final int LOGICAL_TIME_BITS_SIZE = 16;
    private static final long LOGICAL_TIME_MASK = 65535L;
    static final int PHYSICAL_TIME_BITS_SIZE = 48;
    public static final int HYBRID_TIMESTAMP_SIZE = 8;
    public static final HybridTimestamp MAX_VALUE = new HybridTimestamp(Long.MAX_VALUE);
    public static final HybridTimestamp MIN_VALUE = new HybridTimestamp(0L, 1);
    private final long time;

    public HybridTimestamp(long physical, int logical) {
        if (physical < 0L || physical >= 0x1000000000000L) {
            throw new IllegalArgumentException("Physical time is out of bounds: " + physical);
        }
        if (logical < 0 || (long)logical >= 65536L) {
            throw new IllegalArgumentException("Logical time is out of bounds: " + logical);
        }
        this.time = physical << 16 | (long)logical;
        if (this.time <= 0L) {
            throw new IllegalArgumentException("Time is out of bounds: " + this.time);
        }
    }

    private HybridTimestamp(long time) {
        this.time = time;
        if (time <= 0L) {
            throw new IllegalArgumentException("Time is out of bounds: " + time);
        }
    }

    @Nullable
    public static HybridTimestamp nullableHybridTimestamp(long time) {
        return time == 0L ? null : new HybridTimestamp(time);
    }

    public static HybridTimestamp hybridTimestamp(long time) {
        return new HybridTimestamp(time);
    }

    public static long hybridTimestampToLong(@Nullable HybridTimestamp timestamp) {
        return timestamp == null ? 0L : timestamp.time;
    }

    public static HybridTimestamp fromBytes(byte[] bytes) {
        long physicalHigh = Integer.reverseBytes(ByteUtils.bytesToInt(bytes, 0));
        int physicalLow = Short.reverseBytes(ByteUtils.bytesToShort(bytes, 4)) & 0xFFFF;
        long physical = physicalHigh << 16 | (long)physicalLow;
        int logical = (int)VarIntUtils.readVarInt(bytes, 6);
        assert (physical != 0L || logical != 0);
        return new HybridTimestamp(physical, logical);
    }

    public static HybridTimestamp max(HybridTimestamp ... times) {
        assert (times != null);
        assert (times.length > 0);
        HybridTimestamp maxTime = times[0];
        for (int i = 1; i < times.length; ++i) {
            if (maxTime.compareTo(times[i]) >= 0) continue;
            maxTime = times[i];
        }
        return maxTime;
    }

    public long getPhysical() {
        return this.time >>> 16;
    }

    public int getLogical() {
        return (int)(this.time & 0xFFFFL);
    }

    public long longValue() {
        return this.time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.time == ((HybridTimestamp)o).time;
    }

    public int hashCode() {
        return Long.hashCode(this.time);
    }

    @Override
    public int compareTo(HybridTimestamp other) {
        return Long.compare(this.time, other.time);
    }

    public String toString() {
        String formattedTime = JavaLoggerFormatter.DATE_FORMATTER.format(Instant.ofEpochMilli(this.getPhysical()).atOffset(ZoneOffset.UTC));
        return String.format("HybridTimestamp [physical=%s, logical=%d, composite=%d]", formattedTime, this.getLogical(), this.time);
    }

    public HybridTimestamp addPhysicalTime(long millis) {
        if (millis >= 0x1000000000000L) {
            throw new IllegalArgumentException("Physical time is out of bounds: " + millis);
        }
        return new HybridTimestamp(this.time + (millis << 16));
    }

    public HybridTimestamp tick() {
        return HybridTimestamp.hybridTimestamp(this.time + 1L);
    }

    public HybridTimestamp subtractPhysicalTime(long millis) {
        if (millis >= 0x1000000000000L) {
            throw new IllegalArgumentException("Physical time is out of bounds: " + millis);
        }
        return new HybridTimestamp(this.time - (millis << 16));
    }

    public HybridTimestamp roundUpToPhysicalTick() {
        if (this.getLogical() == 0) {
            return this;
        }
        return new HybridTimestamp(this.getPhysical() + 1L, 0);
    }

    public byte[] toBytes() {
        long physical = this.getPhysical();
        int logical = this.getLogical();
        byte[] bytes = new byte[6 + VarIntUtils.varIntLength(logical)];
        ByteUtils.putIntToBytes(Integer.reverseBytes((int)(physical >> 16)), bytes, 0);
        ByteUtils.putShortToBytes(Short.reverseBytes((short)(physical & 0xFFFFL)), bytes, 4);
        VarIntUtils.putVarIntToBytes(logical, bytes, 6);
        return bytes;
    }

    public void writeTo(IgniteDataOutput out) throws IOException {
        long physical = this.getPhysical();
        out.writeInt((int)(physical >> 16));
        out.writeShort((int)(physical & 0xFFFFL));
        out.writeVarInt(this.getLogical());
    }

    public static void write(@Nullable HybridTimestamp timestamp, IgniteDataOutput out) throws IOException {
        if (timestamp == null) {
            out.writeInt(0);
            out.writeShort(0);
            out.writeVarInt(0L);
        } else {
            timestamp.writeTo(out);
        }
    }

    @Nullable
    public static HybridTimestamp readNullableFrom(IgniteDataInput in) throws IOException {
        long physicalHigh = in.readInt();
        int physicalLow = in.readShort() & 0xFFFF;
        long physical = physicalHigh << 16 | (long)physicalLow;
        int logical = in.readVarIntAsInt();
        if (physical == 0L && logical == 0) {
            return null;
        }
        return new HybridTimestamp(physical, logical);
    }

    public static HybridTimestamp readFrom(IgniteDataInput in) throws IOException {
        HybridTimestamp ts = HybridTimestamp.readNullableFrom(in);
        if (ts == null) {
            throw new IOException("A non-null timestamp is expected");
        }
        return ts;
    }
}

