/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.table.ClientColumn;
import org.apache.ignite.internal.client.table.ClientKeyValueBinaryView;
import org.apache.ignite.internal.client.table.ClientKeyValueView;
import org.apache.ignite.internal.client.table.ClientRecordBinaryView;
import org.apache.ignite.internal.client.table.ClientRecordView;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.tx.ClientTransaction;
import org.apache.ignite.internal.tostring.IgniteToStringBuilder;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientTable
implements Table {
    private final UUID id;
    private final String name;
    private final ReliableChannel ch;
    private final ConcurrentHashMap<Integer, ClientSchema> schemas = new ConcurrentHashMap();
    private volatile int latestSchemaVer = -1;
    private final Object latestSchemaLock = new Object();
    private volatile List<String> partitionAssignment = null;
    private volatile long partitionAssignmentVersion = -1L;

    public ClientTable(ReliableChannel ch, UUID id, String name) {
        assert (ch != null);
        assert (id != null);
        assert (name != null && !name.isEmpty());
        this.ch = ch;
        this.id = id;
        this.name = name;
    }

    public UUID tableId() {
        return this.id;
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public <R> RecordView<R> recordView(Mapper<R> recMapper) {
        Objects.requireNonNull(recMapper);
        return new ClientRecordView<R>(this, recMapper);
    }

    public RecordView<Tuple> recordView() {
        return new ClientRecordBinaryView(this);
    }

    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valMapper);
        return new ClientKeyValueView<K, V>(this, keyMapper, valMapper);
    }

    public KeyValueView<Tuple, Tuple> keyValueView() {
        return new ClientKeyValueBinaryView(this);
    }

    private CompletableFuture<ClientSchema> getLatestSchema() {
        if (this.latestSchemaVer >= 0) {
            return CompletableFuture.completedFuture(this.schemas.get(this.latestSchemaVer));
        }
        return this.loadSchema(null);
    }

    private CompletableFuture<ClientSchema> getSchema(int ver) {
        ClientSchema schema = this.schemas.get(ver);
        if (schema != null) {
            return CompletableFuture.completedFuture(schema);
        }
        return this.loadSchema(ver);
    }

    private CompletableFuture<ClientSchema> loadSchema(Integer ver) {
        return this.ch.serviceAsync(5, w -> {
            w.out().packUuid(this.id);
            if (ver == null) {
                w.out().packNil();
            } else {
                w.out().packArrayHeader(1);
                w.out().packInt(ver.intValue());
            }
        }, r -> {
            int schemaCnt = r.in().unpackMapHeader();
            if (schemaCnt == 0) {
                throw new IgniteException(ErrorGroups.Common.UNKNOWN_ERR, "Schema not found: " + ver);
            }
            ClientSchema last = null;
            for (int i = 0; i < schemaCnt; ++i) {
                last = this.readSchema(r.in());
            }
            return last;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSchema readSchema(ClientMessageUnpacker in) {
        int schemaVer = in.unpackInt();
        int colCnt = in.unpackArrayHeader();
        ClientColumn[] columns = new ClientColumn[colCnt];
        for (int i = 0; i < colCnt; ++i) {
            ClientColumn column;
            int propCnt = in.unpackArrayHeader();
            assert (propCnt >= 6);
            String name = in.unpackString();
            int type = in.unpackInt();
            boolean isKey = in.unpackBoolean();
            boolean isNullable = in.unpackBoolean();
            boolean isColocation = in.unpackBoolean();
            int scale = in.unpackInt();
            in.skipValues(propCnt - 6);
            columns[i] = column = new ClientColumn(name, type, isNullable, isKey, isColocation, i, scale);
        }
        ClientSchema schema = new ClientSchema(schemaVer, columns);
        this.schemas.put(schemaVer, schema);
        Object object = this.latestSchemaLock;
        synchronized (object) {
            if (schemaVer > this.latestSchemaVer) {
                this.latestSchemaVer = schemaVer;
            }
        }
        return schema;
    }

    public String toString() {
        return IgniteToStringBuilder.toString(ClientTable.class, (Object)this);
    }

    public static void writeTx(@Nullable Transaction tx, PayloadOutputChannel out) {
        if (tx == null) {
            out.out().packNil();
        } else {
            ClientTransaction clientTx = ClientTable.getClientTx(tx);
            if (clientTx.channel() != out.clientChannel()) {
                throw new IgniteException(ErrorGroups.Client.CONNECTION_ERR, "Transaction context has been lost due to connection errors.");
            }
            out.out().packLong(clientTx.id());
        }
    }

    private static ClientTransaction getClientTx(@NotNull Transaction tx) {
        if (!(tx instanceof ClientTransaction)) {
            throw new IgniteException(ErrorGroups.Common.UNKNOWN_ERR, "Unsupported transaction implementation: '" + tx.getClass() + "'. Use IgniteClient.transactions() to start transactions.");
        }
        return (ClientTransaction)tx;
    }

    <T> CompletableFuture<T> doSchemaOutInOpAsync(int opCode, BiConsumer<ClientSchema, PayloadOutputChannel> writer, BiFunction<ClientSchema, ClientMessageUnpacker, T> reader) {
        return this.doSchemaOutInOpAsync(opCode, writer, reader, null);
    }

    <T> CompletableFuture<T> doSchemaOutInOpAsync(int opCode, BiConsumer<ClientSchema, PayloadOutputChannel> writer, BiFunction<ClientSchema, ClientMessageUnpacker, T> reader, T defaultValue) {
        return ((CompletableFuture)this.getLatestSchema().thenCompose(schema -> this.ch.serviceAsync(opCode, w -> writer.accept((ClientSchema)schema, w), r -> this.readSchemaAndReadData((ClientSchema)schema, r.in(), reader, defaultValue)))).thenCompose(t -> this.loadSchemaAndReadData(t, reader));
    }

    <T> CompletableFuture<T> doSchemaOutInOpAsync(int opCode, BiConsumer<ClientSchema, PayloadOutputChannel> writer, BiFunction<ClientSchema, ClientMessageUnpacker, T> reader, T defaultValue, Function<ClientSchema, Integer> hashFunction) {
        CompletableFuture<ClientSchema> schemaFut = this.getLatestSchema();
        CompletableFuture<Object> partitionsFut = hashFunction == null ? CompletableFuture.completedFuture(null) : this.getPartitionAssignment();
        return ((CompletableFuture)CompletableFuture.allOf(schemaFut, partitionsFut).thenCompose(v -> {
            ClientSchema schema = schemaFut.getNow(null);
            String preferredNodeId = ClientTable.getPreferredNodeId(hashFunction, partitionsFut.getNow(null), schema);
            return this.ch.serviceAsync(opCode, w -> writer.accept(schema, w), r -> this.readSchemaAndReadData(schema, r.in(), reader, defaultValue), null, preferredNodeId);
        })).thenCompose(t -> this.loadSchemaAndReadData(t, reader));
    }

    public <T> CompletableFuture<T> doSchemaOutOpAsync(int opCode, BiConsumer<ClientSchema, PayloadOutputChannel> writer, Function<ClientMessageUnpacker, T> reader) {
        return this.getLatestSchema().thenCompose(schema -> this.ch.serviceAsync(opCode, w -> writer.accept((ClientSchema)schema, w), r -> reader.apply(r.in())));
    }

    <T> CompletableFuture<T> doSchemaOutOpAsync(int opCode, BiConsumer<ClientSchema, PayloadOutputChannel> writer, Function<ClientMessageUnpacker, T> reader, Function<ClientSchema, Integer> hashFunction) {
        CompletableFuture<ClientSchema> schemaFut = this.getLatestSchema();
        CompletableFuture<Object> partitionsFut = hashFunction == null ? CompletableFuture.completedFuture(null) : this.getPartitionAssignment();
        return CompletableFuture.allOf(schemaFut, partitionsFut).thenCompose(v -> {
            ClientSchema schema = schemaFut.getNow(null);
            String preferredNodeId = ClientTable.getPreferredNodeId(hashFunction, partitionsFut.getNow(null), schema);
            return this.ch.serviceAsync(opCode, w -> writer.accept(schema, w), r -> reader.apply(r.in()), null, preferredNodeId);
        });
    }

    private <T> Object readSchemaAndReadData(ClientSchema knownSchema, ClientMessageUnpacker in, BiFunction<ClientSchema, ClientMessageUnpacker, T> fn, T defaultValue) {
        ClientSchema resSchema;
        if (in.tryUnpackNil()) {
            return defaultValue;
        }
        int schemaVer = in.unpackInt();
        ClientSchema clientSchema = resSchema = schemaVer == knownSchema.version() ? knownSchema : this.schemas.get(schemaVer);
        if (resSchema != null) {
            return fn.apply(knownSchema, in);
        }
        return new IgniteBiTuple((Object)in.retain(), (Object)schemaVer);
    }

    private <T> CompletionStage<T> loadSchemaAndReadData(Object data, BiFunction<ClientSchema, ClientMessageUnpacker, T> fn) {
        if (!(data instanceof IgniteBiTuple)) {
            return CompletableFuture.completedFuture(data);
        }
        IgniteBiTuple biTuple = (IgniteBiTuple)data;
        ClientMessageUnpacker in = (ClientMessageUnpacker)biTuple.getKey();
        Integer schemaId = (Integer)biTuple.getValue();
        assert (in != null);
        assert (schemaId != null);
        CompletionStage resFut = this.getSchema(schemaId).thenApply(schema -> fn.apply((ClientSchema)schema, in));
        ((CompletableFuture)resFut).handle((tuple, err) -> {
            in.close();
            return null;
        });
        return resFut;
    }

    private CompletableFuture<List<String>> getPartitionAssignment() {
        List<String> cached = this.partitionAssignment;
        if (cached != null && this.partitionAssignmentVersion == this.ch.partitionAssignmentVersion()) {
            return CompletableFuture.completedFuture(cached);
        }
        return this.loadPartitionAssignment();
    }

    private CompletableFuture<List<String>> loadPartitionAssignment() {
        this.partitionAssignmentVersion = this.ch.partitionAssignmentVersion();
        return this.ch.serviceAsync(53, w -> w.out().packUuid(this.id), r -> {
            int cnt = r.in().unpackArrayHeader();
            ArrayList<String> res = new ArrayList<String>(cnt);
            for (int i = 0; i < cnt; ++i) {
                res.add(r.in().unpackString());
            }
            this.partitionAssignment = res;
            return res;
        });
    }

    @Nullable
    private static String getPreferredNodeId(Function<ClientSchema, Integer> hashFunction, List<String> partitions, ClientSchema schema) {
        if (partitions == null || partitions.isEmpty() || hashFunction == null) {
            return null;
        }
        Integer hash = hashFunction.apply(schema);
        if (hash == null) {
            return null;
        }
        return partitions.get(Math.abs(hash % partitions.size()));
    }
}

