/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.Columns;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.SchemaAware;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaMismatchException;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.MarshallerUtil;
import org.apache.ignite.internal.schema.marshaller.TupleMarshaller;
import org.apache.ignite.internal.schema.marshaller.TupleMarshallerException;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TupleMarshallerImpl
implements TupleMarshaller {
    private static final Object POISON_OBJECT = new Object();
    private final SchemaRegistry schemaReg;

    public TupleMarshallerImpl(SchemaRegistry schemaReg) {
        this.schemaReg = schemaReg;
        schemaReg.waitLatestSchema();
    }

    @Override
    public Row marshal(@NotNull Tuple tuple) throws TupleMarshallerException {
        try {
            SchemaDescriptor schema = this.schemaReg.schema();
            InternalTuple keyTuple0 = this.toInternalTuple(schema, tuple, true);
            InternalTuple valTuple0 = this.toInternalTuple(schema, tuple, false);
            if (valTuple0.knownColumns() + keyTuple0.knownColumns() != tuple.columnCount()) {
                throw new SchemaMismatchException(String.format("Tuple doesn't match schema: schemaVersion=%s, extraColumns=%s", schema.version(), this.extraColumnNames(tuple, schema)));
            }
            return this.buildRow(schema, keyTuple0, valTuple0);
        }
        catch (Exception ex) {
            throw new TupleMarshallerException("Failed to marshal tuple.", ex);
        }
    }

    @Override
    public Row marshal(@NotNull Tuple keyTuple, @Nullable Tuple valTuple) throws TupleMarshallerException {
        try {
            SchemaDescriptor schema = this.schemaReg.schema();
            InternalTuple keyTuple0 = this.toInternalTuple(schema, keyTuple, true);
            InternalTuple valTuple0 = this.toInternalTuple(schema, valTuple, false);
            if (keyTuple0.knownColumns() != keyTuple.columnCount()) {
                throw new SchemaMismatchException(String.format("Key tuple doesn't match schema: schemaVersion=%s, extraColumns=%s", schema.version(), this.extraColumnNames(keyTuple, true, schema)));
            }
            if (valTuple != null && valTuple0.knownColumns() != valTuple.columnCount()) {
                throw new SchemaMismatchException(String.format("Value tuple doesn't match schema: schemaVersion=%s, extraColumns=%s", schema.version(), this.extraColumnNames(valTuple, false, schema)));
            }
            return this.buildRow(schema, keyTuple0, valTuple0);
        }
        catch (Exception ex) {
            throw new TupleMarshallerException("Failed to marshal tuple.", ex);
        }
    }

    @NotNull
    private Row buildRow(SchemaDescriptor schema, InternalTuple keyTuple0, InternalTuple valTuple0) throws SchemaMismatchException {
        Column col;
        int i;
        RowAssembler rowBuilder = this.createAssembler(schema, keyTuple0, valTuple0);
        Columns columns = schema.keyColumns();
        int len = columns.length();
        for (i = 0; i < len; ++i) {
            col = columns.column(i);
            this.writeColumn(rowBuilder, col, keyTuple0);
        }
        if (valTuple0.tuple != null) {
            columns = schema.valueColumns();
            len = columns.length();
            for (i = 0; i < len; ++i) {
                col = columns.column(i);
                this.writeColumn(rowBuilder, col, valTuple0);
            }
        }
        return new Row(schema, rowBuilder.build());
    }

    @Override
    public Row marshalKey(@NotNull Tuple keyTuple) throws TupleMarshallerException {
        try {
            SchemaDescriptor schema = this.schemaReg.schema();
            InternalTuple keyTuple0 = this.toInternalTuple(schema, keyTuple, true);
            if (keyTuple0.knownColumns() < keyTuple.columnCount()) {
                throw new SchemaMismatchException("Key tuple contains extra columns: " + this.extraColumnNames(keyTuple, true, schema));
            }
            RowAssembler rowBuilder = this.createAssembler(schema, keyTuple0, InternalTuple.NO_VALUE);
            Columns cols = schema.keyColumns();
            int len = cols.length();
            for (int i = 0; i < len; ++i) {
                Column col = cols.column(i);
                this.writeColumn(rowBuilder, col, keyTuple0);
            }
            return new Row(schema, rowBuilder.build());
        }
        catch (Exception ex) {
            throw new TupleMarshallerException("Failed to marshal tuple.", ex);
        }
    }

    @NotNull
    private InternalTuple toInternalTuple(SchemaDescriptor schema, Tuple tuple, boolean keyFlag) throws SchemaMismatchException {
        if (tuple == null) {
            return InternalTuple.NO_VALUE;
        }
        Columns columns = keyFlag ? schema.keyColumns() : schema.valueColumns();
        int nonNullVarlen = 0;
        int nonNullVarlenSize = 0;
        int knownColumns = 0;
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        if (tuple instanceof SchemaAware && Objects.equals(((SchemaAware)tuple).schema(), schema)) {
            int len = columns.length();
            for (int i = 0; i < len; ++i) {
                Column col = columns.column(i);
                Object val = tuple.valueOrDefault(col.name(), POISON_OBJECT);
                assert (val != POISON_OBJECT);
                ++knownColumns;
                if (val == null || columns.firstVarlengthColumn() < i) continue;
                nonNullVarlenSize += MarshallerUtil.getValueSize((Object)val, (NativeType)col.type());
                ++nonNullVarlen;
            }
        } else {
            int len = columns.length();
            for (int i = 0; i < len; ++i) {
                Column col = columns.column(i);
                Object val = tuple.valueOrDefault(col.name(), POISON_OBJECT);
                if (val == POISON_OBJECT) {
                    if (keyFlag) {
                        throw new SchemaMismatchException("Missed key column: " + col.name());
                    }
                    val = col.defaultValue();
                    defaults.put(col.name(), val);
                } else {
                    ++knownColumns;
                }
                col.validate(val);
                if (val == null || columns.isFixedSize(i)) continue;
                nonNullVarlenSize += MarshallerUtil.getValueSize((Object)val, (NativeType)col.type());
                ++nonNullVarlen;
            }
        }
        return new InternalTuple(tuple, nonNullVarlen, nonNullVarlenSize, defaults, knownColumns);
    }

    private Set<String> extraColumnNames(Tuple tuple, SchemaDescriptor schema) {
        HashSet<String> cols = new HashSet<String>();
        int len = tuple.columnCount();
        for (int i = 0; i < len; ++i) {
            String colName = tuple.columnName(i);
            if (schema.column(colName) != null) continue;
            cols.add(colName);
        }
        return cols;
    }

    @NotNull
    private Set<String> extraColumnNames(Tuple tuple, boolean keyTuple, SchemaDescriptor schema) {
        HashSet<String> cols = new HashSet<String>();
        int len = tuple.columnCount();
        for (int i = 0; i < len; ++i) {
            String colName = tuple.columnName(i);
            Column col = schema.column(colName);
            if (col != null && !(schema.isKeyColumn(col.schemaIndex()) ^ keyTuple)) continue;
            cols.add(colName);
        }
        return cols;
    }

    private RowAssembler createAssembler(SchemaDescriptor schema, InternalTuple keyTuple, InternalTuple valTuple) {
        return new RowAssembler(schema, keyTuple.nonNullVarLenSize, keyTuple.nonNullVarlen, valTuple.nonNullVarLenSize, valTuple.nonNullVarlen);
    }

    private void writeColumn(RowAssembler rowAsm, Column col, InternalTuple tup) throws SchemaMismatchException {
        RowAssembler.writeValue((RowAssembler)rowAsm, (Column)col, (Object)tup.value(col.name()));
    }

    private static class InternalTuple {
        static final InternalTuple NO_VALUE = new InternalTuple(null, 0, 0, null, 0);
        private final Tuple tuple;
        private final int nonNullVarlen;
        private final int nonNullVarLenSize;
        private final Map<String, Object> defaults;
        private final int knownColumns;

        InternalTuple(Tuple tuple, int nonNullVarlen, int nonNullVarlenSize, Map<String, Object> defaults, int knownColumns) {
            this.nonNullVarlen = nonNullVarlen;
            this.nonNullVarLenSize = nonNullVarlenSize;
            this.tuple = tuple;
            this.defaults = defaults;
            this.knownColumns = knownColumns;
        }

        public int knownColumns() {
            return this.knownColumns;
        }

        Object value(String columnName) {
            Object val = this.tuple.valueOrDefault(columnName, POISON_OBJECT);
            if (val == POISON_OBJECT) {
                return this.defaults.get(columnName);
            }
            return val;
        }
    }
}

