/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.message.TxFinishResponse;
import org.apache.ignite.internal.tx.message.TxFinishResponseBuilder;

public class TxFinishResponseImpl
implements TxFinishResponse {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 1;
    @IgniteToStringInclude
    private final String errorMessage;
    @IgniteToStringInclude
    private HybridTimestamp timestamp;
    private byte[] timestampByteArray;

    private TxFinishResponseImpl(String errorMessage, HybridTimestamp timestamp, byte[] timestampByteArray) {
        this.errorMessage = errorMessage;
        this.timestamp = timestamp;
        this.timestampByteArray = timestampByteArray;
    }

    @Override
    public String errorMessage() {
        return this.errorMessage;
    }

    byte[] timestampByteArray() {
        return this.timestampByteArray;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxFinishResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxFinishResponseImpl otherMessage = (TxFinishResponseImpl)other;
        return Objects.equals(this.errorMessage, otherMessage.errorMessage) && Objects.equals(this.timestamp, otherMessage.timestamp);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.errorMessage, this.timestamp);
        return result;
    }

    public static TxFinishResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject timestampByteArraymo = marshaller.marshal((Object)this.timestamp);
        usedDescriptors.addAll((IntCollection)timestampByteArraymo.usedDescriptorIds());
        this.timestampByteArray = timestampByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.timestamp = (HybridTimestamp)marshaller.unmarshal(this.timestampByteArray, descriptorsObj);
        this.timestampByteArray = null;
    }

    private static class Builder
    implements TxFinishResponseBuilder {
        private String errorMessage;
        private HybridTimestamp timestamp;
        private byte[] timestampByteArray;

        private Builder() {
        }

        @Override
        public TxFinishResponseBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public TxFinishResponseBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public TxFinishResponseBuilder timestampByteArray(byte[] timestampByteArray) {
            this.timestampByteArray = timestampByteArray;
            return this;
        }

        @Override
        public String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public byte[] timestampByteArray() {
            return this.timestampByteArray;
        }

        @Override
        public TxFinishResponse build() {
            return new TxFinishResponseImpl(this.errorMessage, this.timestamp, this.timestampByteArray);
        }
    }
}

