/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import org.apache.ignite.sql.SqlColumnType;

public class ClientSqlColumnTypeConverter {
    public static int columnTypeToOrdinal(SqlColumnType columnType) {
        switch (columnType) {
            case BOOLEAN: {
                return 0;
            }
            case INT8: {
                return 1;
            }
            case INT16: {
                return 2;
            }
            case INT32: {
                return 3;
            }
            case INT64: {
                return 4;
            }
            case FLOAT: {
                return 5;
            }
            case DOUBLE: {
                return 6;
            }
            case DECIMAL: {
                return 7;
            }
            case DATE: {
                return 8;
            }
            case TIME: {
                return 9;
            }
            case DATETIME: {
                return 10;
            }
            case TIMESTAMP: {
                return 11;
            }
            case UUID: {
                return 12;
            }
            case BITMASK: {
                return 13;
            }
            case STRING: {
                return 14;
            }
            case BYTE_ARRAY: {
                return 15;
            }
            case PERIOD: {
                return 16;
            }
            case DURATION: {
                return 17;
            }
            case NUMBER: {
                return 18;
            }
        }
        throw new IllegalArgumentException("Invalid column type: " + columnType);
    }

    public static SqlColumnType ordinalToColumnType(int ordinal) {
        switch (ordinal) {
            case 0: {
                return SqlColumnType.BOOLEAN;
            }
            case 1: {
                return SqlColumnType.INT8;
            }
            case 2: {
                return SqlColumnType.INT16;
            }
            case 3: {
                return SqlColumnType.INT32;
            }
            case 4: {
                return SqlColumnType.INT64;
            }
            case 5: {
                return SqlColumnType.FLOAT;
            }
            case 6: {
                return SqlColumnType.DOUBLE;
            }
            case 7: {
                return SqlColumnType.DECIMAL;
            }
            case 8: {
                return SqlColumnType.DATE;
            }
            case 9: {
                return SqlColumnType.TIME;
            }
            case 10: {
                return SqlColumnType.DATETIME;
            }
            case 11: {
                return SqlColumnType.TIMESTAMP;
            }
            case 12: {
                return SqlColumnType.UUID;
            }
            case 13: {
                return SqlColumnType.BITMASK;
            }
            case 14: {
                return SqlColumnType.STRING;
            }
            case 15: {
                return SqlColumnType.BYTE_ARRAY;
            }
            case 16: {
                return SqlColumnType.PERIOD;
            }
            case 17: {
                return SqlColumnType.DURATION;
            }
            case 18: {
                return SqlColumnType.NUMBER;
            }
        }
        throw new IllegalArgumentException("Invalid column type code: " + ordinal);
    }
}

