/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.causality;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.causality.OutdatedTokenException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.IgniteTriConsumer;

public class VersionedValue<T> {
    private static final long NOT_INITIALIZED = -1L;
    private static final int DEFAULT_HISTORY_SIZE = 2;
    private final int historySize;
    private final List<IgniteTriConsumer<Long, T, Throwable>> completionListeners = new CopyOnWriteArrayList<IgniteTriConsumer<Long, T, Throwable>>();
    private final ConcurrentNavigableMap<Long, CompletableFuture<T>> history = new ConcurrentSkipListMap<Long, CompletableFuture<T>>();
    private final ReadWriteLock trimHistoryLock = new ReentrantReadWriteLock();
    private final CompletableFuture<T> initFut = new CompletableFuture();
    private final Supplier<T> defaultValSupplier;
    private final Object updateMutex = new Object();
    private final AtomicReference<T> defaultValRef;
    private volatile long actualToken = -1L;
    private volatile CompletableFuture<T> updaterFuture = null;

    public VersionedValue(Consumer<Function<Long, CompletableFuture<?>>> observableRevisionUpdater, int historySize, Supplier<T> defaultVal) {
        this.historySize = historySize;
        this.defaultValSupplier = defaultVal;
        AtomicReference atomicReference = this.defaultValRef = this.defaultValSupplier == null ? null : new AtomicReference();
        if (observableRevisionUpdater != null) {
            observableRevisionUpdater.accept(this::completeOnRevision);
        }
    }

    public VersionedValue(Consumer<Function<Long, CompletableFuture<?>>> observableRevisionUpdater, Supplier<T> defaultVal) {
        this(observableRevisionUpdater, 2, defaultVal);
    }

    public VersionedValue(Consumer<Function<Long, CompletableFuture<?>>> observableRevisionUpdater) {
        this(observableRevisionUpdater, 2, null);
    }

    public CompletableFuture<T> get(long causalityToken) {
        if (this.initFut.isDone()) {
            return this.getInternal(causalityToken);
        }
        return this.initFut.thenCompose(o -> this.getInternal(causalityToken));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<T> getInternal(long causalityToken) {
        long actualToken0 = this.actualToken;
        if (this.history.floorEntry(causalityToken) == null) {
            throw new OutdatedTokenException(causalityToken, actualToken0, this.historySize);
        }
        if (causalityToken <= actualToken0) {
            return this.getValueForPreviousToken(causalityToken);
        }
        this.trimHistoryLock.readLock().lock();
        try {
            if (causalityToken <= actualToken0) {
                CompletableFuture<T> completableFuture = this.getValueForPreviousToken(causalityToken);
                return completableFuture;
            }
            CompletableFuture fut = new CompletableFuture();
            CompletableFuture previousFut = this.history.putIfAbsent(causalityToken, fut);
            CompletableFuture completableFuture = previousFut == null ? fut : previousFut;
            return completableFuture;
        }
        finally {
            this.trimHistoryLock.readLock().unlock();
        }
    }

    public T latest() {
        for (CompletableFuture fut : this.history.descendingMap().values()) {
            if (!fut.isDone()) continue;
            return fut.join();
        }
        return this.getDefault();
    }

    private T getDefault() {
        if (this.defaultValSupplier != null && this.defaultValRef.get() == null) {
            T defaultVal = this.defaultValSupplier.get();
            assert (defaultVal != null) : "Default value can't be null.";
            this.defaultValRef.compareAndSet(null, defaultVal);
        }
        return this.defaultValRef == null ? null : (T)this.defaultValRef.get();
    }

    private CompletableFuture<T> getValueForPreviousToken(long causalityToken) {
        Map.Entry histEntry = this.history.floorEntry(causalityToken);
        if (histEntry == null) {
            throw new OutdatedTokenException(causalityToken, this.actualToken, this.historySize);
        }
        return (CompletableFuture)histEntry.getValue();
    }

    public void complete(long causalityToken) {
        this.completeOnRevision(causalityToken);
    }

    public void complete(long causalityToken, T value) {
        long actualToken0 = this.actualToken;
        if (actualToken0 == -1L) {
            this.history.put(causalityToken, this.initFut);
        }
        VersionedValue.checkToken(actualToken0, causalityToken);
        this.completeInternal(causalityToken, value, null);
        this.completeOnRevision(causalityToken);
    }

    public void completeExceptionally(long causalityToken, Throwable throwable) {
        long actualToken0 = this.actualToken;
        if (actualToken0 == -1L) {
            this.history.put(causalityToken, this.initFut);
        }
        VersionedValue.checkToken(actualToken0, causalityToken);
        this.completeInternal(causalityToken, null, throwable);
        this.completeOnRevision(causalityToken);
    }

    private void completeInternal(long causalityToken, T value, Throwable throwable) {
        CompletableFuture<T> res = this.history.putIfAbsent(causalityToken, throwable == null ? CompletableFuture.completedFuture(value) : CompletableFuture.failedFuture(throwable));
        if (res == null) {
            this.notifyCompletionListeners(causalityToken, value, throwable);
            return;
        }
        assert (!res.isDone()) : this.completeInternalConflictErrorMessage(res, causalityToken, value, throwable);
        if (throwable == null) {
            res.complete(value);
        } else {
            res.completeExceptionally(throwable);
        }
        this.notifyCompletionListeners(causalityToken, value, throwable);
    }

    private String completeInternalConflictErrorMessage(CompletableFuture<T> future, long token, T value, Throwable throwable) {
        return (String)((CompletableFuture)future.handle((prevValue, prevThrowable) -> IgniteStringFormatter.format("Different values associated with the token [token={}, value={}, exception={}, prevValue={}, prevException={}]", token, value, throwable, prevValue, prevThrowable))).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<T> update(long causalityToken, BiFunction<T, Throwable, CompletableFuture<T>> updater) {
        long actualToken0 = this.actualToken;
        VersionedValue.checkToken(actualToken0, causalityToken);
        Object object = this.updateMutex;
        synchronized (object) {
            CompletionStage<T> updaterFuture = this.updaterFuture;
            CompletableFuture<T> future = updaterFuture == null ? this.previousOrDefaultValueFuture(actualToken0) : updaterFuture;
            CompletionStage f0 = ((CompletableFuture)future.handle(updater::apply)).handle((fut, e) -> e == null ? fut : CompletableFuture.failedFuture(e));
            updaterFuture = ((CompletableFuture)f0).thenCompose(Function.identity());
            this.updaterFuture = updaterFuture;
            return updaterFuture;
        }
    }

    public void whenComplete(IgniteTriConsumer<Long, T, Throwable> action) {
        this.completionListeners.add(action);
    }

    public void removeWhenComplete(IgniteTriConsumer<Long, T, Throwable> action) {
        this.completionListeners.remove(action);
    }

    private void notifyCompletionListeners(long causalityToken, T value, Throwable throwable) {
        Throwable unpackedThrowable = throwable instanceof CompletionException ? throwable.getCause() : throwable;
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (IgniteTriConsumer<Long, Long, Throwable> igniteTriConsumer : this.completionListeners) {
            try {
                igniteTriConsumer.accept(causalityToken, (Long)value, unpackedThrowable);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            IgniteInternalException ex = new IgniteInternalException();
            exceptions.forEach(ex::addSuppressed);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<?> completeOnRevision(long causalityToken) {
        long actualToken0 = this.actualToken;
        assert (causalityToken > actualToken0) : IgniteStringFormatter.format("New token should be greater than current [current={}, new={}]", actualToken0, causalityToken);
        if (actualToken0 == -1L) {
            this.history.put(causalityToken, this.initFut);
        }
        Object object = this.updateMutex;
        synchronized (object) {
            CompletableFuture<T> updaterFuture0 = this.updaterFuture;
            CompletableFuture<Object> completeUpdatesFuture = updaterFuture0 == null ? CompletableFuture.completedFuture(null) : updaterFuture0.whenComplete((T v, U t) -> this.completeInternal(causalityToken, (T)v, (Throwable)t));
            this.updaterFuture = null;
            this.actualToken = causalityToken;
            return completeUpdatesFuture.thenRun(() -> {
                this.completeRelatedFuture(causalityToken);
                if (this.history.size() > 1 && causalityToken - (Long)this.history.firstKey() >= (long)this.historySize) {
                    this.trimToSize(causalityToken);
                }
                Map.Entry entry = this.history.floorEntry(causalityToken);
                assert (entry != null && ((CompletableFuture)entry.getValue()).isDone()) : IgniteStringFormatter.format("Future for the token is not completed [token={}]", causalityToken);
            });
        }
    }

    private void completeRelatedFuture(long causalityToken) {
        Map.Entry entry = this.history.floorEntry(causalityToken);
        CompletableFuture future = (CompletableFuture)entry.getValue();
        if (!future.isDone()) {
            CompletableFuture previousFuture;
            Map.Entry entryBefore = this.history.headMap((Object)causalityToken).lastEntry();
            CompletableFuture completableFuture = previousFuture = entryBefore == null ? CompletableFuture.completedFuture(this.getDefault()) : (CompletableFuture)entryBefore.getValue();
            assert (previousFuture.isDone()) : IgniteStringFormatter.format("No future for token [token={}]", causalityToken);
            previousFuture.whenComplete((T t, U throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                    this.notifyCompletionListeners(causalityToken, null, (Throwable)throwable);
                } else {
                    future.complete(t);
                    this.notifyCompletionListeners(causalityToken, t, null);
                }
            });
        } else if (entry.getKey() < causalityToken) {
            future.whenComplete((T v, U e) -> this.notifyCompletionListeners(causalityToken, (T)v, (Throwable)e));
        }
    }

    private CompletableFuture<T> previousOrDefaultValueFuture(long actualToken) {
        Map.Entry histEntry = this.history.floorEntry(actualToken);
        if (histEntry == null) {
            return CompletableFuture.completedFuture(this.getDefault());
        }
        CompletableFuture prevFuture = (CompletableFuture)histEntry.getValue();
        assert (prevFuture.isDone()) : "Previous value should be ready.";
        return prevFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(long causalityToken) {
        Long lastToken = (Long)this.history.lastKey();
        this.trimHistoryLock.writeLock().lock();
        try {
            for (Long token : this.history.keySet()) {
                if (token.equals(lastToken) || causalityToken - token < (long)this.historySize) continue;
                this.history.remove(token);
            }
        }
        finally {
            this.trimHistoryLock.writeLock().unlock();
        }
    }

    private static void checkToken(long actualToken, long candidateToken) {
        assert (actualToken == -1L || actualToken < candidateToken) : IgniteStringFormatter.format("Token must be greater than actual [token={}, actual={}]", candidateToken, actualToken);
    }
}

