/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.odbc;

import java.util.Objects;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcUtils;

public class OdbcTableMeta {
    private final String catalog;
    private final String schema;
    private final String table;
    private final String tableType;

    public OdbcTableMeta(String catalog, String schema, String table, String tableType) {
        this.catalog = catalog;
        this.schema = OdbcUtils.addQuotationMarksIfNeeded(schema);
        this.table = table;
        this.tableType = tableType;
    }

    public int hashCode() {
        int hash = Objects.hashCode(this.catalog);
        hash = 31 * hash + Objects.hashCode(this.schema);
        hash = 31 * hash + Objects.hashCode(this.table);
        hash = 31 * hash + Objects.hashCode(this.tableType);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof OdbcTableMeta) {
            OdbcTableMeta other = (OdbcTableMeta)o;
            return this == other || Objects.equals(this.catalog, other.catalog) && Objects.equals(this.schema, other.schema) && Objects.equals(this.table, other.table) && Objects.equals(this.tableType, other.tableType);
        }
        return false;
    }

    public void writeBinary(BinaryRawWriterEx writer) {
        writer.writeString(this.catalog);
        writer.writeString(this.schema);
        writer.writeString(this.table);
        writer.writeString(this.tableType);
    }
}

