/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.topology;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class PartitionDefferedDeleteQueueCleanupTask
implements GridTimeoutObject {
    private final IgniteUuid id = IgniteUuid.randomUuid();
    private final long endTime;
    private final long timeout;
    private final GridCacheSharedContext cctx;
    private final IgniteLogger log;

    public PartitionDefferedDeleteQueueCleanupTask(GridCacheSharedContext cctx, long timeout) {
        this.timeout = timeout;
        this.endTime = U.currentTimeMillis() + timeout;
        this.cctx = cctx;
        this.log = cctx.logger(this.getClass());
    }

    @Override
    public IgniteUuid timeoutId() {
        return this.id;
    }

    @Override
    public long endTime() {
        return this.endTime;
    }

    @Override
    public void onTimeout() {
        this.cctx.kernalContext().closure().runLocalSafe((Runnable)new GridPlainRunnable(){

            @Override
            public void run() {
                try {
                    for (CacheGroupContext grp : PartitionDefferedDeleteQueueCleanupTask.this.cctx.cache().cacheGroups()) {
                        if (!grp.affinityNode()) continue;
                        GridDhtPartitionTopology top = null;
                        try {
                            top = grp.topology();
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        if (top != null) {
                            for (GridDhtLocalPartition part : top.currentLocalPartitions()) {
                                part.cleanupRemoveQueue();
                            }
                        }
                        if (!PartitionDefferedDeleteQueueCleanupTask.this.cctx.kernalContext().isStopping()) continue;
                        return;
                    }
                }
                catch (Exception e) {
                    U.error(PartitionDefferedDeleteQueueCleanupTask.this.log, "Failed to cleanup removed cache items: " + e, e);
                }
                if (PartitionDefferedDeleteQueueCleanupTask.this.cctx.kernalContext().isStopping()) {
                    return;
                }
                PartitionDefferedDeleteQueueCleanupTask.this.cctx.time().addTimeoutObject(new PartitionDefferedDeleteQueueCleanupTask(PartitionDefferedDeleteQueueCleanupTask.this.cctx, PartitionDefferedDeleteQueueCleanupTask.this.timeout));
            }
        }, true);
    }
}

