/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.benchmark;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.benchmark.BenchmarkConfig;
import org.apache.hc.core5.benchmark.Stats;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncRequester;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.nio.AsyncClientEndpoint;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.nio.ResourceHolder;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.FileEntityProducer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;

class BenchmarkWorker
implements ResourceHolder {
    private final HttpAsyncRequester requester;
    private final HttpHost host;
    private final HttpCoreContext context;
    private final AtomicLong requestCount;
    private final CountDownLatch completionLatch;
    private final Stats stats;
    private final BenchmarkConfig config;
    private final AtomicReference<AsyncClientEndpoint> endpointRef;

    public BenchmarkWorker(HttpAsyncRequester requester, HttpHost host, HttpCoreContext context, AtomicLong requestCount, CountDownLatch completionLatch, Stats stats, BenchmarkConfig config) {
        this.requester = requester;
        this.host = host;
        this.context = context;
        this.requestCount = requestCount;
        this.completionLatch = completionLatch;
        this.stats = stats;
        this.config = config;
        this.endpointRef = new AtomicReference<Object>(null);
    }

    private AsyncRequestProducer createRequestProducer() {
        String method = this.config.getMethod();
        if (method == null) {
            method = this.config.isHeadInsteadOfGet() ? Method.HEAD.name() : Method.GET.name();
        }
        final BasicHttpRequest request = new BasicHttpRequest(method, this.config.getUri());
        String[] headers = this.config.getHeaders();
        if (headers != null) {
            for (String s : headers) {
                int pos = s.indexOf(58);
                if (pos == -1) continue;
                request.addHeader((Header)new BasicHeader(s.substring(0, pos).trim(), (Object)s.substring(pos + 1)));
            }
        }
        if (!this.config.isKeepAlive() && !this.config.isForceHttp2()) {
            request.addHeader((Header)new BasicHeader("Connection", (Object)"close"));
        }
        if (this.config.isUseAcceptGZip()) {
            request.addHeader((Header)new BasicHeader("Accept-Encoding", (Object)"gzip"));
        }
        if (this.config.getSoapAction() != null && this.config.getSoapAction().length() > 0) {
            request.addHeader((Header)new BasicHeader("SOAPAction", (Object)this.config.getSoapAction()));
        }
        Object entityProducer = this.config.getPayloadFile() != null ? new FileEntityProducer(this.config.getPayloadFile(), this.config.getContentType(), this.config.isUseChunking()) : (this.config.getPayloadText() != null ? new BasicAsyncEntityProducer((CharSequence)this.config.getPayloadText(), this.config.getContentType(), this.config.isUseChunking()) : null);
        return new AsyncRequestProducer((AsyncEntityProducer)entityProducer){
            final /* synthetic */ AsyncEntityProducer val$entityProducer;
            {
                this.val$entityProducer = asyncEntityProducer;
            }

            public void sendRequest(RequestChannel channel, HttpContext context) throws HttpException, IOException {
                channel.sendRequest((HttpRequest)request, (EntityDetails)this.val$entityProducer, context);
            }

            public boolean isRepeatable() {
                return this.val$entityProducer == null || this.val$entityProducer.isRepeatable();
            }

            public int available() {
                return this.val$entityProducer != null ? this.val$entityProducer.available() : 0;
            }

            public void produce(DataStreamChannel channel) throws IOException {
                if (this.val$entityProducer != null) {
                    this.val$entityProducer.produce(channel);
                }
            }

            public void failed(Exception cause) {
                if (BenchmarkWorker.this.config.getVerbosity() >= 1) {
                    System.out.println("Failed HTTP request: " + cause.getMessage());
                }
            }

            public void releaseResources() {
                if (this.val$entityProducer != null) {
                    this.val$entityProducer.releaseResources();
                }
            }
        };
    }

    private AsyncResponseConsumer<Void> createResponseConsumer() {
        return new AsyncResponseConsumer<Void>(){
            volatile int status;
            volatile Charset charset;
            final AtomicLong contentLength = new AtomicLong();
            final AtomicReference<FutureCallback<Void>> resultCallbackRef = new AtomicReference<Object>(null);

            public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext context, FutureCallback<Void> resultCallback) throws HttpException, IOException {
                this.status = response.getCode();
                this.resultCallbackRef.set(resultCallback);
                BenchmarkWorker.this.stats.setVersion(response.getVersion());
                Header serverHeader = response.getFirstHeader("Server");
                if (serverHeader != null) {
                    BenchmarkWorker.this.stats.setServerName(serverHeader.getValue());
                }
                if (BenchmarkWorker.this.config.getVerbosity() >= 2) {
                    System.out.println(response.getCode());
                }
                if (entityDetails != null) {
                    if (BenchmarkWorker.this.config.getVerbosity() >= 6 && entityDetails.getContentType() != null) {
                        ContentType contentType = ContentType.parseLenient((CharSequence)entityDetails.getContentType());
                        this.charset = contentType.getCharset();
                    }
                } else {
                    this.streamEnd(null);
                }
            }

            public void informationResponse(HttpResponse response, HttpContext context) throws HttpException, IOException {
            }

            public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                capacityChannel.update(Integer.MAX_VALUE);
            }

            public void consume(ByteBuffer src) throws IOException {
                int n = src.remaining();
                this.contentLength.addAndGet(n);
                BenchmarkWorker.this.stats.incTotalContentLength(n);
                if (BenchmarkWorker.this.config.getVerbosity() >= 6) {
                    CharsetDecoder decoder = (this.charset != null ? this.charset : StandardCharsets.US_ASCII).newDecoder();
                    System.out.print(decoder.decode(src));
                }
            }

            public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                if (this.status == 200) {
                    BenchmarkWorker.this.stats.incSuccessCount();
                } else {
                    BenchmarkWorker.this.stats.incFailureCount();
                }
                BenchmarkWorker.this.stats.setContentLength(this.contentLength.get());
                FutureCallback resultCallback = this.resultCallbackRef.getAndSet(null);
                if (resultCallback != null) {
                    resultCallback.completed(null);
                }
                if (BenchmarkWorker.this.config.getVerbosity() >= 6) {
                    System.out.println();
                    System.out.println();
                }
            }

            public void failed(Exception cause) {
                BenchmarkWorker.this.stats.incFailureCount();
                FutureCallback resultCallback = this.resultCallbackRef.getAndSet(null);
                if (resultCallback != null) {
                    resultCallback.failed(cause);
                }
                if (BenchmarkWorker.this.config.getVerbosity() >= 1) {
                    System.out.println("HTTP response error: " + cause.getMessage());
                }
            }

            public void releaseResources() {
            }
        };
    }

    public void execute() {
        if (this.requestCount.decrementAndGet() >= 0L) {
            AsyncClientEndpoint endpoint = this.endpointRef.get();
            if (endpoint != null && !endpoint.isConnected()) {
                endpoint.releaseAndDiscard();
                endpoint = null;
            }
            if (endpoint == null) {
                this.requester.connect(this.host, this.config.getSocketTimeout(), null, (FutureCallback)new FutureCallback<AsyncClientEndpoint>(){

                    public void completed(AsyncClientEndpoint endpoint) {
                        BenchmarkWorker.this.endpointRef.set(endpoint);
                        endpoint.execute(BenchmarkWorker.this.createRequestProducer(), BenchmarkWorker.this.createResponseConsumer(), (HttpContext)BenchmarkWorker.this.context, (FutureCallback)new FutureCallback<Void>(){

                            public void completed(Void result) {
                                BenchmarkWorker.this.execute();
                            }

                            public void failed(Exception cause) {
                                BenchmarkWorker.this.execute();
                            }

                            public void cancelled() {
                                BenchmarkWorker.this.completionLatch.countDown();
                            }
                        });
                    }

                    public void failed(Exception cause) {
                        BenchmarkWorker.this.stats.incFailureCount();
                        if (BenchmarkWorker.this.config.getVerbosity() >= 1) {
                            System.out.println("Connect error: " + cause.getMessage());
                        }
                        BenchmarkWorker.this.execute();
                    }

                    public void cancelled() {
                        BenchmarkWorker.this.completionLatch.countDown();
                    }
                });
            } else {
                this.stats.incKeepAliveCount();
                endpoint.execute(this.createRequestProducer(), this.createResponseConsumer(), (HttpContext)this.context, (FutureCallback)new FutureCallback<Void>(){

                    public void completed(Void result) {
                        BenchmarkWorker.this.execute();
                    }

                    public void failed(Exception cause) {
                        BenchmarkWorker.this.execute();
                    }

                    public void cancelled() {
                        BenchmarkWorker.this.completionLatch.countDown();
                    }
                });
            }
        } else {
            this.completionLatch.countDown();
        }
    }

    public void releaseResources() {
        AsyncClientEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            endpoint.releaseAndDiscard();
        }
    }
}

