/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.io.PrintStream;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.HopLoggingEvent;
import org.apache.hop.core.logging.ILogChannelFactory;
import org.apache.hop.core.logging.LogChannelFactory;
import org.apache.hop.core.logging.LoggingBuffer;
import org.apache.hop.core.logging.LoggingPrintStream;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.logging.MetricsRegistry;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.ExecutorUtil;

public class HopLogStore {
    public static PrintStream OriginalSystemOut = System.out;
    public static PrintStream OriginalSystemErr = System.err;
    private static HopLogStore store;
    private LoggingBuffer appender;
    private Timer logCleanerTimer;
    private static AtomicBoolean initialized;
    private static ILogChannelFactory logChannelFactory;

    public static ILogChannelFactory getLogChannelFactory() {
        return logChannelFactory;
    }

    public static void setLogChannelFactory(ILogChannelFactory logChannelFactory) {
        HopLogStore.logChannelFactory = logChannelFactory;
    }

    private HopLogStore(int maxSize, int maxLogTimeoutMinutes, boolean redirectStdOut, boolean redirectStdErr) {
        this.appender = new LoggingBuffer(maxSize);
        this.replaceLogCleaner(maxLogTimeoutMinutes);
        if (redirectStdOut) {
            System.setOut(new LoggingPrintStream(OriginalSystemOut));
        }
        if (redirectStdErr) {
            System.setErr(new LoggingPrintStream(OriginalSystemErr));
        }
    }

    public void replaceLogCleaner(final int maxLogTimeoutMinutes) {
        ExecutorUtil.cleanup(this.logCleanerTimer);
        this.logCleanerTimer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (maxLogTimeoutMinutes > 0) {
                    long minTimeBoundary = new Date().getTime() - (long)(maxLogTimeoutMinutes * 60 * 1000);
                    HopLogStore.this.appender.removeBufferLinesBefore(minTimeBoundary);
                }
            }
        };
        this.logCleanerTimer.schedule(timerTask, 10000L, 10000L);
    }

    public static void init(int maxSize, int maxLogTimeoutMinutes, boolean redirectStdOut, boolean redirectStdErr) {
        if (maxSize > 0 || maxLogTimeoutMinutes > 0) {
            HopLogStore.init0(maxSize, maxLogTimeoutMinutes, redirectStdOut, redirectStdErr);
        } else {
            HopLogStore.init(redirectStdOut, redirectStdErr);
        }
    }

    public static void init() {
        HopLogStore.init(EnvUtil.getSystemProperty("HOP_REDIRECT_STDOUT", "N").equalsIgnoreCase("Y"), EnvUtil.getSystemProperty("HOP_REDIRECT_STDERR", "N").equalsIgnoreCase("Y"));
    }

    public static void init(boolean redirectStdOut, boolean redirectStdErr) {
        int maxSize = Const.toInt(EnvUtil.getSystemProperty("HOP_MAX_LOG_SIZE_IN_LINES"), 5000);
        int maxLogTimeoutMinutes = Const.toInt(EnvUtil.getSystemProperty("HOP_MAX_LOG_TIMEOUT_IN_MINUTES"), 720);
        HopLogStore.init0(maxSize, maxLogTimeoutMinutes, redirectStdOut, redirectStdErr);
    }

    private static synchronized void init0(int maxSize, int maxLogTimeoutMinutes, boolean redirectStdOut, boolean redirectStdErr) {
        if (store != null) {
            HopLogStore.store.appender.setMaxNrLines(maxSize);
            store.replaceLogCleaner(maxLogTimeoutMinutes);
        } else {
            store = new HopLogStore(maxSize, maxLogTimeoutMinutes, redirectStdOut, redirectStdErr);
        }
        initialized.set(true);
    }

    public static HopLogStore getInstance() {
        if (store == null) {
            throw new RuntimeException("Central Log Store is not initialized!!!");
        }
        return store;
    }

    public static int getLastBufferLineNr() {
        return HopLogStore.getInstance().appender.getLastBufferLineNr();
    }

    public static List<HopLoggingEvent> getLogBufferFromTo(String parentLogChannelId, boolean includeGeneral, int from, int to) {
        return HopLogStore.getInstance().appender.getLogBufferFromTo(parentLogChannelId, includeGeneral, from, to);
    }

    public static List<HopLoggingEvent> getLogBufferFromTo(List<String> channelId, boolean includeGeneral, int from, int to) {
        return HopLogStore.getInstance().appender.getLogBufferFromTo(channelId, includeGeneral, from, to);
    }

    public static LoggingBuffer getAppender() {
        return HopLogStore.getInstance().appender;
    }

    public static void discardLines(String parentLogChannelId, boolean includeGeneralMessages) {
        LoggingRegistry registry = LoggingRegistry.getInstance();
        MetricsRegistry metricsRegistry = MetricsRegistry.getInstance();
        List<String> ids = registry.getLogChannelChildren(parentLogChannelId);
        if (ids == null) {
            return;
        }
        LoggingBuffer bufferAppender = HopLogStore.getInstance().appender;
        for (String id : ids) {
            bufferAppender.removeChannelFromBuffer(id);
            registry.getMap().remove(id);
            metricsRegistry.getSnapshotLists().remove(id);
            metricsRegistry.getSnapshotMaps().remove(id);
        }
        if (includeGeneralMessages) {
            bufferAppender.removeGeneralMessages();
        }
    }

    public static boolean isInitialized() {
        return initialized.get();
    }

    public void reset() {
        if (initialized.compareAndSet(true, false)) {
            this.appender = null;
            if (this.logCleanerTimer != null) {
                this.logCleanerTimer.cancel();
                this.logCleanerTimer = null;
            }
            store = null;
        }
    }

    static {
        initialized = new AtomicBoolean(false);
        logChannelFactory = new LogChannelFactory();
    }
}

