/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.net.jpountz.lz4;

import com.clickhouse.client.internal.net.jpountz.lz4.LZ4Exception;
import com.clickhouse.client.internal.net.jpountz.lz4.LZ4Factory;
import com.clickhouse.client.internal.net.jpountz.lz4.LZ4FastDecompressor;
import com.clickhouse.client.internal.net.jpountz.lz4.LZ4JNI;
import com.clickhouse.client.internal.net.jpountz.util.ByteBufferUtils;
import com.clickhouse.client.internal.net.jpountz.util.SafeUtils;
import java.nio.ByteBuffer;

final class LZ4JNIFastDecompressor
extends LZ4FastDecompressor {
    public static final LZ4JNIFastDecompressor INSTANCE = new LZ4JNIFastDecompressor();
    private static LZ4FastDecompressor SAFE_INSTANCE;

    LZ4JNIFastDecompressor() {
    }

    @Override
    public final int decompress(byte[] src, int srcOff, byte[] dest, int destOff, int destLen) {
        int srcLen = src.length - srcOff;
        SafeUtils.checkRange(src, srcOff, srcLen);
        SafeUtils.checkRange(dest, destOff, destLen);
        if (srcLen == 0) {
            throw new LZ4Exception("Empty src");
        }
        int result = LZ4JNI.LZ4_decompress_fast(src, null, srcOff, dest, null, destOff, destLen);
        if (result < 0) {
            throw new LZ4Exception("Error decoding offset " + (srcOff - result) + " of input buffer");
        }
        return result;
    }

    @Override
    public int decompress(ByteBuffer src, int srcOff, ByteBuffer dest, int destOff, int destLen) {
        ByteBufferUtils.checkNotReadOnly(dest);
        int srcLen = src.capacity() - srcOff;
        ByteBufferUtils.checkRange(src, srcOff, srcLen);
        ByteBufferUtils.checkRange(dest, destOff, destLen);
        if (srcLen == 0) {
            throw new LZ4Exception("Empty src");
        }
        if ((src.hasArray() || src.isDirect()) && (dest.hasArray() || dest.isDirect())) {
            byte[] srcArr = null;
            byte[] destArr = null;
            ByteBuffer srcBuf = null;
            ByteBuffer destBuf = null;
            if (src.hasArray()) {
                srcArr = src.array();
                srcOff += src.arrayOffset();
            } else {
                assert (src.isDirect());
                srcBuf = src;
            }
            if (dest.hasArray()) {
                destArr = dest.array();
                destOff += dest.arrayOffset();
            } else {
                assert (dest.isDirect());
                destBuf = dest;
            }
            int result = LZ4JNI.LZ4_decompress_fast(srcArr, srcBuf, srcOff, destArr, destBuf, destOff, destLen);
            if (result < 0) {
                throw new LZ4Exception("Error decoding offset " + (srcOff - result) + " of input buffer");
            }
            return result;
        }
        LZ4FastDecompressor safeInstance = SAFE_INSTANCE;
        if (safeInstance == null) {
            safeInstance = SAFE_INSTANCE = LZ4Factory.safeInstance().fastDecompressor();
        }
        return safeInstance.decompress(src, srcOff, dest, destOff, destLen);
    }
}

