/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.execcql;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.type.DataType;
import java.util.Iterator;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.databases.cassandra.datastax.DriverConnection;
import org.apache.hop.databases.cassandra.datastax.DriverCqlRowHandler;
import org.apache.hop.databases.cassandra.datastax.TableMetaData;
import org.apache.hop.databases.cassandra.metadata.CassandraConnection;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;

@Action(id="CASSANDRA_EXEC_CQL", name="Cassandra Execute CQL", description="Execute CQL statements against a Cassandra cluster", image="Cassandra_logo.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Scripting", keywords={"i18n::ExecCql.keyword"}, documentationUrl="/workflow/actions/cassandra-exec-cql.html")
public class ExecCql
extends ActionBase
implements IAction {
    @HopMetadataProperty(key="connection")
    private String connectionName;
    @HopMetadataProperty(key="script")
    private String script;
    @HopMetadataProperty(key="replace_variables")
    private boolean replacingVariables;

    public ExecCql() {
        this("", "");
    }

    public ExecCql(String name) {
        this(name, "");
    }

    public ExecCql(String name, String description) {
        super(name, description);
    }

    public Result execute(Result result, int nr) throws HopException {
        CassandraConnection cassandraConnection;
        IHopMetadataSerializer serializer = this.getMetadataProvider().getSerializer(CassandraConnection.class);
        String realConnectionName = this.resolve(this.connectionName);
        try {
            if (StringUtils.isEmpty((String)realConnectionName)) {
                throw new HopException("A Cassandra cassandraConnection name is not defined");
            }
            cassandraConnection = (CassandraConnection)serializer.load(realConnectionName);
            if (cassandraConnection == null) {
                throw new HopException("Unable to find Cassandra cassandraConnection with name '" + realConnectionName + "'");
            }
        }
        catch (Exception e) {
            result.setResult(false);
            result.increaseErrors(1L);
            throw new HopException("Unable to load or find a Cassandra cassandraConnection with name '" + realConnectionName + "'", (Throwable)e);
        }
        String cqlStatements = this.replacingVariables ? this.resolve(this.script) : this.script;
        int nrExecuted = ExecCql.executeCqlStatements((IVariables)this, this.getLogChannel(), result, cassandraConnection, cqlStatements);
        if (result.getNrErrors() == 0L) {
            if (this.isBasic()) {
                this.logBasic("Cassandra executed " + nrExecuted + " CQL commands without error");
            }
        } else if (this.isBasic()) {
            this.logBasic("Cassandra Exec CQL: some command(s) executed with error(s)");
        }
        return result;
    }

    public static int executeCqlStatements(IVariables variables, ILogChannel log, Result result, CassandraConnection cassandraConnection, String cqlStatements) throws HopException {
        int nrExecuted = 0;
        try (DriverConnection connection = cassandraConnection.createConnection(variables, true);
             CqlSession session = connection.open();){
            try {
                String[] commands;
                for (String command : commands = cqlStatements.split("\\r?\\n;")) {
                    String cql = command.replaceFirst("^\\s+", "").replaceFirst("\\s+$", "");
                    if (!StringUtils.isNotEmpty((String)cql)) continue;
                    ResultSet resultSet = session.execute(cql);
                    Iterator iterator = resultSet.iterator();
                    IRowMeta resultRowMeta = null;
                    while (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        if (resultRowMeta == null) {
                            resultRowMeta = ExecCql.getRowMeta(row.getColumnDefinitions());
                        }
                        Object[] resultRowData = DriverCqlRowHandler.readRow(resultRowMeta, row);
                        result.getRows().add(new RowMetaAndData(resultRowMeta, resultRowData));
                    }
                    while (!resultSet.wasApplied()) {
                        Thread.sleep(50L);
                    }
                    ++nrExecuted;
                    if (!log.isDetailed()) continue;
                    log.logDetailed("Executed cql statement: " + cql);
                }
            }
            catch (Exception e) {
                log.logError("Error executing CQL statements...", (Throwable)e);
                result.increaseErrors(1L);
                result.setResult(false);
            }
        }
        catch (Exception e) {
            throw new HopException("Error executing CQL on Cassandra connection " + cassandraConnection.getName(), (Throwable)e);
        }
        return nrExecuted;
    }

    public static IRowMeta getRowMeta(ColumnDefinitions columnDefinitions) {
        RowMeta rowMeta = new RowMeta();
        for (int i = 0; i < columnDefinitions.size(); ++i) {
            ColumnDefinition columnDefinition = columnDefinitions.get(i);
            DataType dataType = columnDefinition.getType();
            String name = columnDefinition.getName().asCql(false);
            if (name.startsWith("\"")) {
                name = name.substring(1);
            }
            if (name.endsWith("\"")) {
                name = name.substring(0, name.length() - 1);
            }
            IValueMeta valueMeta = TableMetaData.toValueMeta(name, dataType);
            rowMeta.addValueMeta(valueMeta);
        }
        return rowMeta;
    }

    public String getDialogClassName() {
        return super.getDialogClassName();
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    @Generated
    public String getConnectionName() {
        return this.connectionName;
    }

    @Generated
    public String getScript() {
        return this.script;
    }

    @Generated
    public boolean isReplacingVariables() {
        return this.replacingVariables;
    }

    @Generated
    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    @Generated
    public void setScript(String script) {
        this.script = script;
    }

    @Generated
    public void setReplacingVariables(boolean replacingVariables) {
        this.replacingVariables = replacingVariables;
    }
}

