/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceMetaData;
import java.awt.Component;
import java.awt.Image;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;

class ResourceCellRenderer
extends JLabel
implements ListCellRenderer,
TableCellRenderer,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static Border emptyBorder_ = new EmptyBorder(1, 2, 1, 2);
    private ResourceMetaData metaData_ = null;

    public ResourceCellRenderer(ResourceMetaData metaData) {
        this.metaData_ = metaData;
        this.setOpaque(true);
        if (metaData != null) {
            if (Number.class.isAssignableFrom(metaData.getType())) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
        } else {
            this.setHorizontalAlignment(2);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int rowIndex, boolean selected, boolean hasFocus) {
        this.setTextAndIcon(value);
        if (selected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        if (hasFocus) {
            this.setBorder(new LineBorder(list.getForeground()));
        } else {
            this.setBorder(emptyBorder_);
        }
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int rowIndex, int columnIndex) {
        this.setTextAndIcon(value);
        if (selected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (hasFocus) {
            this.setBorder(new LineBorder(table.getForeground()));
        } else {
            this.setBorder(emptyBorder_);
        }
        return this;
    }

    private void setTextAndIcon(Object value) {
        if (value != null) {
            Presentation presentation;
            Resource resource;
            Presentation presentation2;
            if (value instanceof Resource && (presentation2 = (resource = (Resource)value).getPresentation()) != null) {
                this.setTextAndIcon(presentation2);
                return;
            }
            if (this.metaData_ != null && (presentation = this.metaData_.getPossibleValuePresentation(value)) != null) {
                this.setTextAndIcon(presentation);
                return;
            }
            this.setText(value.toString());
            this.setIcon(null);
        }
    }

    private void setTextAndIcon(Presentation presentation) {
        this.setText(presentation.getName());
        Image icon = (Image)presentation.getValue("16");
        if (icon != null) {
            this.setIcon(new ImageIcon(icon));
        } else {
            this.setIcon(null);
        }
    }
}

