/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDSplF;
import com.ibm.as400.access.OutputQueue;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectInputStream;
import com.ibm.as400.access.PrintObjectPageInputStream;
import com.ibm.as400.access.PrintObjectTransformedInputStream;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class SpooledFile
extends PrintObject
implements Serializable {
    static final long serialVersionUID = 4L;
    transient boolean fMsgRetrieved_ = false;

    SpooledFile(AS400 system, NPCPIDSplF id, NPCPAttribute attrs) {
        super(system, id, attrs, 1);
    }

    public SpooledFile(AS400 system, String name, int number, String jobName, String jobUser, String jobNumber) {
        super(system, new NPCPIDSplF(name, number, jobName, jobUser, jobNumber), null, 1);
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (number < -1) {
            Trace.log(2, "Parameter 'number' is less than -1.");
            throw new ExtendedIllegalArgumentException("number(" + number + ")", 2);
        }
        if (jobName == null) {
            Trace.log(2, "Parameter 'jobName' is null.");
            throw new NullPointerException("jobName");
        }
        if (jobUser == null) {
            Trace.log(2, "Parameter 'jobUser' is null.");
            throw new NullPointerException("jobUser");
        }
        if (jobNumber == null) {
            Trace.log(2, "Parameter 'jobNumber' is null.");
            throw new NullPointerException("jobNumber");
        }
    }

    public SpooledFile(AS400 system, String name, int number, String jobName, String jobUser, String jobNumber, String jobSysName, String createDate, String createTime) {
        super(system, new NPCPIDSplF(name, number, jobName, jobUser, jobNumber, jobSysName, createDate, createTime), null, 1);
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (number < -1) {
            Trace.log(2, "Parameter 'number' is less than -1.");
            throw new ExtendedIllegalArgumentException("number(" + number + ")", 2);
        }
        if (jobName == null) {
            Trace.log(2, "Parameter 'jobName' is null.");
            throw new NullPointerException("jobName");
        }
        if (jobUser == null) {
            Trace.log(2, "Parameter 'jobUser' is null.");
            throw new NullPointerException("jobUser");
        }
        if (jobNumber == null) {
            Trace.log(2, "Parameter 'jobNumber' is null.");
            throw new NullPointerException("jobNumber");
        }
        if (jobSysName == null) {
            Trace.log(2, "Parameter 'jobSysName' is null.");
            throw new NullPointerException("jobSysName");
        }
        if (createDate == null) {
            Trace.log(2, "Parameter 'createDate' is null.");
            throw new NullPointerException("createDate");
        }
        if (createTime == null) {
            Trace.log(2, "Parameter 'createTime' is null.");
            throw new NullPointerException("createTime");
        }
    }

    public void answerMessage(String reply) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).answerMessage(reply);
        this.attrs = this.impl_.getAttrValue();
        this.fMsgRetrieved_ = ((SpooledFileImpl)this.impl_).getFMsgRetrieved();
    }

    @Override
    void chooseImpl() throws IOException, AS400SecurityException {
        AS400 system = this.getSystem();
        if (system == null) {
            Trace.log(2, "Attempt to use SpooledFile before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (SpooledFileImpl)system.loadImpl2("com.ibm.as400.access.SpooledFileImplRemote", "com.ibm.as400.access.SpooledFileImplProxy");
        super.setImpl();
    }

    public SpooledFile copy() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        String name = this.getStringAttribute(-6);
        OutputQueue outq = new OutputQueue(this.getSystem(), name);
        SpooledFile sf = this.copy(outq);
        return sf;
    }

    public SpooledFile copy(OutputQueue outputQueue) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPCPIDSplF spID;
        block4: {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            if (outputQueue.getImpl() == null) {
                outputQueue.chooseImpl();
            }
            spID = ((SpooledFileImpl)this.impl_).copy((OutputQueueImpl)outputQueue.getImpl());
            try {
                spID.setConverter(new Converter((int)this.getSystem().getCcsid(), (AS400)this.getSystem()).impl);
            }
            catch (UnsupportedEncodingException e) {
                if (!Trace.isTraceErrorOn()) break block4;
                Trace.log(2, "Error initializing converter for spooled file.");
            }
        }
        SpooledFile sf = new SpooledFile(this.getSystem(), spID, null);
        return sf;
    }

    public void delete() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).delete();
    }

    public PrintObjectInputStream getInputStream() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        PrintObjectInputStream is = new PrintObjectInputStream(this, null);
        return is;
    }

    public PrintObjectInputStream getInputStream(PrintParameterList ppl) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        PrintObjectInputStream is = new PrintObjectInputStream(this, ppl);
        return is;
    }

    public PrintObjectInputStream getInputACIFMergedStream(boolean acifB) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        String acifS = acifB ? "Y" : "N";
        PrintObjectInputStream is = new PrintObjectInputStream(this, null, acifS);
        return is;
    }

    public PrintObjectInputStream getAFPInputStream() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        PrintObjectInputStream is = new PrintObjectInputStream(this, null, "Y");
        return is;
    }

    public String getJobName() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return "";
        }
        return IDCodePoint.getStringValue(59);
    }

    public String getJobNumber() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return "";
        }
        return IDCodePoint.getStringValue(60);
    }

    public String getJobUser() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return "";
        }
        return IDCodePoint.getStringValue(62);
    }

    public String getJobSysName() {
        String jobSysName = "";
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return jobSysName;
        }
        jobSysName = IDCodePoint.getStringValue(251);
        if (jobSysName == null) {
            try {
                jobSysName = this.getStringAttribute(251);
            }
            catch (Exception e) {
                jobSysName = "";
            }
        }
        return jobSysName;
    }

    public String getCreateDate() {
        String createDate = "";
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return createDate;
        }
        createDate = IDCodePoint.getStringValue(34);
        if (createDate == null) {
            try {
                createDate = this.getStringAttribute(34);
            }
            catch (Exception e) {
                createDate = "";
            }
        }
        return createDate;
    }

    public String getCreateTime() {
        String createTime = "";
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return createTime;
        }
        createTime = IDCodePoint.getStringValue(110);
        if (createTime == null) {
            try {
                createTime = this.getStringAttribute(110);
            }
            catch (Exception e) {
                createTime = "";
            }
        }
        return createTime;
    }

    public AS400Message getMessage() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        AS400Message msg = ((SpooledFileImpl)this.impl_).getMessage();
        this.fMsgRetrieved_ = ((SpooledFileImpl)this.impl_).getFMsgRetrieved();
        return msg;
    }

    public String getName() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return "";
        }
        return IDCodePoint.getStringValue(104);
    }

    public int getNumber() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return 0;
        }
        return IDCodePoint.getIntValue(105);
    }

    public PrintObjectPageInputStream getPageInputStream(PrintParameterList pageStreamOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        PrintObjectPageInputStream is = new PrintObjectPageInputStream(this, pageStreamOptions);
        return is;
    }

    public PrintObjectTransformedInputStream getTransformedInputStream(PrintParameterList transformOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        PrintObjectTransformedInputStream is = new PrintObjectTransformedInputStream(this, transformOptions);
        return is;
    }

    public void hold(String holdType) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).hold(holdType);
        this.attrs = this.impl_.getAttrValue();
    }

    public void move(SpooledFile targetSpooledFile) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (targetSpooledFile.getImpl() == null) {
            targetSpooledFile.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).move((SpooledFileImpl)targetSpooledFile.getImpl());
        this.attrs = this.impl_.getAttrValue();
    }

    public void move(OutputQueue targetOutputQueue) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (targetOutputQueue.getImpl() == null) {
            targetOutputQueue.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).move((OutputQueueImpl)targetOutputQueue.getImpl());
        this.attrs = this.impl_.getAttrValue();
    }

    public void moveToTop() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).moveToTop();
        this.attrs = this.impl_.getAttrValue();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fMsgRetrieved_ = false;
    }

    public void release() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).release();
        this.attrs = this.impl_.getAttrValue();
    }

    public void sendNet(PrintParameterList sendOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).sendNet(sendOptions);
    }

    public void sendTCP(PrintParameterList sendOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).sendTCP(sendOptions);
    }

    public void setAttributes(PrintParameterList attributes) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (attributes == null) {
            Trace.log(2, "Parameter 'attributes' is null.");
            throw new NullPointerException("attributes");
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).setAttributes(attributes);
        if (this.attrs == null) {
            this.attrs = new NPCPAttribute();
        }
        this.attrs = this.impl_.getAttrValue();
    }
}

