/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PTFGroup;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class PTFGroupList {
    private AS400 system_;

    public PTFGroupList(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.setSystem(system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTFGroup[] getPTFGroup() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        try {
            int ccsid = this.system_.getCcsid();
            ConvTable conv = ConvTable.getTable(ccsid, null);
            ProgramParameter[] parms = new ProgramParameter[4];
            parms[0] = new ProgramParameter(conv.stringToByteArray("JT4PTF    QTEMP     "));
            parms[0].setParameterType(2);
            parms[1] = new ProgramParameter(conv.stringToByteArray("LSTG0100"));
            parms[1].setParameterType(2);
            parms[2] = new ProgramParameter(BinaryConverter.intToByteArray(ccsid));
            parms[2].setParameterType(2);
            parms[3] = new ProgramParameter(new byte[4]);
            parms[3].setParameterType(2);
            ServiceProgramCall pc = new ServiceProgramCall(this.system_, "/QSYS.LIB/QPZGROUP.SRVPGM", "QpzListPtfGroups", 0, parms);
            boolean willRunProgramsOnThread = pc.isStayOnThread();
            Object lockObject = willRunProgramsOnThread ? "JT4PTF    QTEMP     " : this.system_;
            byte[] buf = null;
            Object object = lockObject;
            synchronized (object) {
                UserSpace us = new UserSpace(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4PTF.USRSPC");
                us.setMustUseProgramCall(true);
                if (!willRunProgramsOnThread) {
                    us.setMustUseSockets(true);
                }
                try {
                    us.create(262144, true, "", (byte)0, "User space for PTF Group list", "*EXCLUDE");
                    if (!pc.run()) {
                        throw new AS400Exception(pc.getMessageList());
                    }
                    int size = us.getLength();
                    buf = new byte[size];
                    us.read(buf, 0);
                }
                finally {
                    try {
                        us.delete();
                    }
                    catch (Exception e) {
                        Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                    }
                }
            }
            int startingOffset = BinaryConverter.byteArrayToInt(buf, 124);
            int numEntries = BinaryConverter.byteArrayToInt(buf, 132);
            int entrySize = BinaryConverter.byteArrayToInt(buf, 136);
            int entryCCSID = BinaryConverter.byteArrayToInt(buf, 140);
            conv = ConvTable.getTable(entryCCSID, null);
            int offset = 0;
            PTFGroup[] ptfs = new PTFGroup[numEntries];
            for (int i = 0; i < numEntries; ++i) {
                offset = startingOffset + i * entrySize;
                String ptfGroupName = conv.byteArrayToString(buf, offset, 60);
                String ptfGroupDescription = conv.byteArrayToString(buf, offset += 60, 100);
                int ptfGroupLevel = BinaryConverter.byteArrayToInt(buf, offset += 100);
                int ptfGroupStatus = BinaryConverter.byteArrayToInt(buf, offset += 4);
                String targetRelease = conv.byteArrayToString(buf, offset += 4, 6);
                offset += 6;
                ptfs[i] = new PTFGroup(this.system_, ptfGroupName, ptfGroupDescription, ptfGroupLevel, ptfGroupStatus, targetRelease);
            }
            return ptfs;
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
            throw new InternalErrorException(10, (Throwable)pve);
        }
    }

    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    public AS400 getSystem() {
        return this.system_;
    }
}

