/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;

public class NPDataAnalyzer {
    static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String DT_AFPDS = "*AFPDS";
    private static final String DT_USERASCII = "*USERASCII";
    private static final String DT_SCS = "*SCS";
    static final byte ASCII_TRNSPRNT_CC = 3;
    static final byte BACKSPACE_CC = 22;
    static final byte UNITBACKSPACE_CC = 26;
    static final byte BEL_CC = 47;
    static final byte CARRIAGE_RETURN_CC = 13;
    static final byte ENABLE_PRESENTATION_CC = 20;
    static final byte EXPANDED_BACKSPACE_CC = 54;
    static final byte FORM_FEED_CC = 12;
    static final byte GRAPHIC_ESCAPE_CC = 8;
    static final byte HORIZONTAL_TAB_CC = 5;
    static final byte INDENT_TAB_CC = 57;
    static final byte INDEX_RETURN_CC = 51;
    static final byte INHIBIT_PRESENTATION_CC = 36;
    static final byte INTERCHANGE_RECORD_SEPARATOR_CC = 30;
    static final byte LINE_FEED_CC = 37;
    static final byte NEW_LINE_CC = 21;
    static final byte NULL_CC = 0;
    static final byte PRESENTATION_POSITION_CC = 52;
    static final byte REQUIRED_FORM_FEED_CC = 58;
    static final byte REQUIRED_NEW_LINE_CC = 6;
    static final byte SPACE_CC = 64;
    static final byte REQUIRED_SPACE_CC = 65;
    static final byte SET_ATTRIBUTE_CC = 40;
    static final byte SHIFT_OUT_CC = 14;
    static final byte SHIFT_IN_CC = 15;
    static final byte SWITCH_CC = 42;
    static final byte CSP_CC = 43;
    static final byte SUBSTITUTE_CC = 63;
    static final byte GRAPHIC_ERROR_ACTION_CC = -56;
    static final byte HORIZONTAL_FORMAT_CC = -63;
    static final byte LINE_DENSITY_CC = -58;
    static final byte NUMERIC_SPACE_CC = -31;
    static final byte SUBSCRIPT_CC = 56;
    static final byte SUPERSCRIPT_CC = 9;
    static final byte SYLLABLE_HYPHEN_CC = -54;
    static final byte TRANSPARENT_CC = 53;
    static final byte VERTICAL_CHANNEL_SELECT_CC = 4;
    static final byte VERTICAL_TAB_CC = 11;
    static final byte WORD_UNDERSCORE_CC = 35;
    static final byte FONTCLASS = -47;
    static final byte SCG_CC = 1;
    static final byte SCGL_CC = -127;
    static final byte SFG_CC = 5;
    static final byte BES_CC = -118;
    static final byte EES_CC = -114;
    static final byte DOGTWO = -46;
    static final byte STAB_CC = 1;
    static final byte JUSTIFY_TEXTFIELD_CC = 3;
    static final byte SET_INDENTLV_CC = 7;
    static final byte SET_LINESPACE_CC = 9;
    static final byte RELEASE_LEFT_MARGIN_CC = 11;
    static final byte SET_JUSTIFYMODE_CC = 13;
    static final byte SET_HORZMARGINS_CC = 17;
    static final byte SET_LINEDISTANCE_CC = 21;
    static final byte PRINT_DENSITY_CC = 41;
    static final byte SET_PRESCOLOR_CC = 45;
    static final byte SET_PRESPAGESIZE_CC = 64;
    static final byte SET_INITCOND_CC = 69;
    static final byte SET_PPAGEMEDIA_CC = 72;
    static final byte SET_VERTMARGINS_CC = 73;
    static final byte SET_PRINTERSETUP_CC = 76;
    static final byte SET_ERROR_ACTION_CC = -123;
    static final byte VERTICAL_FORMAT_CC = -62;
    static final byte DOGTHREE = -45;
    static final byte STO_CC = -10;
    static final byte DOGFOUR = -44;
    static final byte BUS_CC = 10;
    static final byte EUS_CC = 14;
    static final byte BOS_CC = 114;
    static final byte EOS_CC = 118;
    static final byte FOXDOG = -3;
    static final byte DGL_CC = 0;
    static final byte SIT_CC = 1;
    static final byte SFSS_CC = 2;
    static final byte SPCC_CC = 3;
    static final byte PP_STRUCT_LEN = 3;
    static final byte PPCODE_AHPP = -64;
    static final byte PPCODE_AVPP = -60;
    static final byte PPCODE_RHPP = -56;
    static final byte PPCODE_RVPP = 76;
    static final byte SA_STRUCT_LEN = 3;
    static final byte ATTR_RESET = 0;
    static final byte ATTR_COLOR = 66;
    static final byte ATTR_HILITE = 65;
    static final byte ATTR_CHAR_SET = 67;

    private static boolean dataIsAFP(byte[] buf, int offset, int len) {
        boolean fRC = false;
        boolean fDone = false;
        int tempOffset = offset;
        while (tempOffset < len && !fDone) {
            if (buf[tempOffset] == 90) {
                if (tempOffset != offset) {
                    fRC = true;
                }
                if (len - tempOffset >= 3) {
                    int tempLen = BinaryConverter.byteArrayToUnsignedShort(buf, ++tempOffset);
                    tempOffset += tempLen;
                    if (tempLen >= 5) continue;
                    fDone = true;
                    fRC = false;
                    continue;
                }
                fDone = true;
                continue;
            }
            fRC = false;
            fDone = true;
        }
        return fRC;
    }

    private static boolean dataIsSCS(byte[] buf, int offset, int len) {
        boolean fRC = false;
        boolean fDone = false;
        while (len > 0 && !fDone) {
            int nextByte = buf[offset] & 0xFF;
            if (nextByte < 64) {
                block0 : switch (nextByte) {
                    case 0: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 26: 
                    case 30: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 42: 
                    case 47: 
                    case 51: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 63: {
                        ++offset;
                        --len;
                        break;
                    }
                    case 52: {
                        if (len >= 3) {
                            switch (buf[offset + 1]) {
                                case -64: 
                                case -60: 
                                case -56: 
                                case 76: {
                                    offset += 3;
                                    len -= 3;
                                    fRC = true;
                                    break block0;
                                }
                            }
                            fRC = false;
                            fDone = true;
                            break;
                        }
                        fDone = true;
                        break;
                    }
                    case 40: {
                        if (len >= 3) {
                            switch (buf[offset + 1]) {
                                case 67: {
                                    offset += 3;
                                    len -= 3;
                                    fRC = true;
                                    break block0;
                                }
                            }
                            fRC = false;
                            fDone = true;
                            break;
                        }
                        fDone = true;
                        break;
                    }
                    case 43: {
                        if (len >= 3 && len >= buf[offset + 2] + 2) {
                            byte count = buf[offset + 2];
                            switch (buf[offset + 1]) {
                                case -63: 
                                case -62: 
                                case -58: 
                                case -56: {
                                    len -= count + 2;
                                    offset += count + 2;
                                    fRC = true;
                                    break block0;
                                }
                                case -47: {
                                    switch (buf[offset + 3]) {
                                        case -127: 
                                        case -118: 
                                        case -114: 
                                        case 1: 
                                        case 5: {
                                            len -= count + 2;
                                            offset += count + 2;
                                            fRC = true;
                                            break block0;
                                        }
                                    }
                                    fRC = false;
                                    fDone = true;
                                    break block0;
                                }
                                case -46: {
                                    switch (buf[offset + 3]) {
                                        case -123: 
                                        case 1: 
                                        case 3: 
                                        case 7: 
                                        case 9: 
                                        case 11: 
                                        case 13: 
                                        case 17: 
                                        case 21: 
                                        case 41: 
                                        case 45: 
                                        case 64: 
                                        case 69: 
                                        case 72: 
                                        case 73: 
                                        case 76: {
                                            len -= count + 2;
                                            offset += count + 2;
                                            fRC = true;
                                            break block0;
                                        }
                                    }
                                    fRC = false;
                                    fDone = true;
                                    break block0;
                                }
                                case -45: {
                                    switch (buf[offset + 3]) {
                                        case -10: {
                                            len -= count + 2;
                                            offset += count + 2;
                                            fRC = true;
                                            break block0;
                                        }
                                    }
                                    fRC = false;
                                    fDone = true;
                                    break block0;
                                }
                                case -44: {
                                    switch (buf[offset + 3]) {
                                        case 10: 
                                        case 14: 
                                        case 114: 
                                        case 118: {
                                            len -= count + 2;
                                            offset += count + 2;
                                            fRC = true;
                                            break block0;
                                        }
                                    }
                                    fRC = false;
                                    fDone = true;
                                    break block0;
                                }
                                case -3: {
                                    switch (buf[offset + 3]) {
                                        case 0: 
                                        case 1: 
                                        case 2: 
                                        case 3: {
                                            len -= count + 2;
                                            offset += count + 2;
                                            fRC = true;
                                            break block0;
                                        }
                                    }
                                    fRC = false;
                                    fDone = true;
                                    break block0;
                                }
                            }
                            fRC = false;
                            fDone = true;
                            break;
                        }
                        fDone = true;
                        break;
                    }
                    case 3: 
                    case 53: {
                        if (len >= 2 && len >= buf[offset + 1] + 2) {
                            len -= buf[offset + 1] + 2;
                            offset += buf[offset + 1] + 2;
                            fRC = true;
                            break;
                        }
                        fDone = true;
                        break;
                    }
                    default: {
                        fRC = false;
                        fDone = true;
                        break;
                    }
                }
                continue;
            }
            --len;
            ++offset;
        }
        return fRC;
    }

    public static String sniff(byte[] buf, int offset, int len) {
        String str = DT_USERASCII;
        if (NPDataAnalyzer.dataIsAFP(buf, offset, len)) {
            str = DT_AFPDS;
        } else if (NPDataAnalyzer.dataIsSCS(buf, offset, len)) {
            str = DT_SCS;
        }
        return str;
    }
}

