/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400Boolean
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final int SIZE = 1;
    private static final boolean DEFAULT_VALUE = false;
    private static final byte SYSTEM_FALSE = -16;
    private static final byte SYSTEM_TRUE = -15;

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    @Override
    public int getByteLength() {
        return 1;
    }

    @Override
    public Object getDefaultValue() {
        return false;
    }

    @Override
    public int getInstanceType() {
        return 21;
    }

    @Override
    public Class getJavaType() {
        return Boolean.class;
    }

    @Override
    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[]{(Boolean)javaValue != false ? (byte)-15 : -16};
        return as400Value;
    }

    public byte[] toBytes(boolean booleanValue) {
        byte[] as400Value = new byte[]{booleanValue ? (byte)-15 : -16};
        return as400Value;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value) {
        as400Value[0] = (Boolean)javaValue != false ? -15 : -16;
        return 1;
    }

    public int toBytes(boolean booleanValue, byte[] as400Value) {
        as400Value[0] = booleanValue ? -15 : -16;
        return 1;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        as400Value[offset] = (Boolean)javaValue != false ? -15 : -16;
        return 1;
    }

    public int toBytes(boolean booleanValue, byte[] as400Value, int offset) {
        as400Value[offset] = booleanValue ? -15 : -16;
        return 1;
    }

    @Override
    public Object toObject(byte[] as400Value) {
        return this.toObject(as400Value, 0);
    }

    @Override
    public Object toObject(byte[] as400Value, int offset) {
        if (as400Value[offset] == -15) {
            return new Boolean(true);
        }
        if (as400Value[offset] == -16) {
            return new Boolean(false);
        }
        throw new ArithmeticException("Unable to create boolean from 0x" + Integer.toHexString(0xFF & as400Value[offset]));
    }

    public boolean toBoolean(byte[] as400Value) {
        return this.toBoolean(as400Value, 0);
    }

    public boolean toBoolean(byte[] as400Value, int offset) {
        if (as400Value[offset] == -15) {
            return true;
        }
        if (as400Value[offset] == -16) {
            return false;
        }
        throw new ArithmeticException("Unable to create boolean from 0x" + Integer.toHexString(0xFF & as400Value[0]));
    }
}

